/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLException;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.ByteBufferInputStream;
import sun.security.ssl.CipherBox;
import sun.security.ssl.Debug;
import sun.security.ssl.InputRecord;
import sun.security.ssl.MAC;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLEngineImpl;

final class EngineInputRecord
extends InputRecord {
    private SSLEngineImpl engine;
    private static ByteBuffer tmpBB = ByteBuffer.allocate(0);
    private boolean internalData;

    EngineInputRecord(SSLEngineImpl sSLEngineImpl) {
        this.engine = sSLEngineImpl;
    }

    byte contentType() {
        if (this.internalData) {
            return super.contentType();
        }
        return 23;
    }

    int bytesInCompletePacket(ByteBuffer byteBuffer) throws SSLException {
        if (byteBuffer.remaining() < 5) {
            return -1;
        }
        int n = byteBuffer.position();
        byte by = byteBuffer.get(n);
        int n2 = 0;
        if (this.formatVerified || by == 22 || by == 21) {
            ProtocolVersion protocolVersion = ProtocolVersion.valueOf((int)byteBuffer.get(n + 1), (int)byteBuffer.get(n + 2));
            if (protocolVersion.v < ProtocolVersion.MIN.v || protocolVersion.major > ProtocolVersion.MAX.major) {
                throw new SSLException("Unsupported record version " + (Object)((Object)protocolVersion));
            }
            this.formatVerified = true;
            n2 = ((byteBuffer.get(n + 3) & 0xFF) << 8) + (byteBuffer.get(n + 4) & 0xFF) + 5;
        } else {
            boolean bl;
            boolean bl2 = bl = (by & 0x80) != 0;
            if (bl && (byteBuffer.get(n + 2) == 1 || byteBuffer.get(n + 2) == 4)) {
                ProtocolVersion protocolVersion = ProtocolVersion.valueOf((int)byteBuffer.get(n + 3), (int)byteBuffer.get(n + 4));
                if ((protocolVersion.v < ProtocolVersion.MIN.v || protocolVersion.major > ProtocolVersion.MAX.major) && protocolVersion.v != ProtocolVersion.SSL20Hello.v) {
                    throw new SSLException("Unsupported record version " + (Object)((Object)protocolVersion));
                }
                int n3 = bl ? 127 : 63;
                n2 = ((by & n3) << 8) + (byteBuffer.get(n + 1) & 0xFF) + (bl ? 2 : 3);
            } else {
                throw new SSLException("Unrecognized SSL message, plaintext connection?");
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer decrypt(MAC mAC, CipherBox cipherBox, ByteBuffer byteBuffer) throws BadPaddingException {
        if (this.internalData) {
            this.decrypt(mAC, cipherBox);
            return tmpBB;
        }
        BadPaddingException badPaddingException = null;
        int n = mAC.MAClen();
        int n2 = byteBuffer.remaining();
        if (!cipherBox.isNullCipher()) {
            if (!cipherBox.sanityCheck(n, n2)) {
                throw new BadPaddingException("ciphertext sanity check failed");
            }
            try {
                cipherBox.decrypt(byteBuffer, n);
            }
            catch (BadPaddingException badPaddingException2) {
                badPaddingException = badPaddingException2;
            }
            finally {
                byteBuffer.rewind();
            }
        }
        if (n != 0) {
            int n3 = byteBuffer.limit() - n;
            if (byteBuffer.remaining() < n) {
                if (badPaddingException == null) {
                    badPaddingException = new BadPaddingException("bad record");
                }
                n3 = n2 - n;
                byteBuffer.limit(n2);
            }
            if (EngineInputRecord.checkMacTags(this.contentType(), byteBuffer, mAC, false) && badPaddingException == null) {
                badPaddingException = new BadPaddingException("bad record MAC");
            }
            if (cipherBox.isCBCMode()) {
                int n4 = EngineInputRecord.calculateRemainingLen((MAC)mAC, (int)n2, (int)n3);
                if (n4 > this.buf.length) {
                    throw new RuntimeException("Internal buffer capacity error");
                }
                EngineInputRecord.checkMacTags((byte)this.contentType(), (byte[])this.buf, (int)0, (int)n4, (MAC)mAC, (boolean)true);
            }
            byteBuffer.limit(n3);
        }
        if (badPaddingException != null) {
            throw badPaddingException;
        }
        return byteBuffer.slice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkMacTags(byte by, ByteBuffer byteBuffer, MAC mAC, boolean bl) {
        int n = mAC.MAClen();
        int n2 = byteBuffer.limit();
        int n3 = n2 - n;
        byteBuffer.limit(n3);
        byte[] byArray = mAC.compute(by, byteBuffer, bl);
        if (byArray == null || n != byArray.length) {
            throw new RuntimeException("Internal MAC error");
        }
        byteBuffer.position(n3);
        byteBuffer.limit(n2);
        try {
            int[] nArray = EngineInputRecord.compareMacTags(byteBuffer, byArray);
            boolean bl2 = nArray[0] != 0;
            return bl2;
        }
        finally {
            byteBuffer.rewind();
            byteBuffer.limit(n3);
        }
    }

    private static int[] compareMacTags(ByteBuffer byteBuffer, byte[] byArray) {
        int[] nArray = new int[]{0, 0};
        for (int i = 0; i < byArray.length; ++i) {
            if (byteBuffer.get() != byArray[i]) {
                nArray[0] = nArray[0] + 1;
                continue;
            }
            nArray[1] = nArray[1] + 1;
        }
        return nArray;
    }

    void writeBuffer(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = (ByteBuffer)ByteBuffer.allocate(n2).put(byArray, 0, n2).flip();
        this.engine.writer.putOutboundDataSync(byteBuffer);
    }

    ByteBuffer read(ByteBuffer byteBuffer) throws IOException {
        Object object;
        if (!this.formatVerified || byteBuffer.get(byteBuffer.position()) != 23) {
            this.internalData = true;
            this.read(new ByteBufferInputStream(byteBuffer), null);
            return tmpBB;
        }
        this.internalData = false;
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        ProtocolVersion protocolVersion = ProtocolVersion.valueOf((int)byteBuffer.get(n + 1), (int)byteBuffer.get(n + 2));
        if (protocolVersion.v < ProtocolVersion.MIN.v || protocolVersion.major > ProtocolVersion.MAX.major) {
            throw new SSLException("Unsupported record version " + (Object)((Object)protocolVersion));
        }
        int n3 = this.bytesInCompletePacket(byteBuffer);
        assert (n3 > 0);
        if (debug != null && Debug.isOn((String)"packet")) {
            try {
                object = new HexDumpEncoder();
                byteBuffer.limit(n + n3);
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                System.out.println("[Raw read (bb)]: length = " + n3);
                object.encodeBuffer(byteBuffer2, (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byteBuffer.position(n + 5);
        byteBuffer.limit(n + n3);
        object = byteBuffer.slice();
        byteBuffer.position(byteBuffer.limit());
        byteBuffer.limit(n2);
        return object;
    }
}

