/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import sun.swing.SwingUtilities2;

public class WindowsGraphicsUtils {
    public static void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string, int n) {
        XPStyle xPStyle;
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics((JComponent)abstractButton, graphics);
        int n2 = abstractButton.getDisplayedMnemonicIndex();
        if (WindowsLookAndFeel.isMnemonicHidden()) {
            n2 = -1;
        }
        if ((xPStyle = XPStyle.getXP()) != null && !(abstractButton instanceof JMenuItem)) {
            WindowsGraphicsUtils.paintXPText(abstractButton, graphics, rectangle.x + n, rectangle.y + fontMetrics.getAscent() + n, string, n2);
        } else {
            WindowsGraphicsUtils.paintClassicText(abstractButton, graphics, rectangle.x + n, rectangle.y + fontMetrics.getAscent() + n, string, n2);
        }
    }

    static void paintClassicText(AbstractButton abstractButton, Graphics graphics, int n, int n2, String string, int n3) {
        ButtonModel buttonModel = abstractButton.getModel();
        Color color = abstractButton.getForeground();
        if (buttonModel.isEnabled()) {
            if (!(abstractButton instanceof JMenuItem && buttonModel.isArmed() || abstractButton instanceof JMenu && (buttonModel.isSelected() || buttonModel.isRollover()))) {
                graphics.setColor(abstractButton.getForeground());
            }
            SwingUtilities2.drawStringUnderlineCharAt(abstractButton, graphics, string, n3, n, n2);
        } else {
            color = UIManager.getColor("Button.shadow");
            Color color2 = UIManager.getColor("Button.disabledShadow");
            if (buttonModel.isArmed()) {
                color = UIManager.getColor("Button.disabledForeground");
            } else {
                if (color2 == null) {
                    color2 = abstractButton.getBackground().darker();
                }
                graphics.setColor(color2);
                SwingUtilities2.drawStringUnderlineCharAt(abstractButton, graphics, string, n3, n + 1, n2 + 1);
            }
            if (color == null) {
                color = abstractButton.getBackground().brighter();
            }
            graphics.setColor(color);
            SwingUtilities2.drawStringUnderlineCharAt(abstractButton, graphics, string, n3, n, n2);
        }
    }

    static void paintXPText(AbstractButton abstractButton, Graphics graphics, int n, int n2, String string, int n3) {
        TMSchema.Part part = WindowsButtonUI.getXPButtonType(abstractButton);
        TMSchema.State state = WindowsButtonUI.getXPButtonState(abstractButton);
        WindowsGraphicsUtils.paintXPText(abstractButton, part, state, graphics, n, n2, string, n3);
    }

    static void paintXPText(AbstractButton abstractButton, TMSchema.Part part, TMSchema.State state, Graphics graphics, int n, int n2, String string, int n3) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle == null) {
            return;
        }
        Color color = abstractButton.getForeground();
        if (color instanceof UIResource) {
            Object object;
            color = xPStyle.getColor((Component)abstractButton, part, state, TMSchema.Prop.TEXTCOLOR, abstractButton.getForeground());
            if (part == TMSchema.Part.TP_BUTTON && state == TMSchema.State.DISABLED && color.equals(object = xPStyle.getColor((Component)abstractButton, part, TMSchema.State.NORMAL, TMSchema.Prop.TEXTCOLOR, abstractButton.getForeground()))) {
                color = xPStyle.getColor((Component)abstractButton, TMSchema.Part.BP_PUSHBUTTON, state, TMSchema.Prop.TEXTCOLOR, color);
            }
            if ((object = xPStyle.getTypeEnum((Component)abstractButton, part, state, TMSchema.Prop.TEXTSHADOWTYPE)) == TMSchema.TypeEnum.TST_SINGLE || object == TMSchema.TypeEnum.TST_CONTINUOUS) {
                Color color2 = xPStyle.getColor((Component)abstractButton, part, state, TMSchema.Prop.TEXTSHADOWCOLOR, Color.black);
                Point point = xPStyle.getPoint((Component)abstractButton, part, state, TMSchema.Prop.TEXTSHADOWOFFSET);
                if (point != null) {
                    graphics.setColor(color2);
                    SwingUtilities2.drawStringUnderlineCharAt(abstractButton, graphics, string, n3, n + point.x, n2 + point.y);
                }
            }
        }
        graphics.setColor(color);
        SwingUtilities2.drawStringUnderlineCharAt(abstractButton, graphics, string, n3, n, n2);
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    static void repaintMnemonicsInWindow(Window window) {
        if (window == null || !window.isShowing()) {
            return;
        }
        Window[] windowArray = window.getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            WindowsGraphicsUtils.repaintMnemonicsInWindow(windowArray[i]);
        }
        WindowsGraphicsUtils.repaintMnemonicsInContainer(window);
    }

    static void repaintMnemonicsInContainer(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component == null || !component.isVisible()) continue;
            if (component instanceof AbstractButton && ((AbstractButton)component).getMnemonic() != 0) {
                component.repaint();
                continue;
            }
            if (component instanceof JLabel && ((JLabel)component).getDisplayedMnemonic() != 0) {
                component.repaint();
                continue;
            }
            if (!(component instanceof Container)) continue;
            WindowsGraphicsUtils.repaintMnemonicsInContainer((Container)component);
        }
    }
}

