/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUIAccessor;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import sun.swing.SwingUtilities2;

public class WindowsMenuItemUI
extends BasicMenuItemUI {
    final WindowsMenuItemUIAccessor accessor = new WindowsMenuItemUIAccessor(){

        @Override
        public JMenuItem getMenuItem() {
            return WindowsMenuItemUI.this.menuItem;
        }

        @Override
        public TMSchema.State getState(JMenuItem jMenuItem) {
            return WindowsMenuItemUI.getState(this, jMenuItem);
        }

        @Override
        public TMSchema.Part getPart(JMenuItem jMenuItem) {
            return WindowsMenuItemUI.getPart(this, jMenuItem);
        }
    };

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsMenuItemUI();
    }

    @Override
    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            WindowsMenuItemUI.paintText(this.accessor, graphics, jMenuItem, rectangle, string);
            return;
        }
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color = graphics.getColor();
        if (buttonModel.isEnabled() && (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected())) {
            graphics.setColor(this.selectionForeground);
        }
        WindowsGraphicsUtils.paintText(graphics, jMenuItem, rectangle, string, 0);
        graphics.setColor(color);
    }

    @Override
    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            WindowsMenuItemUI.paintBackground(this.accessor, graphics, jMenuItem, color);
            return;
        }
        super.paintBackground(graphics, jMenuItem, color);
    }

    static void paintBackground(WindowsMenuItemUIAccessor windowsMenuItemUIAccessor, Graphics graphics, JMenuItem jMenuItem, Color color) {
        XPStyle xPStyle = XPStyle.getXP();
        assert (WindowsMenuItemUI.isVistaPainting(xPStyle));
        if (WindowsMenuItemUI.isVistaPainting(xPStyle)) {
            Color color2;
            int n = jMenuItem.getWidth();
            int n2 = jMenuItem.getHeight();
            if (jMenuItem.isOpaque()) {
                color2 = graphics.getColor();
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, n, n2);
                graphics.setColor(color2);
            }
            color2 = windowsMenuItemUIAccessor.getPart(jMenuItem);
            XPStyle.Skin skin = xPStyle.getSkin((Component)jMenuItem, (TMSchema.Part)color2);
            skin.paintSkin(graphics, 0, 0, n, n2, windowsMenuItemUIAccessor.getState(jMenuItem));
        }
    }

    static void paintText(WindowsMenuItemUIAccessor windowsMenuItemUIAccessor, Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        assert (WindowsMenuItemUI.isVistaPainting());
        if (WindowsMenuItemUI.isVistaPainting()) {
            TMSchema.State state = windowsMenuItemUIAccessor.getState(jMenuItem);
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics((JComponent)jMenuItem, graphics);
            int n = jMenuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                n = -1;
            }
            WindowsGraphicsUtils.paintXPText(jMenuItem, windowsMenuItemUIAccessor.getPart(jMenuItem), state, graphics, rectangle.x, rectangle.y + fontMetrics.getAscent(), string, n);
        }
    }

    static TMSchema.State getState(WindowsMenuItemUIAccessor windowsMenuItemUIAccessor, JMenuItem jMenuItem) {
        ButtonModel buttonModel = jMenuItem.getModel();
        TMSchema.State state = buttonModel.isArmed() ? (buttonModel.isEnabled() ? TMSchema.State.HOT : TMSchema.State.DISABLEDHOT) : (buttonModel.isEnabled() ? TMSchema.State.NORMAL : TMSchema.State.DISABLED);
        return state;
    }

    static TMSchema.Part getPart(WindowsMenuItemUIAccessor windowsMenuItemUIAccessor, JMenuItem jMenuItem) {
        return TMSchema.Part.MP_POPUPITEM;
    }

    static boolean isVistaPainting(XPStyle xPStyle) {
        return xPStyle != null && xPStyle.isSkinDefined(null, TMSchema.Part.MP_POPUPITEM);
    }

    static boolean isVistaPainting() {
        return WindowsMenuItemUI.isVistaPainting(XPStyle.getXP());
    }
}

