/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import sun.swing.SwingUtilities2;
import sun.swing.table.DefaultTableCellHeaderRenderer;

public class WindowsTableHeaderUI
extends BasicTableHeaderUI {
    private TableCellRenderer originalHeaderRenderer;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTableHeaderUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (XPStyle.getXP() != null) {
            this.originalHeaderRenderer = this.header.getDefaultRenderer();
            if (this.originalHeaderRenderer instanceof UIResource) {
                this.header.setDefaultRenderer(new XPDefaultRenderer());
            }
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        if (this.header.getDefaultRenderer() instanceof XPDefaultRenderer) {
            this.header.setDefaultRenderer(this.originalHeaderRenderer);
        }
        super.uninstallUI(jComponent);
    }

    @Override
    protected void rolloverColumnUpdated(int n, int n2) {
        if (XPStyle.getXP() != null) {
            this.header.repaint(this.header.getHeaderRect(n));
            this.header.repaint(this.header.getHeaderRect(n2));
        }
    }

    private static class IconBorder
    implements Border,
    UIResource {
        private final Icon icon;
        private final int top;
        private final int left;
        private final int bottom;
        private final int right;

        public IconBorder(Icon icon, int n, int n2, int n3, int n4) {
            this.icon = icon;
            this.top = n;
            this.left = n2;
            this.bottom = n3;
            this.right = n4;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(this.icon.getIconHeight() + this.top, this.left, this.bottom, this.right);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.icon.paintIcon(component, graphics, n + this.left + (n3 - this.left - this.right - this.icon.getIconWidth()) / 2, n2 + this.top);
        }
    }

    private class XPDefaultRenderer
    extends DefaultTableCellHeaderRenderer {
        XPStyle.Skin skin;
        boolean isSelected;
        boolean hasFocus;
        boolean hasRollover;
        int column;

        XPDefaultRenderer() {
            this.setHorizontalAlignment(10);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Icon icon;
            XPStyle xPStyle;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.isSelected = bl;
            this.hasFocus = bl2;
            this.column = n2;
            boolean bl3 = this.hasRollover = n2 == WindowsTableHeaderUI.this.getRolloverColumn();
            if (this.skin == null) {
                xPStyle = XPStyle.getXP();
                this.skin = xPStyle != null ? xPStyle.getSkin((Component)WindowsTableHeaderUI.this.header, TMSchema.Part.HP_HEADERITEM) : null;
            }
            xPStyle = this.skin != null ? this.skin.getContentMargin() : null;
            Border border = null;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (xPStyle != null) {
                n3 = xPStyle.top;
                n4 = xPStyle.left;
                n5 = xPStyle.bottom;
                n6 = xPStyle.right;
            }
            n4 += 5;
            n5 += 4;
            n6 += 5;
            if (WindowsLookAndFeel.isOnVista() && ((icon = this.getIcon()) instanceof UIResource || icon == null)) {
                ++n3;
                this.setIcon(null);
                icon = null;
                SortOrder sortOrder = XPDefaultRenderer.getColumnSortOrder(jTable, n2);
                if (sortOrder != null) {
                    switch (sortOrder) {
                        case ASCENDING: {
                            icon = UIManager.getIcon("Table.ascendingSortIcon");
                            break;
                        }
                        case DESCENDING: {
                            icon = UIManager.getIcon("Table.descendingSortIcon");
                        }
                    }
                }
                if (icon != null) {
                    n5 = icon.getIconHeight();
                    border = new IconBorder(icon, n3, n4, n5, n6);
                } else {
                    int n7;
                    icon = UIManager.getIcon("Table.ascendingSortIcon");
                    int n8 = n7 = icon != null ? icon.getIconHeight() : 0;
                    if (n7 != 0) {
                        n5 = n7;
                    }
                    border = new EmptyBorder(n7 + n3, n4, n5, n6);
                }
            } else {
                border = new EmptyBorder(n3 += 3, n4, n5, n6);
            }
            this.setBorder(border);
            return this;
        }

        @Override
        public void paint(Graphics graphics) {
            SortOrder sortOrder;
            Dimension dimension = this.getSize();
            TMSchema.State state = TMSchema.State.NORMAL;
            TableColumn tableColumn = WindowsTableHeaderUI.this.header.getDraggedColumn();
            if (tableColumn != null && this.column == SwingUtilities2.convertColumnIndexToView(WindowsTableHeaderUI.this.header.getColumnModel(), tableColumn.getModelIndex())) {
                state = TMSchema.State.PRESSED;
            } else if (this.isSelected || this.hasFocus || this.hasRollover) {
                state = TMSchema.State.HOT;
            }
            if (WindowsLookAndFeel.isOnVista() && (sortOrder = XPDefaultRenderer.getColumnSortOrder(WindowsTableHeaderUI.this.header.getTable(), this.column)) != null) {
                block0 : switch (sortOrder) {
                    case ASCENDING: 
                    case DESCENDING: {
                        switch (state) {
                            case NORMAL: {
                                state = TMSchema.State.SORTEDNORMAL;
                                break block0;
                            }
                            case PRESSED: {
                                state = TMSchema.State.SORTEDPRESSED;
                                break block0;
                            }
                            case HOT: {
                                state = TMSchema.State.SORTEDHOT;
                                break block0;
                            }
                        }
                    }
                }
            }
            this.skin.paintSkin(graphics, 0, 0, dimension.width - 1, dimension.height - 1, state);
            super.paint(graphics);
        }
    }
}

