/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpOidRecord;
import com.sun.jmx.snmp.SnmpOidTable;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import sun.misc.JavaAWTAccess;
import sun.misc.SharedSecrets;

public class SnmpOid
extends SnmpValue {
    protected long[] components = null;
    protected int componentCount = 0;
    static final String name = "Object Identifier";
    private static SnmpOidTable meta = null;
    static final long serialVersionUID = 8956237235607885096L;

    public SnmpOid() {
        this.components = new long[15];
        this.componentCount = 0;
    }

    public SnmpOid(long[] lArray) {
        this.components = (long[])lArray.clone();
        this.componentCount = this.components.length;
    }

    public SnmpOid(long l) {
        this.components = new long[1];
        this.components[0] = l;
        this.componentCount = this.components.length;
    }

    public SnmpOid(long l, long l2, long l3, long l4) {
        this.components = new long[4];
        this.components[0] = l;
        this.components[1] = l2;
        this.components[2] = l3;
        this.components[3] = l4;
        this.componentCount = this.components.length;
    }

    public SnmpOid(String string) throws IllegalArgumentException {
        String string2 = string;
        if (!string.startsWith(".")) {
            try {
                string2 = this.resolveVarName(string);
            }
            catch (SnmpStatusException snmpStatusException) {
                throw new IllegalArgumentException(snmpStatusException.getMessage());
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".", false);
        this.componentCount = stringTokenizer.countTokens();
        if (this.componentCount == 0) {
            this.components = new long[15];
        } else {
            this.components = new long[this.componentCount];
            try {
                for (int i = 0; i < this.componentCount; ++i) {
                    try {
                        this.components[i] = Long.parseLong(stringTokenizer.nextToken());
                        continue;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string);
            }
        }
    }

    public int getLength() {
        return this.componentCount;
    }

    public long[] longValue() {
        long[] lArray = new long[this.componentCount];
        System.arraycopy(this.components, 0, lArray, 0, this.componentCount);
        return lArray;
    }

    public final long[] longValue(boolean bl) {
        if (bl) {
            return this.longValue();
        }
        if (this.componentCount == this.components.length) {
            return this.components;
        }
        this.components = this.longValue();
        this.componentCount = this.components.length;
        return this.components;
    }

    public final long getOidArc(int n) throws SnmpStatusException {
        try {
            return this.components[n];
        }
        catch (Exception exception) {
            throw new SnmpStatusException(6);
        }
    }

    public Long toLong() {
        if (this.componentCount != 1) {
            throw new IllegalArgumentException();
        }
        return new Long(this.components[0]);
    }

    public Integer toInteger() {
        if (this.componentCount != 1 || this.components[0] > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return new Integer((int)this.components[0]);
    }

    public String toString() {
        String string = "";
        if (this.componentCount >= 1) {
            for (int i = 0; i < this.componentCount - 1; ++i) {
                string = string + this.components[i] + ".";
            }
            string = string + this.components[this.componentCount - 1];
        }
        return string;
    }

    public Boolean toBoolean() {
        if (this.componentCount != 1 && this.components[0] != 1L && this.components[0] != 2L) {
            throw new IllegalArgumentException();
        }
        return this.components[0] == 1L;
    }

    public Byte[] toByte() {
        Byte[] byteArray = new Byte[this.componentCount];
        for (int i = 0; i < this.componentCount; ++i) {
            if (this.components[0] > 255L) {
                throw new IllegalArgumentException();
            }
            byteArray[i] = new Byte((byte)this.components[i]);
        }
        return byteArray;
    }

    @Override
    public SnmpOid toOid() {
        long[] lArray = new long[this.componentCount];
        for (int i = 0; i < this.componentCount; ++i) {
            lArray[i] = this.components[i];
        }
        return new SnmpOid(lArray);
    }

    public static SnmpOid toOid(long[] lArray, int n) throws SnmpStatusException {
        try {
            if (lArray[n] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            int n2 = (int)lArray[n++];
            long[] lArray2 = new long[n2];
            for (int i = 0; i < n2; ++i) {
                lArray2[i] = lArray[n + i];
            }
            return new SnmpOid(lArray2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public static int nextOid(long[] lArray, int n) throws SnmpStatusException {
        try {
            int n2;
            if (lArray[n] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            if ((n += (n2 = (int)lArray[n++])) <= lArray.length) {
                return n;
            }
            throw new SnmpStatusException(2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public static void appendToOid(SnmpOid snmpOid, SnmpOid snmpOid2) {
        snmpOid2.append(snmpOid.getLength());
        snmpOid2.append(snmpOid);
    }

    @Override
    public final synchronized SnmpValue duplicate() {
        return (SnmpValue)this.clone();
    }

    public Object clone() {
        try {
            SnmpOid snmpOid = (SnmpOid)super.clone();
            snmpOid.components = new long[this.componentCount];
            System.arraycopy(this.components, 0, snmpOid.components, 0, this.componentCount);
            return snmpOid;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void insert(long l) {
        this.enlargeIfNeeded(1);
        for (int i = this.componentCount - 1; i >= 0; --i) {
            this.components[i + 1] = this.components[i];
        }
        this.components[0] = l;
        ++this.componentCount;
    }

    public void insert(int n) {
        this.insert((long)n);
    }

    public void append(SnmpOid snmpOid) {
        this.enlargeIfNeeded(snmpOid.componentCount);
        for (int i = 0; i < snmpOid.componentCount; ++i) {
            this.components[this.componentCount + i] = snmpOid.components[i];
        }
        this.componentCount += snmpOid.componentCount;
    }

    public void append(long l) {
        this.enlargeIfNeeded(1);
        this.components[this.componentCount] = l;
        ++this.componentCount;
    }

    public void addToOid(String string) throws SnmpStatusException {
        SnmpOid snmpOid = new SnmpOid(string);
        this.append(snmpOid);
    }

    public void addToOid(long[] lArray) throws SnmpStatusException {
        SnmpOid snmpOid = new SnmpOid(lArray);
        this.append(snmpOid);
    }

    public boolean isValid() {
        return this.componentCount >= 2 && 0L <= this.components[0] && this.components[0] < 3L && 0L <= this.components[1] && this.components[1] < 40L;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SnmpOid) {
            SnmpOid snmpOid = (SnmpOid)object;
            if (snmpOid.componentCount == this.componentCount) {
                int n;
                long[] lArray = snmpOid.components;
                for (n = 0; n < this.componentCount && this.components[n] == lArray[n]; ++n) {
                }
                bl = n == this.componentCount;
            }
        }
        return bl;
    }

    public int hashCode() {
        long l = 0L;
        for (int i = 0; i < this.componentCount; ++i) {
            l = l * 31L + this.components[i];
        }
        return (int)l;
    }

    public int compareTo(SnmpOid snmpOid) {
        int n = 0;
        int n2 = 0;
        int n3 = Math.min(this.componentCount, snmpOid.componentCount);
        long[] lArray = snmpOid.components;
        for (n2 = 0; n2 < n3 && this.components[n2] == lArray[n2]; ++n2) {
        }
        n = n2 == this.componentCount && n2 == snmpOid.componentCount ? 0 : (n2 == this.componentCount ? -1 : (n2 == snmpOid.componentCount ? 1 : (this.components[n2] < lArray[n2] ? -1 : 1)));
        return n;
    }

    public String resolveVarName(String string) throws SnmpStatusException {
        int n = string.indexOf(46);
        try {
            return this.handleLong(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            SnmpOidTable snmpOidTable = SnmpOid.getSnmpOidTable();
            if (snmpOidTable == null) {
                throw new SnmpStatusException(2);
            }
            if (n <= 0) {
                SnmpOidRecord snmpOidRecord = snmpOidTable.resolveVarName(string);
                return snmpOidRecord.getOid();
            }
            SnmpOidRecord snmpOidRecord = snmpOidTable.resolveVarName(string.substring(0, n));
            return snmpOidRecord.getOid() + string.substring(n);
        }
    }

    @Override
    public String getTypeName() {
        return name;
    }

    public static SnmpOidTable getSnmpOidTable() {
        JavaAWTAccess javaAWTAccess = SharedSecrets.getJavaAWTAccess();
        if (javaAWTAccess == null) {
            return meta;
        }
        return (SnmpOidTable)javaAWTAccess.get(SnmpOidTable.class);
    }

    public static void setSnmpOidTable(SnmpOidTable snmpOidTable) {
        JavaAWTAccess javaAWTAccess = SharedSecrets.getJavaAWTAccess();
        if (javaAWTAccess == null) {
            meta = snmpOidTable;
        } else if (snmpOidTable == null) {
            javaAWTAccess.remove(SnmpOidTable.class);
        } else {
            javaAWTAccess.put(SnmpOidTable.class, (Object)snmpOidTable);
        }
    }

    public String toOctetString() {
        return new String(this.tobyte());
    }

    private byte[] tobyte() {
        byte[] byArray = new byte[this.componentCount];
        for (int i = 0; i < this.componentCount; ++i) {
            if (this.components[0] > 255L) {
                throw new IllegalArgumentException();
            }
            byArray[i] = (byte)this.components[i];
        }
        return byArray;
    }

    private void enlargeIfNeeded(int n) {
        int n2;
        for (n2 = this.components.length; this.componentCount + n > n2; n2 *= 2) {
        }
        if (n2 > this.components.length) {
            long[] lArray = new long[n2];
            for (int i = 0; i < this.components.length; ++i) {
                lArray[i] = this.components[i];
            }
            this.components = lArray;
        }
    }

    private String handleLong(String string, int n) throws NumberFormatException, SnmpStatusException {
        String string2 = n > 0 ? string.substring(0, n) : string;
        Long.parseLong(string2);
        return string;
    }
}

