/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.ext;

import com.sun.jndi.ldap.Connection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import sun.security.util.HostnameChecker;

public final class StartTlsResponseImpl
extends StartTlsResponse {
    private static final boolean debug = false;
    private static final int DNSNAME_TYPE = 2;
    private transient String hostname = null;
    private transient Connection ldapConnection = null;
    private transient InputStream originalInputStream = null;
    private transient OutputStream originalOutputStream = null;
    private transient SSLSocket sslSocket = null;
    private transient SSLSocketFactory defaultFactory = null;
    private transient SSLSocketFactory currentFactory = null;
    private transient String[] suites = null;
    private transient HostnameVerifier verifier = null;
    private transient boolean isClosed = true;
    private static final long serialVersionUID = -1126624615143411328L;

    @Override
    public void setEnabledCipherSuites(String[] stringArray) {
        this.suites = stringArray;
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.verifier = hostnameVerifier;
    }

    @Override
    public SSLSession negotiate() throws IOException {
        return this.negotiate(null);
    }

    @Override
    public SSLSession negotiate(SSLSocketFactory sSLSocketFactory) throws IOException {
        if (this.isClosed && this.sslSocket != null) {
            throw new IOException("TLS connection is closed.");
        }
        if (sSLSocketFactory == null) {
            sSLSocketFactory = this.getDefaultFactory();
        }
        SSLSession sSLSession = this.startHandshake(sSLSocketFactory).getSession();
        SSLPeerUnverifiedException sSLPeerUnverifiedException = null;
        try {
            if (this.verify(this.hostname, sSLSession)) {
                this.isClosed = false;
                return sSLSession;
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException2) {
            sSLPeerUnverifiedException = sSLPeerUnverifiedException2;
        }
        if (this.verifier != null && this.verifier.verify(this.hostname, sSLSession)) {
            this.isClosed = false;
            return sSLSession;
        }
        this.close();
        sSLSession.invalidate();
        if (sSLPeerUnverifiedException == null) {
            sSLPeerUnverifiedException = new SSLPeerUnverifiedException("hostname of the server '" + this.hostname + "' does not match the hostname in the " + "server's certificate.");
        }
        throw sSLPeerUnverifiedException;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.ldapConnection.replaceStreams(this.originalInputStream, this.originalOutputStream);
        this.sslSocket.close();
        this.isClosed = true;
    }

    public void setConnection(Connection connection, String string) {
        this.ldapConnection = connection;
        this.hostname = string != null ? string : connection.host;
        this.originalInputStream = connection.inStream;
        this.originalOutputStream = connection.outStream;
    }

    private SSLSocketFactory getDefaultFactory() throws IOException {
        if (this.defaultFactory != null) {
            return this.defaultFactory;
        }
        this.defaultFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        return this.defaultFactory;
    }

    private SSLSocket startHandshake(SSLSocketFactory sSLSocketFactory) throws IOException {
        if (this.ldapConnection == null) {
            throw new IllegalStateException("LDAP connection has not been set. TLS requires an existing LDAP connection.");
        }
        if (sSLSocketFactory != this.currentFactory) {
            this.sslSocket = (SSLSocket)sSLSocketFactory.createSocket(this.ldapConnection.sock, this.ldapConnection.host, this.ldapConnection.port, false);
            this.currentFactory = sSLSocketFactory;
        }
        if (this.suites != null) {
            this.sslSocket.setEnabledCipherSuites(this.suites);
        }
        try {
            this.sslSocket.startHandshake();
            this.ldapConnection.replaceStreams(this.sslSocket.getInputStream(), this.sslSocket.getOutputStream());
        }
        catch (IOException iOException) {
            this.sslSocket.close();
            this.isClosed = true;
            throw iOException;
        }
        return this.sslSocket;
    }

    private boolean verify(String string, SSLSession sSLSession) throws SSLPeerUnverifiedException {
        Certificate[] certificateArray = null;
        if (string != null && string.startsWith("[") && string.endsWith("]")) {
            string = string.substring(1, string.length() - 1);
        }
        try {
            HostnameChecker hostnameChecker = HostnameChecker.getInstance((byte)2);
            if (sSLSession.getCipherSuite().startsWith("TLS_KRB5")) {
                Principal principal = StartTlsResponseImpl.getPeerPrincipal(sSLSession);
                if (!HostnameChecker.match((String)string, (Principal)principal)) {
                    throw new SSLPeerUnverifiedException("hostname of the kerberos principal:" + principal + " does not match the hostname:" + string);
                }
            } else {
                certificateArray = sSLSession.getPeerCertificates();
                if (!(certificateArray[0] instanceof X509Certificate)) {
                    throw new SSLPeerUnverifiedException("Received a non X509Certificate from the server");
                }
                X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                hostnameChecker.match(string, x509Certificate);
            }
            return true;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            String string2 = sSLSession.getCipherSuite();
            if (string2 != null && string2.indexOf("_anon_") != -1) {
                return true;
            }
            throw sSLPeerUnverifiedException;
        }
        catch (CertificateException certificateException) {
            throw (SSLPeerUnverifiedException)new SSLPeerUnverifiedException("hostname of the server '" + string + "' does not match the hostname in the " + "server's certificate.").initCause(certificateException);
        }
    }

    private static Principal getPeerPrincipal(SSLSession sSLSession) throws SSLPeerUnverifiedException {
        Principal principal;
        try {
            principal = sSLSession.getPeerPrincipal();
        }
        catch (AbstractMethodError abstractMethodError) {
            principal = null;
        }
        return principal;
    }
}

