/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.dtm;

import com.sun.org.apache.xml.internal.res.XMLMessages;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.transform.SourceLocator;

public class DTMException
extends RuntimeException {
    static final long serialVersionUID = -775576419181334734L;
    SourceLocator locator;
    Throwable containedException;

    public SourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(SourceLocator sourceLocator) {
        this.locator = sourceLocator;
    }

    public Throwable getException() {
        return this.containedException;
    }

    @Override
    public Throwable getCause() {
        return this.containedException == this ? null : this.containedException;
    }

    @Override
    public synchronized Throwable initCause(Throwable throwable) {
        if (this.containedException == null && throwable != null) {
            throw new IllegalStateException(XMLMessages.createXMLMessage("ER_CANNOT_OVERWRITE_CAUSE", null));
        }
        if (throwable == this) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_SELF_CAUSATION_NOT_PERMITTED", null));
        }
        this.containedException = throwable;
        return this;
    }

    public DTMException(String string) {
        super(string);
        this.containedException = null;
        this.locator = null;
    }

    public DTMException(Throwable throwable) {
        super(throwable.getMessage());
        this.containedException = throwable;
        this.locator = null;
    }

    public DTMException(String string, Throwable throwable) {
        super(string == null || string.length() == 0 ? throwable.getMessage() : string);
        this.containedException = throwable;
        this.locator = null;
    }

    public DTMException(String string, SourceLocator sourceLocator) {
        super(string);
        this.containedException = null;
        this.locator = sourceLocator;
    }

    public DTMException(String string, SourceLocator sourceLocator, Throwable throwable) {
        super(string);
        this.containedException = throwable;
        this.locator = sourceLocator;
    }

    public String getMessageAndLocation() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = super.getMessage();
        if (null != string) {
            stringBuffer.append(string);
        }
        if (null != this.locator) {
            String string2 = this.locator.getSystemId();
            int n = this.locator.getLineNumber();
            int n2 = this.locator.getColumnNumber();
            if (null != string2) {
                stringBuffer.append("; SystemID: ");
                stringBuffer.append(string2);
            }
            if (0 != n) {
                stringBuffer.append("; Line#: ");
                stringBuffer.append(n);
            }
            if (0 != n2) {
                stringBuffer.append("; Column#: ");
                stringBuffer.append(n2);
            }
        }
        return stringBuffer.toString();
    }

    public String getLocationAsString() {
        if (null != this.locator) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.locator.getSystemId();
            int n = this.locator.getLineNumber();
            int n2 = this.locator.getColumnNumber();
            if (null != string) {
                stringBuffer.append("; SystemID: ");
                stringBuffer.append(string);
            }
            if (0 != n) {
                stringBuffer.append("; Line#: ");
                stringBuffer.append(n);
            }
            if (0 != n2) {
                stringBuffer.append("; Column#: ");
                stringBuffer.append(n2);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(new PrintWriter(System.err, true));
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream));
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (printWriter == null) {
            printWriter = new PrintWriter(System.err, true);
        }
        try {
            String string = this.getLocationAsString();
            if (null != string) {
                printWriter.println(string);
            }
            super.printStackTrace(printWriter);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl = false;
        try {
            Throwable.class.getMethod("getCause", null);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (!bl) {
            Throwable throwable = this.getException();
            for (int i = 0; i < 10 && null != throwable; ++i) {
                Object object;
                printWriter.println("---------");
                try {
                    if (throwable instanceof DTMException && null != (object = ((DTMException)throwable).getLocationAsString())) {
                        printWriter.println((String)object);
                    }
                    throwable.printStackTrace(printWriter);
                }
                catch (Throwable throwable2) {
                    printWriter.println("Could not print stack trace...");
                }
                try {
                    object = throwable.getClass().getMethod("getException", null);
                    if (null != object) {
                        Throwable throwable3 = throwable;
                        if (throwable3 != (throwable = (Throwable)((Method)object).invoke((Object)throwable, (Object[])null))) continue;
                        break;
                    }
                    throwable = null;
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throwable = null;
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throwable = null;
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throwable = null;
                }
            }
        }
    }
}

