/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.jaxp;

import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xalan.internal.utils.FactoryImpl;
import com.sun.org.apache.xalan.internal.utils.FeatureManager;
import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xpath.internal.XPath;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.jaxp.JAXPExtensionsProvider;
import com.sun.org.apache.xpath.internal.jaxp.JAXPPrefixResolver;
import com.sun.org.apache.xpath.internal.jaxp.JAXPVariableStack;
import com.sun.org.apache.xpath.internal.objects.XObject;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

public class XPathExpressionImpl
implements XPathExpression {
    private XPathFunctionResolver functionResolver;
    private XPathVariableResolver variableResolver;
    private JAXPPrefixResolver prefixResolver;
    private XPath xpath;
    private boolean featureSecureProcessing = false;
    private boolean useServicesMechanism = true;
    private final FeatureManager featureManager;
    static DocumentBuilderFactory dbf = null;
    static DocumentBuilder db = null;
    static Document d = null;

    protected XPathExpressionImpl() {
        this(null, null, null, null, false, true, new FeatureManager());
    }

    protected XPathExpressionImpl(XPath xPath, JAXPPrefixResolver jAXPPrefixResolver, XPathFunctionResolver xPathFunctionResolver, XPathVariableResolver xPathVariableResolver) {
        this(xPath, jAXPPrefixResolver, xPathFunctionResolver, xPathVariableResolver, false, true, new FeatureManager());
    }

    protected XPathExpressionImpl(XPath xPath, JAXPPrefixResolver jAXPPrefixResolver, XPathFunctionResolver xPathFunctionResolver, XPathVariableResolver xPathVariableResolver, boolean bl, boolean bl2, FeatureManager featureManager) {
        this.xpath = xPath;
        this.prefixResolver = jAXPPrefixResolver;
        this.functionResolver = xPathFunctionResolver;
        this.variableResolver = xPathVariableResolver;
        this.featureSecureProcessing = bl;
        this.useServicesMechanism = bl2;
        this.featureManager = featureManager;
    }

    public void setXPath(XPath xPath) {
        this.xpath = xPath;
    }

    public Object eval(Object object, QName qName) throws TransformerException {
        XObject xObject = this.eval(object);
        return this.getResultAsType(xObject, qName);
    }

    private XObject eval(Object object) throws TransformerException {
        Object object2;
        XPathContext xPathContext = null;
        if (this.functionResolver != null) {
            object2 = new JAXPExtensionsProvider(this.functionResolver, this.featureSecureProcessing, this.featureManager);
            xPathContext = new XPathContext(object2);
        } else {
            xPathContext = new XPathContext();
        }
        xPathContext.setVarStack(new JAXPVariableStack(this.variableResolver));
        object2 = null;
        Node node = (Node)object;
        object2 = node == null ? this.xpath.execute(xPathContext, -1, (PrefixResolver)this.prefixResolver) : this.xpath.execute(xPathContext, node, (PrefixResolver)this.prefixResolver);
        return object2;
    }

    @Override
    public Object evaluate(Object object, QName qName) throws XPathExpressionException {
        if (qName == null) {
            String string = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"returnType"});
            throw new NullPointerException(string);
        }
        if (!this.isSupported(qName)) {
            String string = XSLMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{qName.toString()});
            throw new IllegalArgumentException(string);
        }
        try {
            return this.eval(object, qName);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPathExpressionException(nullPointerException);
        }
        catch (TransformerException transformerException) {
            Throwable throwable = transformerException.getException();
            if (throwable instanceof XPathFunctionException) {
                throw (XPathFunctionException)throwable;
            }
            throw new XPathExpressionException(transformerException);
        }
    }

    @Override
    public String evaluate(Object object) throws XPathExpressionException {
        return (String)this.evaluate(object, XPathConstants.STRING);
    }

    @Override
    public Object evaluate(InputSource inputSource, QName qName) throws XPathExpressionException {
        if (inputSource == null || qName == null) {
            String string = XSLMessages.createXPATHMessage("ER_SOURCE_RETURN_TYPE_CANNOT_BE_NULL", null);
            throw new NullPointerException(string);
        }
        if (!this.isSupported(qName)) {
            String string = XSLMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{qName.toString()});
            throw new IllegalArgumentException(string);
        }
        try {
            if (dbf == null) {
                dbf = FactoryImpl.getDOMFactory((boolean)this.useServicesMechanism);
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
            }
            db = dbf.newDocumentBuilder();
            Document document = db.parse(inputSource);
            return this.eval(document, qName);
        }
        catch (Exception exception) {
            throw new XPathExpressionException(exception);
        }
    }

    @Override
    public String evaluate(InputSource inputSource) throws XPathExpressionException {
        return (String)this.evaluate(inputSource, XPathConstants.STRING);
    }

    private boolean isSupported(QName qName) {
        return qName.equals(XPathConstants.STRING) || qName.equals(XPathConstants.NUMBER) || qName.equals(XPathConstants.BOOLEAN) || qName.equals(XPathConstants.NODE) || qName.equals(XPathConstants.NODESET);
    }

    private Object getResultAsType(XObject xObject, QName qName) throws TransformerException {
        if (qName.equals(XPathConstants.STRING)) {
            return xObject.str();
        }
        if (qName.equals(XPathConstants.NUMBER)) {
            return new Double(xObject.num());
        }
        if (qName.equals(XPathConstants.BOOLEAN)) {
            return new Boolean(xObject.bool());
        }
        if (qName.equals(XPathConstants.NODESET)) {
            return xObject.nodelist();
        }
        if (qName.equals(XPathConstants.NODE)) {
            NodeIterator nodeIterator = xObject.nodeset();
            return nodeIterator.nextNode();
        }
        String string = XSLMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{qName.toString()});
        throw new IllegalArgumentException(string);
    }
}

