/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.glassfish.external.statistics.impl;

import com.sun.org.glassfish.external.statistics.RangeStatistic;
import com.sun.org.glassfish.external.statistics.impl.StatisticImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

public final class RangeStatisticImpl
extends StatisticImpl
implements RangeStatistic,
InvocationHandler {
    private long currentVal = 0L;
    private long highWaterMark = Long.MIN_VALUE;
    private long lowWaterMark = Long.MAX_VALUE;
    private final long initCurrentVal;
    private final long initHighWaterMark;
    private final long initLowWaterMark;
    private final RangeStatistic rs = (RangeStatistic)Proxy.newProxyInstance(RangeStatistic.class.getClassLoader(), new Class[]{RangeStatistic.class}, (InvocationHandler)this);

    public RangeStatisticImpl(long l, long l2, long l3, String string, String string2, String string3, long l4, long l5) {
        super(string, string2, string3, l4, l5);
        this.currentVal = l;
        this.initCurrentVal = l;
        this.highWaterMark = l2;
        this.initHighWaterMark = l2;
        this.lowWaterMark = l3;
        this.initLowWaterMark = l3;
    }

    public synchronized RangeStatistic getStatistic() {
        return this.rs;
    }

    @Override
    public synchronized Map getStaticAsMap() {
        Map map = super.getStaticAsMap();
        map.put("current", this.getCurrent());
        map.put("lowwatermark", this.getLowWaterMark());
        map.put("highwatermark", this.getHighWaterMark());
        return map;
    }

    @Override
    public synchronized long getCurrent() {
        return this.currentVal;
    }

    public synchronized void setCurrent(long l) {
        this.currentVal = l;
        this.lowWaterMark = l >= this.lowWaterMark ? this.lowWaterMark : l;
        this.highWaterMark = l >= this.highWaterMark ? l : this.highWaterMark;
        this.sampleTime = System.currentTimeMillis();
    }

    @Override
    public synchronized long getHighWaterMark() {
        return this.highWaterMark;
    }

    public synchronized void setHighWaterMark(long l) {
        this.highWaterMark = l;
    }

    @Override
    public synchronized long getLowWaterMark() {
        return this.lowWaterMark;
    }

    public synchronized void setLowWaterMark(long l) {
        this.lowWaterMark = l;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.currentVal = this.initCurrentVal;
        this.highWaterMark = this.initHighWaterMark;
        this.lowWaterMark = this.initLowWaterMark;
        this.sampleTime = -1L;
    }

    @Override
    public synchronized String toString() {
        return super.toString() + NEWLINE + "Current: " + this.getCurrent() + NEWLINE + "LowWaterMark: " + this.getLowWaterMark() + NEWLINE + "HighWaterMark: " + this.getHighWaterMark();
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        this.checkMethod(method);
        try {
            object2 = method.invoke((Object)this, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (Exception exception) {
            throw new RuntimeException("unexpected invocation exception: " + exception.getMessage());
        }
        return object2;
    }
}

