/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.glassfish.external.statistics.impl;

import com.sun.org.glassfish.external.statistics.TimeStatistic;
import com.sun.org.glassfish.external.statistics.impl.StatisticImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

public final class TimeStatisticImpl
extends StatisticImpl
implements TimeStatistic,
InvocationHandler {
    private long count = 0L;
    private long maxTime = 0L;
    private long minTime = 0L;
    private long totTime = 0L;
    private final long initCount;
    private final long initMaxTime;
    private final long initMinTime;
    private final long initTotTime;
    private final TimeStatistic ts = (TimeStatistic)Proxy.newProxyInstance(TimeStatistic.class.getClassLoader(), new Class[]{TimeStatistic.class}, (InvocationHandler)this);

    @Override
    public final synchronized String toString() {
        return super.toString() + NEWLINE + "Count: " + this.getCount() + NEWLINE + "MinTime: " + this.getMinTime() + NEWLINE + "MaxTime: " + this.getMaxTime() + NEWLINE + "TotalTime: " + this.getTotalTime();
    }

    public TimeStatisticImpl(long l, long l2, long l3, long l4, String string, String string2, String string3, long l5, long l6) {
        super(string, string2, string3, l5, l6);
        this.count = l;
        this.initCount = l;
        this.maxTime = l2;
        this.initMaxTime = l2;
        this.minTime = l3;
        this.initMinTime = l3;
        this.totTime = l4;
        this.initTotTime = l4;
    }

    public synchronized TimeStatistic getStatistic() {
        return this.ts;
    }

    @Override
    public synchronized Map getStaticAsMap() {
        Map map = super.getStaticAsMap();
        map.put("count", this.getCount());
        map.put("maxtime", this.getMaxTime());
        map.put("mintime", this.getMinTime());
        map.put("totaltime", this.getTotalTime());
        return map;
    }

    public synchronized void incrementCount(long l) {
        if (this.count == 0L) {
            this.totTime = l;
            this.maxTime = l;
            this.minTime = l;
        } else {
            this.totTime += l;
            this.maxTime = l >= this.maxTime ? l : this.maxTime;
            this.minTime = l >= this.minTime ? this.minTime : l;
        }
        ++this.count;
        this.sampleTime = System.currentTimeMillis();
    }

    @Override
    public synchronized long getCount() {
        return this.count;
    }

    @Override
    public synchronized long getMaxTime() {
        return this.maxTime;
    }

    @Override
    public synchronized long getMinTime() {
        return this.minTime;
    }

    @Override
    public synchronized long getTotalTime() {
        return this.totTime;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.count = this.initCount;
        this.maxTime = this.initMaxTime;
        this.minTime = this.initMinTime;
        this.totTime = this.initTotTime;
        this.sampleTime = -1L;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        this.checkMethod(method);
        try {
            object2 = method.invoke((Object)this, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (Exception exception) {
            throw new RuntimeException("unexpected invocation exception: " + exception.getMessage());
        }
        return object2;
    }
}

