/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.unmarshaller;

import com.sun.xml.internal.bind.WhiteSpaceProcessor;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.LocatorEx;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.LocatorExWrapper;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.TagName;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.XmlVisitor;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshallerHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class SAXConnector
implements UnmarshallerHandler {
    private LocatorEx loc;
    private final StringBuilder buffer = new StringBuilder();
    private final XmlVisitor next;
    private final UnmarshallingContext context;
    private final XmlVisitor.TextPredictor predictor;
    private final TagNameImpl tagName = new TagNameImpl();

    public SAXConnector(XmlVisitor xmlVisitor, LocatorEx locatorEx) {
        this.next = xmlVisitor;
        this.context = xmlVisitor.getContext();
        this.predictor = xmlVisitor.getPredictor();
        this.loc = locatorEx;
    }

    @Override
    public Object getResult() throws JAXBException, IllegalStateException {
        return this.context.getResult();
    }

    public UnmarshallingContext getContext() {
        return this.context;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.loc != null) {
            return;
        }
        this.loc = new LocatorExWrapper(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.next.startDocument(this.loc, null);
    }

    @Override
    public void endDocument() throws SAXException {
        this.next.endDocument();
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.next.startPrefixMapping(string, string2);
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        this.next.endPrefixMapping(string);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string == null || string.length() == 0) {
            string = "";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = string3;
        }
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        this.processText(!this.context.getCurrentState().isMixed());
        this.tagName.uri = string;
        this.tagName.local = string2;
        this.tagName.qname = string3;
        this.tagName.atts = attributes;
        this.next.startElement(this.tagName);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.processText(false);
        this.tagName.uri = string;
        this.tagName.local = string2;
        this.tagName.qname = string3;
        this.next.endElement(this.tagName);
    }

    @Override
    public final void characters(char[] cArray, int n, int n2) {
        if (this.predictor.expectText()) {
            this.buffer.append(cArray, n, n2);
        }
    }

    @Override
    public final void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.characters(cArray, n, n2);
    }

    @Override
    public void processingInstruction(String string, String string2) {
    }

    @Override
    public void skippedEntity(String string) {
    }

    private void processText(boolean bl) throws SAXException {
        if (!(!this.predictor.expectText() || bl && WhiteSpaceProcessor.isWhiteSpace(this.buffer))) {
            this.next.text(this.buffer);
        }
        this.buffer.setLength(0);
    }

    private static final class TagNameImpl
    extends TagName {
        String qname;

        private TagNameImpl() {
        }

        @Override
        public String getQname() {
            return this.qname;
        }
    }
}

