/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.unmarshaller;

import com.sun.xml.internal.bind.v2.runtime.unmarshaller.StAXConnector;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.XmlVisitor;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class StAXEventConnector
extends StAXConnector {
    private final XMLEventReader staxEventReader;
    private XMLEvent event;
    private final AttributesImpl attrs = new AttributesImpl();
    private final StringBuilder buffer = new StringBuilder();
    private boolean seenText;

    public StAXEventConnector(XMLEventReader xMLEventReader, XmlVisitor xmlVisitor) {
        super(xmlVisitor);
        this.staxEventReader = xMLEventReader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void bridge() throws XMLStreamException {
        try {
            int n = 0;
            this.event = this.staxEventReader.peek();
            if (!this.event.isStartDocument() && !this.event.isStartElement()) {
                throw new IllegalStateException();
            }
            do {
                this.event = this.staxEventReader.nextEvent();
            } while (!this.event.isStartElement());
            this.handleStartDocument(this.event.asStartElement().getNamespaceContext());
            block8: while (true) {
                switch (this.event.getEventType()) {
                    case 1: {
                        this.handleStartElement(this.event.asStartElement());
                        ++n;
                        break;
                    }
                    case 2: {
                        this.handleEndElement(this.event.asEndElement());
                        if (--n != 0) break;
                        break block8;
                    }
                    case 4: 
                    case 6: 
                    case 12: {
                        this.handleCharacters(this.event.asCharacters());
                    }
                }
                this.event = this.staxEventReader.nextEvent();
            }
            this.handleEndDocument();
            this.event = null;
            return;
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException(sAXException);
        }
    }

    @Override
    protected Location getCurrentLocation() {
        return this.event.getLocation();
    }

    @Override
    protected String getCurrentQName() {
        QName qName = this.event.isEndElement() ? this.event.asEndElement().getName() : this.event.asStartElement().getName();
        return this.getQName(qName.getPrefix(), qName.getLocalPart());
    }

    private void handleCharacters(Characters characters) throws SAXException, XMLStreamException {
        XMLEvent xMLEvent;
        if (!this.predictor.expectText()) {
            return;
        }
        this.seenText = true;
        while (this.isIgnorable(xMLEvent = this.staxEventReader.peek())) {
            this.staxEventReader.nextEvent();
        }
        if (this.isTag(xMLEvent)) {
            this.visitor.text(characters.getData());
            return;
        }
        this.buffer.append(characters.getData());
        while (true) {
            if (this.isIgnorable(xMLEvent = this.staxEventReader.peek())) {
                this.staxEventReader.nextEvent();
                continue;
            }
            if (this.isTag(xMLEvent)) {
                this.visitor.text(this.buffer);
                this.buffer.setLength(0);
                return;
            }
            this.buffer.append(xMLEvent.asCharacters().getData());
            this.staxEventReader.nextEvent();
        }
    }

    private boolean isTag(XMLEvent xMLEvent) {
        int n = xMLEvent.getEventType();
        return n == 1 || n == 2;
    }

    private boolean isIgnorable(XMLEvent xMLEvent) {
        int n = xMLEvent.getEventType();
        return n == 5 || n == 3;
    }

    private void handleEndElement(EndElement endElement) throws SAXException {
        if (!this.seenText && this.predictor.expectText()) {
            this.visitor.text("");
        }
        QName qName = endElement.getName();
        this.tagName.uri = StAXEventConnector.fixNull(qName.getNamespaceURI());
        this.tagName.local = qName.getLocalPart();
        this.visitor.endElement(this.tagName);
        Iterator<Namespace> iterator = endElement.getNamespaces();
        while (iterator.hasNext()) {
            String string = StAXEventConnector.fixNull(iterator.next().getPrefix());
            this.visitor.endPrefixMapping(string);
        }
        this.seenText = false;
    }

    private void handleStartElement(StartElement startElement) throws SAXException {
        Object object;
        Object object2 = startElement.getNamespaces();
        while (object2.hasNext()) {
            object = object2.next();
            this.visitor.startPrefixMapping(StAXEventConnector.fixNull(object.getPrefix()), StAXEventConnector.fixNull(object.getNamespaceURI()));
        }
        object2 = startElement.getName();
        this.tagName.uri = StAXEventConnector.fixNull(((QName)object2).getNamespaceURI());
        object = ((QName)object2).getLocalPart();
        this.tagName.uri = StAXEventConnector.fixNull(((QName)object2).getNamespaceURI());
        this.tagName.local = object;
        this.tagName.atts = this.getAttributes(startElement);
        this.visitor.startElement(this.tagName);
        this.seenText = false;
    }

    private Attributes getAttributes(StartElement startElement) {
        this.attrs.clear();
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            QName qName = attribute.getName();
            String string = StAXEventConnector.fixNull(qName.getNamespaceURI());
            String string2 = qName.getLocalPart();
            String string3 = qName.getPrefix();
            String string4 = string3 == null || string3.length() == 0 ? string2 : string3 + ':' + string2;
            String string5 = attribute.getDTDType();
            String string6 = attribute.getValue();
            this.attrs.addAttribute(string, string2, string4, string5, string6);
        }
        return this.attrs;
    }
}

