/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.stax;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.Decoder;
import com.sun.xml.internal.fastinfoset.DecoderStateTables;
import com.sun.xml.internal.fastinfoset.OctetBufferListener;
import com.sun.xml.internal.fastinfoset.QualifiedName;
import com.sun.xml.internal.fastinfoset.algorithm.BuiltInEncodingAlgorithmFactory;
import com.sun.xml.internal.fastinfoset.org.apache.xerces.util.XMLChar;
import com.sun.xml.internal.fastinfoset.sax.AttributesHolder;
import com.sun.xml.internal.fastinfoset.stax.EventLocation;
import com.sun.xml.internal.fastinfoset.stax.StAXManager;
import com.sun.xml.internal.fastinfoset.util.CharArray;
import com.sun.xml.internal.fastinfoset.util.CharArrayString;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithm;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithmException;
import com.sun.xml.internal.org.jvnet.fastinfoset.FastInfosetException;
import com.sun.xml.internal.org.jvnet.fastinfoset.stax.FastInfosetStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StAXDocumentParser
extends Decoder
implements XMLStreamReader,
FastInfosetStreamReader,
OctetBufferListener {
    private static final Logger logger = Logger.getLogger(StAXDocumentParser.class.getName());
    protected static final int INTERNAL_STATE_START_DOCUMENT = 0;
    protected static final int INTERNAL_STATE_START_ELEMENT_TERMINATE = 1;
    protected static final int INTERNAL_STATE_SINGLE_TERMINATE_ELEMENT_WITH_NAMESPACES = 2;
    protected static final int INTERNAL_STATE_DOUBLE_TERMINATE_ELEMENT = 3;
    protected static final int INTERNAL_STATE_END_DOCUMENT = 4;
    protected static final int INTERNAL_STATE_VOID = -1;
    protected int _internalState;
    protected int _eventType;
    protected QualifiedName[] _qNameStack = new QualifiedName[32];
    protected int[] _namespaceAIIsStartStack = new int[32];
    protected int[] _namespaceAIIsEndStack = new int[32];
    protected int _stackCount = -1;
    protected String[] _namespaceAIIsPrefix = new String[32];
    protected String[] _namespaceAIIsNamespaceName = new String[32];
    protected int[] _namespaceAIIsPrefixIndex = new int[32];
    protected int _namespaceAIIsIndex;
    protected int _currentNamespaceAIIsStart;
    protected int _currentNamespaceAIIsEnd;
    protected QualifiedName _qualifiedName;
    protected AttributesHolder _attributes = new AttributesHolder();
    protected boolean _clearAttributes = false;
    protected char[] _characters;
    protected int _charactersOffset;
    protected String _algorithmURI;
    protected int _algorithmId;
    protected boolean _isAlgorithmDataCloned;
    protected byte[] _algorithmData;
    protected int _algorithmDataOffset;
    protected int _algorithmDataLength;
    protected String _piTarget;
    protected String _piData;
    protected NamespaceContextImpl _nsContext = new NamespaceContextImpl();
    protected String _characterEncodingScheme;
    protected StAXManager _manager;
    private byte[] base64TaleBytes = new byte[3];
    private int base64TaleLength;

    public StAXDocumentParser() {
        this.reset();
        this._manager = new StAXManager(1);
    }

    public StAXDocumentParser(InputStream inputStream) {
        this();
        this.setInputStream(inputStream);
        this._manager = new StAXManager(1);
    }

    public StAXDocumentParser(InputStream inputStream, StAXManager stAXManager) {
        this(inputStream);
        this._manager = stAXManager;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        super.setInputStream(inputStream);
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        if (this._internalState != 0 && this._internalState != 4) {
            for (int i = this._namespaceAIIsIndex - 1; i >= 0; --i) {
                this._prefixTable.popScopeWithPrefixEntry(this._namespaceAIIsPrefixIndex[i]);
            }
            this._stackCount = -1;
            this._namespaceAIIsIndex = 0;
            this._characters = null;
            this._algorithmData = null;
        }
        this._characterEncodingScheme = "UTF-8";
        this._eventType = 7;
        this._internalState = 0;
    }

    protected void resetOnError() {
        super.reset();
        if (this._v != null) {
            this._prefixTable.clearCompletely();
        }
        this._duplicateAttributeVerifier.clear();
        this._stackCount = -1;
        this._namespaceAIIsIndex = 0;
        this._characters = null;
        this._algorithmData = null;
        this._eventType = 7;
        this._internalState = 0;
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        if (this._manager != null) {
            return this._manager.getProperty(string);
        }
        return null;
    }

    @Override
    public int next() throws XMLStreamException {
        try {
            int n;
            if (this._internalState != -1) {
                switch (this._internalState) {
                    case 0: {
                        this.decodeHeader();
                        this.processDII();
                        this._internalState = -1;
                        break;
                    }
                    case 1: {
                        if (this._currentNamespaceAIIsEnd > 0) {
                            for (int i = this._currentNamespaceAIIsEnd - 1; i >= this._currentNamespaceAIIsStart; --i) {
                                this._prefixTable.popScopeWithPrefixEntry(this._namespaceAIIsPrefixIndex[i]);
                            }
                            this._namespaceAIIsIndex = this._currentNamespaceAIIsStart;
                        }
                        this.popStack();
                        this._internalState = -1;
                        this._eventType = 2;
                        return 2;
                    }
                    case 2: {
                        for (n = this._currentNamespaceAIIsEnd - 1; n >= this._currentNamespaceAIIsStart; --n) {
                            this._prefixTable.popScopeWithPrefixEntry(this._namespaceAIIsPrefixIndex[n]);
                        }
                        this._namespaceAIIsIndex = this._currentNamespaceAIIsStart;
                        this._internalState = -1;
                        break;
                    }
                    case 3: {
                        if (this._currentNamespaceAIIsEnd > 0) {
                            for (int i = this._currentNamespaceAIIsEnd - 1; i >= this._currentNamespaceAIIsStart; --i) {
                                this._prefixTable.popScopeWithPrefixEntry(this._namespaceAIIsPrefixIndex[i]);
                            }
                            this._namespaceAIIsIndex = this._currentNamespaceAIIsStart;
                        }
                        if (this._stackCount == -1) {
                            this._internalState = 4;
                            this._eventType = 8;
                            return 8;
                        }
                        this.popStack();
                        this._internalState = this._currentNamespaceAIIsEnd > 0 ? 2 : -1;
                        this._eventType = 2;
                        return 2;
                    }
                    case 4: {
                        throw new NoSuchElementException(CommonResourceBundle.getInstance().getString("message.noMoreEvents"));
                    }
                }
            }
            this._characters = null;
            this._algorithmData = null;
            this._currentNamespaceAIIsEnd = 0;
            n = this.read();
            switch (DecoderStateTables.EII(n)) {
                case 0: {
                    this.processEII(this._elementNameTable._array[n], false);
                    return this._eventType;
                }
                case 1: {
                    this.processEII(this._elementNameTable._array[n & 0x1F], true);
                    return this._eventType;
                }
                case 2: {
                    this.processEII(this.processEIIIndexMedium(n), (n & 0x40) > 0);
                    return this._eventType;
                }
                case 3: {
                    this.processEII(this.processEIIIndexLarge(n), (n & 0x40) > 0);
                    return this._eventType;
                }
                case 5: {
                    QualifiedName qualifiedName = this.processLiteralQualifiedName(n & 3, this._elementNameTable.getNext());
                    this._elementNameTable.add(qualifiedName);
                    this.processEII(qualifiedName, (n & 0x40) > 0);
                    return this._eventType;
                }
                case 4: {
                    this.processEIIWithNamespaces((n & 0x40) > 0);
                    return this._eventType;
                }
                case 6: {
                    this._octetBufferLength = (n & 1) + 1;
                    this.processUtf8CharacterString(n);
                    this._eventType = 4;
                    return 4;
                }
                case 7: {
                    this._octetBufferLength = this.read() + 3;
                    this.processUtf8CharacterString(n);
                    this._eventType = 4;
                    return 4;
                }
                case 8: {
                    this._octetBufferLength = (this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read()) + 259;
                    this.processUtf8CharacterString(n);
                    this._eventType = 4;
                    return 4;
                }
                case 9: {
                    this._octetBufferLength = (n & 1) + 1;
                    this.processUtf16CharacterString(n);
                    this._eventType = 4;
                    return 4;
                }
                case 10: {
                    this._octetBufferLength = this.read() + 3;
                    this.processUtf16CharacterString(n);
                    this._eventType = 4;
                    return 4;
                }
                case 11: {
                    this._octetBufferLength = (this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read()) + 259;
                    this.processUtf16CharacterString(n);
                    this._eventType = 4;
                    return 4;
                }
                case 12: {
                    boolean bl = (n & 0x10) > 0;
                    this._identifier = (n & 2) << 6;
                    int n2 = this.read();
                    this._identifier |= (n2 & 0xFC) >> 2;
                    this.decodeOctetsOnSeventhBitOfNonIdentifyingStringOnThirdBit(n2);
                    this.decodeRestrictedAlphabetAsCharBuffer();
                    if (bl) {
                        this._charactersOffset = this._characterContentChunkTable.add(this._charBuffer, this._charBufferLength);
                        this._characters = this._characterContentChunkTable._array;
                    } else {
                        this._characters = this._charBuffer;
                        this._charactersOffset = 0;
                    }
                    this._eventType = 4;
                    return 4;
                }
                case 13: {
                    boolean bl = (n & 0x10) > 0;
                    this._algorithmId = (n & 2) << 6;
                    int n3 = this.read();
                    this._algorithmId |= (n3 & 0xFC) >> 2;
                    this.decodeOctetsOnSeventhBitOfNonIdentifyingStringOnThirdBit(n3);
                    this.processCIIEncodingAlgorithm(bl);
                    if (this._algorithmId == 9) {
                        this._eventType = 12;
                        return 12;
                    }
                    this._eventType = 4;
                    return 4;
                }
                case 14: {
                    int n4;
                    this._characterContentChunkTable._cachedIndex = n4 = n & 0xF;
                    this._characters = this._characterContentChunkTable._array;
                    this._charactersOffset = this._characterContentChunkTable._offset[n4];
                    this._charBufferLength = this._characterContentChunkTable._length[n4];
                    this._eventType = 4;
                    return 4;
                }
                case 15: {
                    int n5;
                    this._characterContentChunkTable._cachedIndex = n5 = ((n & 3) << 8 | this.read()) + 16;
                    this._characters = this._characterContentChunkTable._array;
                    this._charactersOffset = this._characterContentChunkTable._offset[n5];
                    this._charBufferLength = this._characterContentChunkTable._length[n5];
                    this._eventType = 4;
                    return 4;
                }
                case 16: {
                    int n6;
                    this._characterContentChunkTable._cachedIndex = n6 = ((n & 3) << 16 | this.read() << 8 | this.read()) + 1040;
                    this._characters = this._characterContentChunkTable._array;
                    this._charactersOffset = this._characterContentChunkTable._offset[n6];
                    this._charBufferLength = this._characterContentChunkTable._length[n6];
                    this._eventType = 4;
                    return 4;
                }
                case 17: {
                    int n7;
                    this._characterContentChunkTable._cachedIndex = n7 = (this.read() << 16 | this.read() << 8 | this.read()) + 263184;
                    this._characters = this._characterContentChunkTable._array;
                    this._charactersOffset = this._characterContentChunkTable._offset[n7];
                    this._charBufferLength = this._characterContentChunkTable._length[n7];
                    this._eventType = 4;
                    return 4;
                }
                case 18: {
                    this.processCommentII();
                    return this._eventType;
                }
                case 19: {
                    this.processProcessingII();
                    return this._eventType;
                }
                case 21: {
                    this.processUnexpandedEntityReference(n);
                    return this.next();
                }
                case 23: {
                    if (this._stackCount != -1) {
                        this.popStack();
                        this._internalState = 3;
                        this._eventType = 2;
                        return 2;
                    }
                    this._internalState = 4;
                    this._eventType = 8;
                    return 8;
                }
                case 22: {
                    if (this._stackCount != -1) {
                        this.popStack();
                        if (this._currentNamespaceAIIsEnd > 0) {
                            this._internalState = 2;
                        }
                        this._eventType = 2;
                        return 2;
                    }
                    this._internalState = 4;
                    this._eventType = 8;
                    return 8;
                }
            }
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.IllegalStateDecodingEII"));
        }
        catch (IOException iOException) {
            this.resetOnError();
            logger.log(Level.FINE, "next() exception", iOException);
            throw new XMLStreamException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            this.resetOnError();
            logger.log(Level.FINE, "next() exception", fastInfosetException);
            throw new XMLStreamException(fastInfosetException);
        }
        catch (RuntimeException runtimeException) {
            this.resetOnError();
            logger.log(Level.FINE, "next() exception", runtimeException);
            throw runtimeException;
        }
    }

    private final void processUtf8CharacterString(int n) throws IOException {
        if ((n & 0x10) > 0) {
            this._characterContentChunkTable.ensureSize(this._octetBufferLength);
            this._characters = this._characterContentChunkTable._array;
            this._charactersOffset = this._characterContentChunkTable._arrayIndex;
            this.decodeUtf8StringAsCharBuffer(this._characterContentChunkTable._array, this._charactersOffset);
            this._characterContentChunkTable.add(this._charBufferLength);
        } else {
            this.decodeUtf8StringAsCharBuffer();
            this._characters = this._charBuffer;
            this._charactersOffset = 0;
        }
    }

    private final void processUtf16CharacterString(int n) throws IOException {
        this.decodeUtf16StringAsCharBuffer();
        if ((n & 0x10) > 0) {
            this._charactersOffset = this._characterContentChunkTable.add(this._charBuffer, this._charBufferLength);
            this._characters = this._characterContentChunkTable._array;
        } else {
            this._characters = this._charBuffer;
            this._charactersOffset = 0;
        }
    }

    private final void popStack() {
        this._qualifiedName = this._qNameStack[this._stackCount];
        this._currentNamespaceAIIsStart = this._namespaceAIIsStartStack[this._stackCount];
        this._currentNamespaceAIIsEnd = this._namespaceAIIsEndStack[this._stackCount];
        this._qNameStack[this._stackCount--] = null;
    }

    @Override
    public final void require(int n, String string, String string2) throws XMLStreamException {
        if (n != this._eventType) {
            throw new XMLStreamException(CommonResourceBundle.getInstance().getString("message.eventTypeNotMatch", new Object[]{StAXDocumentParser.getEventTypeString(n)}));
        }
        if (string != null && !string.equals(this.getNamespaceURI())) {
            throw new XMLStreamException(CommonResourceBundle.getInstance().getString("message.namespaceURINotMatch", new Object[]{string}));
        }
        if (string2 != null && !string2.equals(this.getLocalName())) {
            throw new XMLStreamException(CommonResourceBundle.getInstance().getString("message.localNameNotMatch", new Object[]{string2}));
        }
    }

    @Override
    public final String getElementText() throws XMLStreamException {
        if (this.getEventType() != 1) {
            throw new XMLStreamException(CommonResourceBundle.getInstance().getString("message.mustBeOnSTARTELEMENT"), this.getLocation());
        }
        this.next();
        return this.getElementText(true);
    }

    public final String getElementText(boolean bl) throws XMLStreamException {
        if (!bl) {
            throw new XMLStreamException(CommonResourceBundle.getInstance().getString("message.mustBeOnSTARTELEMENT"), this.getLocation());
        }
        int n = this.getEventType();
        StringBuffer stringBuffer = new StringBuffer();
        while (n != 2) {
            if (n == 4 || n == 12 || n == 6 || n == 9) {
                stringBuffer.append(this.getText());
            } else if (n != 3 && n != 5) {
                if (n == 8) {
                    throw new XMLStreamException(CommonResourceBundle.getInstance().getString("message.unexpectedEOF"));
                }
                if (n == 1) {
                    throw new XMLStreamException(CommonResourceBundle.getInstance().getString("message.getElementTextExpectTextOnly"), this.getLocation());
                }
                throw new XMLStreamException(CommonResourceBundle.getInstance().getString("message.unexpectedEventType") + StAXDocumentParser.getEventTypeString(n), this.getLocation());
            }
            n = this.next();
        }
        return stringBuffer.toString();
    }

    @Override
    public final int nextTag() throws XMLStreamException {
        this.next();
        return this.nextTag(true);
    }

    public final int nextTag(boolean bl) throws XMLStreamException {
        int n = this.getEventType();
        if (!bl) {
            n = this.next();
        }
        while (n == 4 && this.isWhiteSpace() || n == 12 && this.isWhiteSpace() || n == 6 || n == 3 || n == 5) {
            n = this.next();
        }
        if (n != 1 && n != 2) {
            throw new XMLStreamException(CommonResourceBundle.getInstance().getString("message.expectedStartOrEnd"), this.getLocation());
        }
        return n;
    }

    @Override
    public final boolean hasNext() throws XMLStreamException {
        return this._eventType != 8;
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            super.closeIfRequired();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final String getNamespaceURI(String string) {
        String string2 = this.getNamespaceDecl(string);
        if (string2 == null) {
            if (string == null) {
                throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.nullPrefix"));
            }
            return null;
        }
        return string2;
    }

    @Override
    public final boolean isStartElement() {
        return this._eventType == 1;
    }

    @Override
    public final boolean isEndElement() {
        return this._eventType == 2;
    }

    @Override
    public final boolean isCharacters() {
        return this._eventType == 4;
    }

    @Override
    public final boolean isWhiteSpace() {
        if (this.isCharacters() || this._eventType == 12) {
            char[] cArray = this.getTextCharacters();
            int n = this.getTextStart();
            int n2 = this.getTextLength();
            for (int i = n; i < n + n2; ++i) {
                if (XMLChar.isSpace(cArray[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final String getAttributeValue(String string, String string2) {
        if (this._eventType != 1) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetAttributeValue"));
        }
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        if (string != null) {
            for (int i = 0; i < this._attributes.getLength(); ++i) {
                if (!this._attributes.getLocalName(i).equals(string2) || !this._attributes.getURI(i).equals(string)) continue;
                return this._attributes.getValue(i);
            }
        } else {
            for (int i = 0; i < this._attributes.getLength(); ++i) {
                if (!this._attributes.getLocalName(i).equals(string2)) continue;
                return this._attributes.getValue(i);
            }
        }
        return null;
    }

    @Override
    public final int getAttributeCount() {
        if (this._eventType != 1) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetAttributeValue"));
        }
        return this._attributes.getLength();
    }

    @Override
    public final QName getAttributeName(int n) {
        if (this._eventType != 1) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetAttributeValue"));
        }
        return this._attributes.getQualifiedName(n).getQName();
    }

    @Override
    public final String getAttributeNamespace(int n) {
        if (this._eventType != 1) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetAttributeValue"));
        }
        return this._attributes.getURI(n);
    }

    @Override
    public final String getAttributeLocalName(int n) {
        if (this._eventType != 1) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetAttributeValue"));
        }
        return this._attributes.getLocalName(n);
    }

    @Override
    public final String getAttributePrefix(int n) {
        if (this._eventType != 1) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetAttributeValue"));
        }
        return this._attributes.getPrefix(n);
    }

    @Override
    public final String getAttributeType(int n) {
        if (this._eventType != 1) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetAttributeValue"));
        }
        return this._attributes.getType(n);
    }

    @Override
    public final String getAttributeValue(int n) {
        if (this._eventType != 1) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetAttributeValue"));
        }
        return this._attributes.getValue(n);
    }

    @Override
    public final boolean isAttributeSpecified(int n) {
        return false;
    }

    @Override
    public final int getNamespaceCount() {
        if (this._eventType == 1 || this._eventType == 2) {
            return this._currentNamespaceAIIsEnd > 0 ? this._currentNamespaceAIIsEnd - this._currentNamespaceAIIsStart : 0;
        }
        throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetNamespaceCount"));
    }

    @Override
    public final String getNamespacePrefix(int n) {
        if (this._eventType == 1 || this._eventType == 2) {
            return this._namespaceAIIsPrefix[this._currentNamespaceAIIsStart + n];
        }
        throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetNamespacePrefix"));
    }

    @Override
    public final String getNamespaceURI(int n) {
        if (this._eventType == 1 || this._eventType == 2) {
            return this._namespaceAIIsNamespaceName[this._currentNamespaceAIIsStart + n];
        }
        throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetNamespacePrefix"));
    }

    @Override
    public final NamespaceContext getNamespaceContext() {
        return this._nsContext;
    }

    @Override
    public final int getEventType() {
        return this._eventType;
    }

    @Override
    public final String getText() {
        if (this._characters == null) {
            this.checkTextState();
        }
        if (this._characters == this._characterContentChunkTable._array) {
            return this._characterContentChunkTable.getString(this._characterContentChunkTable._cachedIndex);
        }
        return new String(this._characters, this._charactersOffset, this._charBufferLength);
    }

    @Override
    public final char[] getTextCharacters() {
        if (this._characters == null) {
            this.checkTextState();
        }
        return this._characters;
    }

    @Override
    public final int getTextStart() {
        if (this._characters == null) {
            this.checkTextState();
        }
        return this._charactersOffset;
    }

    @Override
    public final int getTextLength() {
        if (this._characters == null) {
            this.checkTextState();
        }
        return this._charBufferLength;
    }

    @Override
    public final int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        if (this._characters == null) {
            this.checkTextState();
        }
        try {
            int n4 = Math.min(this._charBufferLength, n3);
            System.arraycopy(this._characters, this._charactersOffset + n, cArray, n2, n4);
            return n4;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new XMLStreamException(indexOutOfBoundsException);
        }
    }

    protected final void checkTextState() {
        if (this._algorithmData == null) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.InvalidStateForText"));
        }
        try {
            this.convertEncodingAlgorithmDataToCharacters();
        }
        catch (Exception exception) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.InvalidStateForText"));
        }
    }

    @Override
    public final String getEncoding() {
        return this._characterEncodingScheme;
    }

    @Override
    public final boolean hasText() {
        return this._characters != null;
    }

    @Override
    public final Location getLocation() {
        return EventLocation.getNilLocation();
    }

    @Override
    public final QName getName() {
        if (this._eventType == 1 || this._eventType == 2) {
            return this._qualifiedName.getQName();
        }
        throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetName"));
    }

    @Override
    public final String getLocalName() {
        if (this._eventType == 1 || this._eventType == 2) {
            return this._qualifiedName.localName;
        }
        throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetLocalName"));
    }

    @Override
    public final boolean hasName() {
        return this._eventType == 1 || this._eventType == 2;
    }

    @Override
    public final String getNamespaceURI() {
        if (this._eventType == 1 || this._eventType == 2) {
            return this._qualifiedName.namespaceName;
        }
        throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetNamespaceURI"));
    }

    @Override
    public final String getPrefix() {
        if (this._eventType == 1 || this._eventType == 2) {
            return this._qualifiedName.prefix;
        }
        throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetPrefix"));
    }

    @Override
    public final String getVersion() {
        return null;
    }

    @Override
    public final boolean isStandalone() {
        return false;
    }

    @Override
    public final boolean standaloneSet() {
        return false;
    }

    @Override
    public final String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public final String getPITarget() {
        if (this._eventType != 3) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetPITarget"));
        }
        return this._piTarget;
    }

    @Override
    public final String getPIData() {
        if (this._eventType != 3) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetPIData"));
        }
        return this._piData;
    }

    public final String getNameString() {
        if (this._eventType == 1 || this._eventType == 2) {
            return this._qualifiedName.getQNameString();
        }
        throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetName"));
    }

    public final String getAttributeNameString(int n) {
        if (this._eventType != 1) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.invalidCallingGetAttributeValue"));
        }
        return this._attributes.getQualifiedName(n).getQNameString();
    }

    public final String getTextAlgorithmURI() {
        return this._algorithmURI;
    }

    public final int getTextAlgorithmIndex() {
        return this._algorithmId;
    }

    public final byte[] getTextAlgorithmBytes() {
        return this._algorithmData;
    }

    public final byte[] getTextAlgorithmBytesClone() {
        if (this._algorithmData == null) {
            return null;
        }
        byte[] byArray = new byte[this._algorithmDataLength];
        System.arraycopy(this._algorithmData, this._algorithmDataOffset, byArray, 0, this._algorithmDataLength);
        return byArray;
    }

    public final int getTextAlgorithmStart() {
        return this._algorithmDataOffset;
    }

    public final int getTextAlgorithmLength() {
        return this._algorithmDataLength;
    }

    public final int getTextAlgorithmBytes(int n, byte[] byArray, int n2, int n3) throws XMLStreamException {
        try {
            System.arraycopy(this._algorithmData, n, byArray, n2, n3);
            return n3;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new XMLStreamException(indexOutOfBoundsException);
        }
    }

    @Override
    public final int peekNext() throws XMLStreamException {
        try {
            switch (DecoderStateTables.EII(this.peek(this))) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return 1;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    return 4;
                }
                case 18: {
                    return 5;
                }
                case 19: {
                    return 3;
                }
                case 21: {
                    return 9;
                }
                case 22: 
                case 23: {
                    return this._stackCount != -1 ? 2 : 8;
                }
            }
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.IllegalStateDecodingEII"));
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        catch (FastInfosetException fastInfosetException) {
            throw new XMLStreamException(fastInfosetException);
        }
    }

    @Override
    public void onBeforeOctetBufferOverwrite() {
        if (this._algorithmData != null) {
            this._algorithmData = this.getTextAlgorithmBytesClone();
            this._algorithmDataOffset = 0;
            this._isAlgorithmDataCloned = true;
        }
    }

    @Override
    public final int accessNamespaceCount() {
        return this._currentNamespaceAIIsEnd > 0 ? this._currentNamespaceAIIsEnd - this._currentNamespaceAIIsStart : 0;
    }

    @Override
    public final String accessLocalName() {
        return this._qualifiedName.localName;
    }

    @Override
    public final String accessNamespaceURI() {
        return this._qualifiedName.namespaceName;
    }

    @Override
    public final String accessPrefix() {
        return this._qualifiedName.prefix;
    }

    @Override
    public final char[] accessTextCharacters() {
        return this._characters;
    }

    @Override
    public final int accessTextStart() {
        return this._charactersOffset;
    }

    @Override
    public final int accessTextLength() {
        return this._charBufferLength;
    }

    protected final void processDII() throws FastInfosetException, IOException {
        int n = this.read();
        if (n > 0) {
            this.processDIIOptionalProperties(n);
        }
    }

    protected final void processDIIOptionalProperties(int n) throws FastInfosetException, IOException {
        if (n == 32) {
            this.decodeInitialVocabulary();
            return;
        }
        if ((n & 0x40) > 0) {
            this.decodeAdditionalData();
        }
        if ((n & 0x20) > 0) {
            this.decodeInitialVocabulary();
        }
        if ((n & 0x10) > 0) {
            this.decodeNotations();
        }
        if ((n & 8) > 0) {
            this.decodeUnparsedEntities();
        }
        if ((n & 4) > 0) {
            this._characterEncodingScheme = this.decodeCharacterEncodingScheme();
        }
        if ((n & 2) > 0) {
            boolean bl;
            boolean bl2 = bl = this.read() > 0;
        }
        if ((n & 1) > 0) {
            this.decodeVersion();
        }
    }

    protected final void resizeNamespaceAIIs() {
        String[] stringArray = new String[this._namespaceAIIsIndex * 2];
        System.arraycopy(this._namespaceAIIsPrefix, 0, stringArray, 0, this._namespaceAIIsIndex);
        this._namespaceAIIsPrefix = stringArray;
        String[] stringArray2 = new String[this._namespaceAIIsIndex * 2];
        System.arraycopy(this._namespaceAIIsNamespaceName, 0, stringArray2, 0, this._namespaceAIIsIndex);
        this._namespaceAIIsNamespaceName = stringArray2;
        int[] nArray = new int[this._namespaceAIIsIndex * 2];
        System.arraycopy(this._namespaceAIIsPrefixIndex, 0, nArray, 0, this._namespaceAIIsIndex);
        this._namespaceAIIsPrefixIndex = nArray;
    }

    protected final void processEIIWithNamespaces(boolean bl) throws FastInfosetException, IOException {
        if (++this._prefixTable._declarationId == Integer.MAX_VALUE) {
            this._prefixTable.clearDeclarationIds();
        }
        this._currentNamespaceAIIsStart = this._namespaceAIIsIndex;
        String string = "";
        String string2 = "";
        int n = this.read();
        while ((n & 0xFC) == 204) {
            if (this._namespaceAIIsIndex == this._namespaceAIIsPrefix.length) {
                this.resizeNamespaceAIIs();
            }
            switch (n & 3) {
                case 0: {
                    this._namespaceAIIsNamespaceName[this._namespaceAIIsIndex] = "";
                    this._namespaceAIIsPrefix[this._namespaceAIIsIndex] = "";
                    string2 = "";
                    string = "";
                    this._namespaceAIIsPrefixIndex[this._namespaceAIIsIndex++] = -1;
                    this._prefixIndex = -1;
                    this._namespaceNameIndex = -1;
                    break;
                }
                case 1: {
                    this._namespaceAIIsPrefix[this._namespaceAIIsIndex] = "";
                    string = "";
                    string2 = this._namespaceAIIsNamespaceName[this._namespaceAIIsIndex] = this.decodeIdentifyingNonEmptyStringOnFirstBitAsNamespaceName(false);
                    this._namespaceAIIsPrefixIndex[this._namespaceAIIsIndex++] = -1;
                    this._prefixIndex = -1;
                    break;
                }
                case 2: {
                    string = this._namespaceAIIsPrefix[this._namespaceAIIsIndex] = this.decodeIdentifyingNonEmptyStringOnFirstBitAsPrefix(false);
                    this._namespaceAIIsNamespaceName[this._namespaceAIIsIndex] = "";
                    string2 = "";
                    this._namespaceNameIndex = -1;
                    this._namespaceAIIsPrefixIndex[this._namespaceAIIsIndex++] = this._prefixIndex;
                    break;
                }
                case 3: {
                    string = this._namespaceAIIsPrefix[this._namespaceAIIsIndex] = this.decodeIdentifyingNonEmptyStringOnFirstBitAsPrefix(true);
                    string2 = this._namespaceAIIsNamespaceName[this._namespaceAIIsIndex] = this.decodeIdentifyingNonEmptyStringOnFirstBitAsNamespaceName(true);
                    this._namespaceAIIsPrefixIndex[this._namespaceAIIsIndex++] = this._prefixIndex;
                }
            }
            this._prefixTable.pushScopeWithPrefixEntry(string, string2, this._prefixIndex, this._namespaceNameIndex);
            n = this.read();
        }
        if (n != 240) {
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.EIInamespaceNameNotTerminatedCorrectly"));
        }
        this._currentNamespaceAIIsEnd = this._namespaceAIIsIndex;
        n = this.read();
        switch (DecoderStateTables.EII(n)) {
            case 0: {
                this.processEII(this._elementNameTable._array[n], bl);
                break;
            }
            case 2: {
                this.processEII(this.processEIIIndexMedium(n), bl);
                break;
            }
            case 3: {
                this.processEII(this.processEIIIndexLarge(n), bl);
                break;
            }
            case 5: {
                QualifiedName qualifiedName = this.processLiteralQualifiedName(n & 3, this._elementNameTable.getNext());
                this._elementNameTable.add(qualifiedName);
                this.processEII(qualifiedName, bl);
                break;
            }
            default: {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.IllegalStateDecodingEIIAfterAIIs"));
            }
        }
    }

    protected final void processEII(QualifiedName qualifiedName, boolean bl) throws FastInfosetException, IOException {
        if (this._prefixTable._currentInScope[qualifiedName.prefixIndex] != qualifiedName.namespaceNameIndex) {
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.qnameOfEIINotInScope"));
        }
        this._eventType = 1;
        this._qualifiedName = qualifiedName;
        if (this._clearAttributes) {
            this._attributes.clear();
            this._clearAttributes = false;
        }
        if (bl) {
            this.processAIIs();
        }
        ++this._stackCount;
        if (this._stackCount == this._qNameStack.length) {
            QualifiedName[] qualifiedNameArray = new QualifiedName[this._qNameStack.length * 2];
            System.arraycopy(this._qNameStack, 0, qualifiedNameArray, 0, this._qNameStack.length);
            this._qNameStack = qualifiedNameArray;
            int[] nArray = new int[this._namespaceAIIsStartStack.length * 2];
            System.arraycopy(this._namespaceAIIsStartStack, 0, nArray, 0, this._namespaceAIIsStartStack.length);
            this._namespaceAIIsStartStack = nArray;
            int[] nArray2 = new int[this._namespaceAIIsEndStack.length * 2];
            System.arraycopy(this._namespaceAIIsEndStack, 0, nArray2, 0, this._namespaceAIIsEndStack.length);
            this._namespaceAIIsEndStack = nArray2;
        }
        this._qNameStack[this._stackCount] = this._qualifiedName;
        this._namespaceAIIsStartStack[this._stackCount] = this._currentNamespaceAIIsStart;
        this._namespaceAIIsEndStack[this._stackCount] = this._currentNamespaceAIIsEnd;
    }

    protected final void processAIIs() throws FastInfosetException, IOException {
        if (++this._duplicateAttributeVerifier._currentIteration == Integer.MAX_VALUE) {
            this._duplicateAttributeVerifier.clear();
        }
        this._clearAttributes = true;
        boolean bl = false;
        block22: do {
            boolean bl2;
            QualifiedName qualifiedName;
            int n = this.read();
            switch (DecoderStateTables.AII(n)) {
                case 0: {
                    qualifiedName = this._attributeNameTable._array[n];
                    break;
                }
                case 1: {
                    bl2 = ((n & 0x1F) << 8 | this.read()) + 64;
                    qualifiedName = this._attributeNameTable._array[bl2];
                    break;
                }
                case 2: {
                    bl2 = ((n & 0xF) << 16 | this.read() << 8 | this.read()) + 8256;
                    qualifiedName = this._attributeNameTable._array[bl2];
                    break;
                }
                case 3: {
                    qualifiedName = this.processLiteralQualifiedName(n & 3, this._attributeNameTable.getNext());
                    qualifiedName.createAttributeValues(256);
                    this._attributeNameTable.add(qualifiedName);
                    break;
                }
                case 5: {
                    this._internalState = 1;
                }
                case 4: {
                    bl = true;
                    continue block22;
                }
                default: {
                    throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingAIIs"));
                }
            }
            if (qualifiedName.prefixIndex > 0 && this._prefixTable._currentInScope[qualifiedName.prefixIndex] != qualifiedName.namespaceNameIndex) {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.AIIqNameNotInScope"));
            }
            this._duplicateAttributeVerifier.checkForDuplicateAttribute(qualifiedName.attributeHash, qualifiedName.attributeId);
            n = this.read();
            switch (DecoderStateTables.NISTRING(n)) {
                case 0: {
                    this._octetBufferLength = (n & 7) + 1;
                    String string = this.decodeUtf8StringAsString();
                    if ((n & 0x40) > 0) {
                        this._attributeValueTable.add(string);
                    }
                    this._attributes.addAttribute(qualifiedName, string);
                    break;
                }
                case 1: {
                    this._octetBufferLength = this.read() + 9;
                    String string = this.decodeUtf8StringAsString();
                    if ((n & 0x40) > 0) {
                        this._attributeValueTable.add(string);
                    }
                    this._attributes.addAttribute(qualifiedName, string);
                    break;
                }
                case 2: {
                    this._octetBufferLength = (this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read()) + 265;
                    String string = this.decodeUtf8StringAsString();
                    if ((n & 0x40) > 0) {
                        this._attributeValueTable.add(string);
                    }
                    this._attributes.addAttribute(qualifiedName, string);
                    break;
                }
                case 3: {
                    this._octetBufferLength = (n & 7) + 1;
                    String string = this.decodeUtf16StringAsString();
                    if ((n & 0x40) > 0) {
                        this._attributeValueTable.add(string);
                    }
                    this._attributes.addAttribute(qualifiedName, string);
                    break;
                }
                case 4: {
                    this._octetBufferLength = this.read() + 9;
                    String string = this.decodeUtf16StringAsString();
                    if ((n & 0x40) > 0) {
                        this._attributeValueTable.add(string);
                    }
                    this._attributes.addAttribute(qualifiedName, string);
                    break;
                }
                case 5: {
                    this._octetBufferLength = (this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read()) + 265;
                    String string = this.decodeUtf16StringAsString();
                    if ((n & 0x40) > 0) {
                        this._attributeValueTable.add(string);
                    }
                    this._attributes.addAttribute(qualifiedName, string);
                    break;
                }
                case 6: {
                    bl2 = (n & 0x40) > 0;
                    this._identifier = (n & 0xF) << 4;
                    n = this.read();
                    this._identifier |= (n & 0xF0) >> 4;
                    this.decodeOctetsOnFifthBitOfNonIdentifyingStringOnFirstBit(n);
                    String string = this.decodeRestrictedAlphabetAsString();
                    if (bl2) {
                        this._attributeValueTable.add(string);
                    }
                    this._attributes.addAttribute(qualifiedName, string);
                    break;
                }
                case 7: {
                    bl2 = (n & 0x40) > 0;
                    this._identifier = (n & 0xF) << 4;
                    n = this.read();
                    this._identifier |= (n & 0xF0) >> 4;
                    this.decodeOctetsOnFifthBitOfNonIdentifyingStringOnFirstBit(n);
                    this.processAIIEncodingAlgorithm(qualifiedName, bl2);
                    break;
                }
                case 8: {
                    this._attributes.addAttribute(qualifiedName, this._attributeValueTable._array[n & 0x3F]);
                    break;
                }
                case 9: {
                    bl2 = ((n & 0x1F) << 8 | this.read()) + 64;
                    this._attributes.addAttribute(qualifiedName, this._attributeValueTable._array[bl2]);
                    break;
                }
                case 10: {
                    bl2 = ((n & 0xF) << 16 | this.read() << 8 | this.read()) + 8256;
                    this._attributes.addAttribute(qualifiedName, this._attributeValueTable._array[bl2]);
                    break;
                }
                case 11: {
                    this._attributes.addAttribute(qualifiedName, "");
                    break;
                }
                default: {
                    throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingAIIValue"));
                }
            }
        } while (!bl);
        this._duplicateAttributeVerifier._poolCurrent = this._duplicateAttributeVerifier._poolHead;
    }

    protected final QualifiedName processEIIIndexMedium(int n) throws FastInfosetException, IOException {
        int n2 = ((n & 7) << 8 | this.read()) + 32;
        return this._elementNameTable._array[n2];
    }

    protected final QualifiedName processEIIIndexLarge(int n) throws FastInfosetException, IOException {
        int n2 = (n & 0x30) == 32 ? ((n & 7) << 16 | this.read() << 8 | this.read()) + 2080 : ((this.read() & 0xF) << 16 | this.read() << 8 | this.read()) + 526368;
        return this._elementNameTable._array[n2];
    }

    protected final QualifiedName processLiteralQualifiedName(int n, QualifiedName qualifiedName) throws FastInfosetException, IOException {
        if (qualifiedName == null) {
            qualifiedName = new QualifiedName();
        }
        switch (n) {
            case 0: {
                return qualifiedName.set("", "", this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.localName), "", 0, -1, -1, this._identifier);
            }
            case 1: {
                return qualifiedName.set("", this.decodeIdentifyingNonEmptyStringIndexOnFirstBitAsNamespaceName(false), this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.localName), "", 0, -1, this._namespaceNameIndex, this._identifier);
            }
            case 2: {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.qNameMissingNamespaceName"));
            }
            case 3: {
                return qualifiedName.set(this.decodeIdentifyingNonEmptyStringIndexOnFirstBitAsPrefix(true), this.decodeIdentifyingNonEmptyStringIndexOnFirstBitAsNamespaceName(true), this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.localName), "", 0, this._prefixIndex, this._namespaceNameIndex, this._identifier);
            }
        }
        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingEII"));
    }

    protected final void processCommentII() throws FastInfosetException, IOException {
        this._eventType = 5;
        switch (this.decodeNonIdentifyingStringOnFirstBit()) {
            case 0: {
                if (this._addToTable) {
                    this._v.otherString.add(new CharArray(this._charBuffer, 0, this._charBufferLength, true));
                }
                this._characters = this._charBuffer;
                this._charactersOffset = 0;
                break;
            }
            case 2: {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.commentIIAlgorithmNotSupported"));
            }
            case 1: {
                CharArray charArray = this._v.otherString.get(this._integer);
                this._characters = charArray.ch;
                this._charactersOffset = charArray.start;
                this._charBufferLength = charArray.length;
                break;
            }
            case 3: {
                this._characters = this._charBuffer;
                this._charactersOffset = 0;
                this._charBufferLength = 0;
            }
        }
    }

    protected final void processProcessingII() throws FastInfosetException, IOException {
        this._eventType = 3;
        this._piTarget = this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherNCName);
        switch (this.decodeNonIdentifyingStringOnFirstBit()) {
            case 0: {
                this._piData = new String(this._charBuffer, 0, this._charBufferLength);
                if (!this._addToTable) break;
                this._v.otherString.add(new CharArrayString(this._piData));
                break;
            }
            case 2: {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.processingIIWithEncodingAlgorithm"));
            }
            case 1: {
                this._piData = this._v.otherString.get(this._integer).toString();
                break;
            }
            case 3: {
                this._piData = "";
            }
        }
    }

    protected final void processUnexpandedEntityReference(int n) throws FastInfosetException, IOException {
        this._eventType = 9;
        String string = this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherNCName);
        String string2 = (n & 2) > 0 ? this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI) : "";
        String string3 = (n & 1) > 0 ? this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI) : "";
    }

    protected final void processCIIEncodingAlgorithm(boolean bl) throws FastInfosetException, IOException {
        this._algorithmData = this._octetBuffer;
        this._algorithmDataOffset = this._octetBufferStart;
        this._algorithmDataLength = this._octetBufferLength;
        this._isAlgorithmDataCloned = false;
        if (this._algorithmId >= 32) {
            this._algorithmURI = this._v.encodingAlgorithm.get(this._algorithmId - 32);
            if (this._algorithmURI == null) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.URINotPresent", new Object[]{this._identifier}));
            }
        } else if (this._algorithmId > 9) {
            throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.identifiers10to31Reserved"));
        }
        if (bl) {
            this.convertEncodingAlgorithmDataToCharacters();
            this._characterContentChunkTable.add(this._characters, this._characters.length);
        }
    }

    protected final void processAIIEncodingAlgorithm(QualifiedName qualifiedName, boolean bl) throws FastInfosetException, IOException {
        Object object;
        EncodingAlgorithm encodingAlgorithm = null;
        String string = null;
        if (this._identifier >= 32) {
            string = this._v.encodingAlgorithm.get(this._identifier - 32);
            if (string == null) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.URINotPresent", new Object[]{this._identifier}));
            }
            if (this._registeredEncodingAlgorithms != null) {
                encodingAlgorithm = (EncodingAlgorithm)this._registeredEncodingAlgorithms.get(string);
            }
        } else {
            if (this._identifier >= 9) {
                if (this._identifier == 9) {
                    throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.CDATAAlgorithmNotSupported"));
                }
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.identifiers10to31Reserved"));
            }
            encodingAlgorithm = BuiltInEncodingAlgorithmFactory.getAlgorithm(this._identifier);
        }
        if (encodingAlgorithm != null) {
            object = encodingAlgorithm.decodeFromBytes(this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
        } else {
            byte[] byArray = new byte[this._octetBufferLength];
            System.arraycopy(this._octetBuffer, this._octetBufferStart, byArray, 0, this._octetBufferLength);
            object = byArray;
        }
        this._attributes.addAttributeWithAlgorithmData(qualifiedName, string, this._identifier, object);
        if (bl) {
            this._attributeValueTable.add(this._attributes.getValue(this._attributes.getIndex(qualifiedName.qName)));
        }
    }

    protected final void convertEncodingAlgorithmDataToCharacters() throws FastInfosetException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._algorithmId == 1) {
            this.convertBase64AlorithmDataToCharacters(stringBuffer);
        } else if (this._algorithmId < 9) {
            Object object = BuiltInEncodingAlgorithmFactory.getAlgorithm(this._algorithmId).decodeFromBytes(this._algorithmData, this._algorithmDataOffset, this._algorithmDataLength);
            BuiltInEncodingAlgorithmFactory.getAlgorithm(this._algorithmId).convertToCharacters(object, stringBuffer);
        } else {
            if (this._algorithmId == 9) {
                this._octetBufferOffset -= this._octetBufferLength;
                this.decodeUtf8StringIntoCharBuffer();
                this._characters = this._charBuffer;
                this._charactersOffset = 0;
                return;
            }
            if (this._algorithmId >= 32) {
                EncodingAlgorithm encodingAlgorithm = (EncodingAlgorithm)this._registeredEncodingAlgorithms.get(this._algorithmURI);
                if (encodingAlgorithm != null) {
                    Object object = encodingAlgorithm.decodeFromBytes(this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
                    encodingAlgorithm.convertToCharacters(object, stringBuffer);
                } else {
                    throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.algorithmDataCannotBeReported"));
                }
            }
        }
        this._characters = new char[stringBuffer.length()];
        stringBuffer.getChars(0, stringBuffer.length(), this._characters, 0);
        this._charactersOffset = 0;
        this._charBufferLength = this._characters.length;
    }

    protected void convertBase64AlorithmDataToCharacters(StringBuffer stringBuffer) throws EncodingAlgorithmException, IOException {
        int n;
        int n2 = 0;
        if (this.base64TaleLength > 0) {
            n = Math.min(3 - this.base64TaleLength, this._algorithmDataLength);
            System.arraycopy(this._algorithmData, this._algorithmDataOffset, this.base64TaleBytes, this.base64TaleLength, n);
            if (this.base64TaleLength + n != 3) {
                if (!this.isBase64Follows()) {
                    this.base64DecodeWithCloning(stringBuffer, this.base64TaleBytes, 0, this.base64TaleLength + n);
                    return;
                }
                this.base64TaleLength += n;
                return;
            }
            this.base64DecodeWithCloning(stringBuffer, this.base64TaleBytes, 0, 3);
            n2 = n;
            this.base64TaleLength = 0;
        }
        int n3 = n = this.isBase64Follows() ? (this._algorithmDataLength - n2) % 3 : 0;
        if (this._isAlgorithmDataCloned) {
            this.base64DecodeWithoutCloning(stringBuffer, this._algorithmData, this._algorithmDataOffset + n2, this._algorithmDataLength - n2 - n);
        } else {
            this.base64DecodeWithCloning(stringBuffer, this._algorithmData, this._algorithmDataOffset + n2, this._algorithmDataLength - n2 - n);
        }
        if (n > 0) {
            System.arraycopy(this._algorithmData, this._algorithmDataOffset + this._algorithmDataLength - n, this.base64TaleBytes, 0, n);
            this.base64TaleLength = n;
        }
    }

    private void base64DecodeWithCloning(StringBuffer stringBuffer, byte[] byArray, int n, int n2) throws EncodingAlgorithmException {
        Object object = BuiltInEncodingAlgorithmFactory.base64EncodingAlgorithm.decodeFromBytes(byArray, n, n2);
        BuiltInEncodingAlgorithmFactory.base64EncodingAlgorithm.convertToCharacters(object, stringBuffer);
    }

    private void base64DecodeWithoutCloning(StringBuffer stringBuffer, byte[] byArray, int n, int n2) throws EncodingAlgorithmException {
        BuiltInEncodingAlgorithmFactory.base64EncodingAlgorithm.convertToCharacters(byArray, n, n2, stringBuffer);
    }

    public boolean isBase64Follows() throws IOException {
        int n = this.peek(this);
        switch (DecoderStateTables.EII(n)) {
            case 13: {
                int n2 = (n & 2) << 6;
                int n3 = this.peek2(this);
                return (n2 |= (n3 & 0xFC) >> 2) == 1;
            }
        }
        return false;
    }

    public final String getNamespaceDecl(String string) {
        return this._prefixTable.getNamespaceFromPrefix(string);
    }

    public final String getURI(String string) {
        return this.getNamespaceDecl(string);
    }

    public final Iterator getPrefixes() {
        return this._prefixTable.getPrefixes();
    }

    public final AttributesHolder getAttributesHolder() {
        return this._attributes;
    }

    public final void setManager(StAXManager stAXManager) {
        this._manager = stAXManager;
    }

    static final String getEventTypeString(int n) {
        switch (n) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
        }
        return "UNKNOWN_EVENT_TYPE";
    }

    protected class NamespaceContextImpl
    implements NamespaceContext {
        protected NamespaceContextImpl() {
        }

        @Override
        public final String getNamespaceURI(String string) {
            return StAXDocumentParser.this._prefixTable.getNamespaceFromPrefix(string);
        }

        @Override
        public final String getPrefix(String string) {
            return StAXDocumentParser.this._prefixTable.getPrefixFromNamespace(string);
        }

        public final Iterator getPrefixes(String string) {
            return StAXDocumentParser.this._prefixTable.getPrefixesFromNamespace(string);
        }
    }
}

