/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.stax.events;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.stax.events.Util;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class StAXEventWriter
implements XMLEventWriter {
    private XMLStreamWriter _streamWriter;

    public StAXEventWriter(XMLStreamWriter xMLStreamWriter) {
        this._streamWriter = xMLStreamWriter;
    }

    @Override
    public void flush() throws XMLStreamException {
        this._streamWriter.flush();
    }

    @Override
    public void close() throws XMLStreamException {
        this._streamWriter.close();
    }

    @Override
    public void add(XMLEventReader xMLEventReader) throws XMLStreamException {
        if (xMLEventReader == null) {
            throw new XMLStreamException(CommonResourceBundle.getInstance().getString("message.nullEventReader"));
        }
        while (xMLEventReader.hasNext()) {
            this.add(xMLEventReader.nextEvent());
        }
    }

    @Override
    public void add(XMLEvent xMLEvent) throws XMLStreamException {
        int n = xMLEvent.getEventType();
        switch (n) {
            case 11: {
                DTD dTD = (DTD)xMLEvent;
                this._streamWriter.writeDTD(dTD.getDocumentTypeDeclaration());
                break;
            }
            case 7: {
                StartDocument startDocument = (StartDocument)xMLEvent;
                this._streamWriter.writeStartDocument(startDocument.getCharacterEncodingScheme(), startDocument.getVersion());
                break;
            }
            case 1: {
                Object object;
                StartElement startElement = xMLEvent.asStartElement();
                QName qName = startElement.getName();
                this._streamWriter.writeStartElement(qName.getPrefix(), qName.getLocalPart(), qName.getNamespaceURI());
                Iterator<Namespace> iterator = startElement.getNamespaces();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this._streamWriter.writeNamespace(object.getPrefix(), object.getNamespaceURI());
                }
                object = startElement.getAttributes();
                while (object.hasNext()) {
                    Attribute attribute = (Attribute)object.next();
                    QName qName2 = attribute.getName();
                    this._streamWriter.writeAttribute(qName2.getPrefix(), qName2.getNamespaceURI(), qName2.getLocalPart(), attribute.getValue());
                }
                break;
            }
            case 13: {
                Namespace namespace = (Namespace)xMLEvent;
                this._streamWriter.writeNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
                break;
            }
            case 5: {
                Comment comment = (Comment)xMLEvent;
                this._streamWriter.writeComment(comment.getText());
                break;
            }
            case 3: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)xMLEvent;
                this._streamWriter.writeProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                break;
            }
            case 4: {
                Characters characters = xMLEvent.asCharacters();
                if (characters.isCData()) {
                    this._streamWriter.writeCData(characters.getData());
                    break;
                }
                this._streamWriter.writeCharacters(characters.getData());
                break;
            }
            case 9: {
                EntityReference entityReference = (EntityReference)xMLEvent;
                this._streamWriter.writeEntityRef(entityReference.getName());
                break;
            }
            case 10: {
                Attribute attribute = (Attribute)xMLEvent;
                QName qName = attribute.getName();
                this._streamWriter.writeAttribute(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart(), attribute.getValue());
                break;
            }
            case 12: {
                Characters characters = (Characters)xMLEvent;
                if (!characters.isCData()) break;
                this._streamWriter.writeCData(characters.getData());
                break;
            }
            case 2: {
                this._streamWriter.writeEndElement();
                break;
            }
            case 8: {
                this._streamWriter.writeEndDocument();
                break;
            }
            default: {
                throw new XMLStreamException(CommonResourceBundle.getInstance().getString("message.eventTypeNotSupported", new Object[]{Util.getEventTypeString(n)}));
            }
        }
    }

    @Override
    public String getPrefix(String string) throws XMLStreamException {
        return this._streamWriter.getPrefix(string);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this._streamWriter.getNamespaceContext();
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        this._streamWriter.setDefaultNamespace(string);
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this._streamWriter.setNamespaceContext(namespaceContext);
    }

    @Override
    public void setPrefix(String string, String string2) throws XMLStreamException {
        this._streamWriter.setPrefix(string, string2);
    }
}

