/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream;

import com.sun.xml.internal.stream.events.XMLEventAllocatorImpl;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;

public class XMLEventReaderImpl
implements XMLEventReader {
    protected XMLStreamReader fXMLReader;
    protected XMLEventAllocator fXMLEventAllocator;
    private XMLEvent fPeekedEvent;
    private XMLEvent fLastEvent;

    public XMLEventReaderImpl(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        this.fXMLReader = xMLStreamReader;
        this.fXMLEventAllocator = (XMLEventAllocator)xMLStreamReader.getProperty("javax.xml.stream.allocator");
        if (this.fXMLEventAllocator == null) {
            this.fXMLEventAllocator = new XMLEventAllocatorImpl();
        }
        this.fPeekedEvent = this.fXMLEventAllocator.allocate(this.fXMLReader);
    }

    @Override
    public boolean hasNext() {
        if (this.fPeekedEvent != null) {
            return true;
        }
        boolean bl = false;
        try {
            bl = this.fXMLReader.hasNext();
        }
        catch (XMLStreamException xMLStreamException) {
            return false;
        }
        return bl;
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        if (this.fPeekedEvent != null) {
            this.fLastEvent = this.fPeekedEvent;
            this.fPeekedEvent = null;
            return this.fLastEvent;
        }
        if (this.fXMLReader.hasNext()) {
            this.fXMLReader.next();
            this.fLastEvent = this.fXMLEventAllocator.allocate(this.fXMLReader);
            return this.fLastEvent;
        }
        this.fLastEvent = null;
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws XMLStreamException {
        this.fXMLReader.close();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.fLastEvent.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.fLastEvent.getLocation());
        }
        String string = null;
        if (this.fPeekedEvent != null) {
            XMLEvent xMLEvent = this.fPeekedEvent;
            this.fPeekedEvent = null;
            int n = xMLEvent.getEventType();
            if (n == 4 || n == 6 || n == 12) {
                string = xMLEvent.asCharacters().getData();
            } else if (n == 9) {
                string = ((EntityReference)xMLEvent).getDeclaration().getReplacementText();
            } else if (n != 5 && n != 3) {
                if (n == 1) {
                    throw new XMLStreamException("elementGetText() function expects text only elment but START_ELEMENT was encountered.", xMLEvent.getLocation());
                }
                if (n == 2) {
                    return "";
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null && string.length() > 0) {
                stringBuffer.append(string);
            }
            xMLEvent = this.nextEvent();
            while (xMLEvent.getEventType() != 2) {
                if (n == 4 || n == 6 || n == 12) {
                    string = xMLEvent.asCharacters().getData();
                } else if (n == 9) {
                    string = ((EntityReference)xMLEvent).getDeclaration().getReplacementText();
                } else if (n != 5 && n != 3) {
                    if (n == 8) {
                        throw new XMLStreamException("unexpected end of document when reading element text content");
                    }
                    if (n == 1) {
                        throw new XMLStreamException("elementGetText() function expects text only elment but START_ELEMENT was encountered.", xMLEvent.getLocation());
                    }
                    throw new XMLStreamException("Unexpected event type " + n, xMLEvent.getLocation());
                }
                if (string != null && string.length() > 0) {
                    stringBuffer.append(string);
                }
                xMLEvent = this.nextEvent();
            }
            return stringBuffer.toString();
        }
        string = this.fXMLReader.getElementText();
        this.fLastEvent = this.fXMLEventAllocator.allocate(this.fXMLReader);
        return string;
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        return this.fXMLReader.getProperty(string);
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        if (this.fPeekedEvent != null) {
            XMLEvent xMLEvent = this.fPeekedEvent;
            this.fPeekedEvent = null;
            int n = xMLEvent.getEventType();
            if (xMLEvent.isCharacters() && xMLEvent.asCharacters().isWhiteSpace() || n == 3 || n == 5 || n == 7) {
                xMLEvent = this.nextEvent();
                n = xMLEvent.getEventType();
            }
            while (xMLEvent.isCharacters() && xMLEvent.asCharacters().isWhiteSpace() || n == 3 || n == 5) {
                xMLEvent = this.nextEvent();
                n = xMLEvent.getEventType();
            }
            if (n != 1 && n != 2) {
                throw new XMLStreamException("expected start or end tag", xMLEvent.getLocation());
            }
            return xMLEvent;
        }
        this.fXMLReader.nextTag();
        this.fLastEvent = this.fXMLEventAllocator.allocate(this.fXMLReader);
        return this.fLastEvent;
    }

    @Override
    public Object next() {
        XMLEvent xMLEvent = null;
        try {
            xMLEvent = this.nextEvent();
        }
        catch (XMLStreamException xMLStreamException) {
            this.fLastEvent = null;
            NoSuchElementException noSuchElementException = new NoSuchElementException(xMLStreamException.getMessage());
            noSuchElementException.initCause(xMLStreamException.getCause());
            throw noSuchElementException;
        }
        return xMLEvent;
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        if (this.fPeekedEvent != null) {
            return this.fPeekedEvent;
        }
        if (this.hasNext()) {
            this.fXMLReader.next();
            this.fPeekedEvent = this.fXMLEventAllocator.allocate(this.fXMLReader);
            return this.fPeekedEvent;
        }
        return null;
    }
}

