/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.writers;

import com.sun.org.apache.xerces.internal.impl.PropertyManager;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.utils.SecuritySupport;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.xml.internal.stream.util.ReadOnlyIterator;
import com.sun.xml.internal.stream.writers.UTF8OutputStreamWriter;
import com.sun.xml.internal.stream.writers.XMLWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamResult;

public final class XMLStreamWriterImpl
extends AbstractMap
implements XMLStreamWriter {
    public static final String START_COMMENT = "<!--";
    public static final String END_COMMENT = "-->";
    public static final String DEFAULT_ENCODING = " encoding=\"utf-8\"";
    public static final String DEFAULT_XMLDECL = "<?xml version=\"1.0\" ?>";
    public static final String DEFAULT_XML_VERSION = "1.0";
    public static final char CLOSE_START_TAG = '>';
    public static final char OPEN_START_TAG = '<';
    public static final String OPEN_END_TAG = "</";
    public static final char CLOSE_END_TAG = '>';
    public static final String START_CDATA = "<![CDATA[";
    public static final String END_CDATA = "]]>";
    public static final String CLOSE_EMPTY_ELEMENT = "/>";
    public static final String SPACE = " ";
    public static final String UTF_8 = "UTF-8";
    public static final String OUTPUTSTREAM_PROPERTY = "sjsxp-outputstream";
    boolean fEscapeCharacters = true;
    private boolean fIsRepairingNamespace = false;
    private Writer fWriter;
    private OutputStream fOutputStream = null;
    private ArrayList fAttributeCache;
    private ArrayList fNamespaceDecls;
    private NamespaceContextImpl fNamespaceContext = null;
    private NamespaceSupport fInternalNamespaceContext = null;
    private Random fPrefixGen = null;
    private PropertyManager fPropertyManager = null;
    private boolean fStartTagOpened = false;
    private boolean fReuse;
    private SymbolTable fSymbolTable = new SymbolTable();
    private ElementStack fElementStack = new ElementStack();
    private final String DEFAULT_PREFIX = this.fSymbolTable.addSymbol("");
    private final ReadOnlyIterator fReadOnlyIterator = new ReadOnlyIterator();
    private CharsetEncoder fEncoder = null;
    HashMap fAttrNamespace = null;

    public XMLStreamWriterImpl(OutputStream outputStream, PropertyManager propertyManager) throws IOException {
        this(new OutputStreamWriter(outputStream), propertyManager);
    }

    public XMLStreamWriterImpl(OutputStream outputStream, String string, PropertyManager propertyManager) throws IOException {
        this(new StreamResult(outputStream), string, propertyManager);
    }

    public XMLStreamWriterImpl(Writer writer, PropertyManager propertyManager) throws IOException {
        this(new StreamResult(writer), null, propertyManager);
    }

    public XMLStreamWriterImpl(StreamResult streamResult, String string, PropertyManager propertyManager) throws IOException {
        this.setOutput(streamResult, string);
        this.fPropertyManager = propertyManager;
        this.init();
    }

    private void init() {
        this.fReuse = false;
        this.fNamespaceDecls = new ArrayList();
        this.fPrefixGen = new Random();
        this.fAttributeCache = new ArrayList();
        this.fInternalNamespaceContext = new NamespaceSupport();
        this.fInternalNamespaceContext.reset();
        this.fNamespaceContext = new NamespaceContextImpl();
        this.fNamespaceContext.internalContext = this.fInternalNamespaceContext;
        Boolean bl = (Boolean)this.fPropertyManager.getProperty("javax.xml.stream.isRepairingNamespaces");
        this.fIsRepairingNamespace = bl;
        bl = (Boolean)this.fPropertyManager.getProperty("escapeCharacters");
        this.setEscapeCharacters(bl);
    }

    public void reset() {
        this.reset(false);
    }

    void reset(boolean bl) {
        if (!this.fReuse) {
            throw new IllegalStateException("close() Must be called before calling reset()");
        }
        this.fReuse = false;
        this.fNamespaceDecls.clear();
        this.fAttributeCache.clear();
        this.fElementStack.clear();
        this.fInternalNamespaceContext.reset();
        this.fStartTagOpened = false;
        this.fNamespaceContext.userContext = null;
        if (bl) {
            Boolean bl2 = (Boolean)this.fPropertyManager.getProperty("javax.xml.stream.isRepairingNamespaces");
            this.fIsRepairingNamespace = bl2;
            bl2 = (Boolean)this.fPropertyManager.getProperty("escapeCharacters");
            this.setEscapeCharacters(bl2);
        }
    }

    public void setOutput(StreamResult streamResult, String string) throws IOException {
        if (streamResult.getOutputStream() != null) {
            this.setOutputUsingStream(streamResult.getOutputStream(), string);
        } else if (streamResult.getWriter() != null) {
            this.setOutputUsingWriter(streamResult.getWriter());
        } else if (streamResult.getSystemId() != null) {
            this.setOutputUsingStream(new FileOutputStream(streamResult.getSystemId()), string);
        }
    }

    private void setOutputUsingWriter(Writer writer) throws IOException {
        String string;
        this.fWriter = writer;
        if (writer instanceof OutputStreamWriter && (string = ((OutputStreamWriter)writer).getEncoding()) != null && !string.equalsIgnoreCase("utf-8")) {
            this.fEncoder = Charset.forName(string).newEncoder();
        }
    }

    private void setOutputUsingStream(OutputStream outputStream, String string) throws IOException {
        this.fOutputStream = outputStream;
        if (string != null) {
            if (string.equalsIgnoreCase("utf-8")) {
                this.fWriter = new UTF8OutputStreamWriter(outputStream);
            } else {
                this.fWriter = new XMLWriter(new OutputStreamWriter(outputStream, string));
                this.fEncoder = Charset.forName(string).newEncoder();
            }
        } else {
            string = SecuritySupport.getSystemProperty((String)"file.encoding");
            this.fWriter = string != null && string.equalsIgnoreCase("utf-8") ? new UTF8OutputStreamWriter(outputStream) : new XMLWriter(new OutputStreamWriter(outputStream));
        }
    }

    public boolean canReuse() {
        return this.fReuse;
    }

    public void setEscapeCharacters(boolean bl) {
        this.fEscapeCharacters = bl;
    }

    public boolean getEscapeCharacters() {
        return this.fEscapeCharacters;
    }

    @Override
    public void close() throws XMLStreamException {
        if (this.fWriter != null) {
            try {
                this.fWriter.flush();
            }
            catch (IOException iOException) {
                throw new XMLStreamException(iOException);
            }
        }
        this.fWriter = null;
        this.fOutputStream = null;
        this.fNamespaceDecls.clear();
        this.fAttributeCache.clear();
        this.fElementStack.clear();
        this.fInternalNamespaceContext.reset();
        this.fReuse = true;
        this.fStartTagOpened = false;
        this.fNamespaceContext.userContext = null;
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            this.fWriter.flush();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    @Override
    public String getPrefix(String string) throws XMLStreamException {
        return this.fNamespaceContext.getPrefix(string);
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (!this.fPropertyManager.containsProperty(string)) {
            throw new IllegalArgumentException("Property '" + string + "' is not supported");
        }
        return this.fPropertyManager.getProperty(string);
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        if (string != null) {
            string = this.fSymbolTable.addSymbol(string);
        }
        if (this.fIsRepairingNamespace) {
            if (this.isDefaultNamespace(string)) {
                return;
            }
            QName qName = new QName();
            qName.setValues(this.DEFAULT_PREFIX, "xmlns", null, string);
            this.fNamespaceDecls.add(qName);
        } else {
            this.fInternalNamespaceContext.declarePrefix(this.DEFAULT_PREFIX, string);
        }
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.fNamespaceContext.userContext = namespaceContext;
    }

    @Override
    public void setPrefix(String string, String string2) throws XMLStreamException {
        if (string == null) {
            throw new XMLStreamException("Prefix cannot be null");
        }
        if (string2 == null) {
            throw new XMLStreamException("URI cannot be null");
        }
        string = this.fSymbolTable.addSymbol(string);
        string2 = this.fSymbolTable.addSymbol(string2);
        if (this.fIsRepairingNamespace) {
            String string3 = this.fInternalNamespaceContext.getURI(string);
            if (string3 != null && string3 == string2) {
                return;
            }
            if (this.checkUserNamespaceContext(string, string2)) {
                return;
            }
            QName qName = new QName();
            qName.setValues(string, "xmlns", null, string2);
            this.fNamespaceDecls.add(qName);
            return;
        }
        this.fInternalNamespaceContext.declarePrefix(string, string2);
    }

    @Override
    public void writeAttribute(String string, String string2) throws XMLStreamException {
        try {
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Attribute not associated with any element");
            }
            if (this.fIsRepairingNamespace) {
                Attribute attribute = new Attribute(string2);
                attribute.setValues(null, string, null, null);
                this.fAttributeCache.add(attribute);
                return;
            }
            this.fWriter.write(SPACE);
            this.fWriter.write(string);
            this.fWriter.write("=\"");
            this.writeXMLContent(string2, true, true);
            this.fWriter.write("\"");
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        try {
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Attribute not associated with any element");
            }
            if (string == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            string = this.fSymbolTable.addSymbol(string);
            String string4 = this.fInternalNamespaceContext.getPrefix(string);
            if (!this.fIsRepairingNamespace) {
                if (string4 == null) {
                    throw new XMLStreamException("Prefix cannot be null");
                }
                this.writeAttributeWithPrefix(string4, string2, string3);
            } else {
                Attribute attribute = new Attribute(string3);
                attribute.setValues(null, string2, null, string);
                this.fAttributeCache.add(attribute);
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    private void writeAttributeWithPrefix(String string, String string2, String string3) throws IOException {
        this.fWriter.write(SPACE);
        if (string != null && string != "") {
            this.fWriter.write(string);
            this.fWriter.write(":");
        }
        this.fWriter.write(string2);
        this.fWriter.write("=\"");
        this.writeXMLContent(string3, true, true);
        this.fWriter.write("\"");
    }

    @Override
    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        try {
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Attribute not associated with any element");
            }
            if (string2 == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (string3 == null) {
                throw new XMLStreamException("Local name cannot be null");
            }
            if (!this.fIsRepairingNamespace) {
                if (string == null || string.equals("")) {
                    if (!string2.equals("")) {
                        throw new XMLStreamException("prefix cannot be null or empty");
                    }
                    this.writeAttributeWithPrefix(null, string3, string4);
                    return;
                }
                if (!string.equals("xml") || !string2.equals("http://www.w3.org/XML/1998/namespace")) {
                    String string5;
                    string = this.fSymbolTable.addSymbol(string);
                    string2 = this.fSymbolTable.addSymbol(string2);
                    if (this.fInternalNamespaceContext.containsPrefixInCurrentContext(string) && (string5 = this.fInternalNamespaceContext.getURI(string)) != null && string5 != string2) {
                        throw new XMLStreamException("Prefix " + string + " is " + "already bound to " + string5 + ". Trying to rebind it to " + string2 + " is an error.");
                    }
                    this.fInternalNamespaceContext.declarePrefix(string, string2);
                }
                this.writeAttributeWithPrefix(string, string3, string4);
            } else {
                if (string != null) {
                    string = this.fSymbolTable.addSymbol(string);
                }
                string2 = this.fSymbolTable.addSymbol(string2);
                Attribute attribute = new Attribute(string4);
                attribute.setValues(string, string3, null, string2);
                this.fAttributeCache.add(attribute);
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeCData(String string) throws XMLStreamException {
        try {
            if (string == null) {
                throw new XMLStreamException("cdata cannot be null");
            }
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fWriter.write(START_CDATA);
            this.fWriter.write(string);
            this.fWriter.write(END_CDATA);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeCharacters(String string) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.writeXMLContent(string);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.writeXMLContent(cArray, n, n2, this.fEscapeCharacters);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeComment(String string) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fWriter.write(START_COMMENT);
            if (string != null) {
                this.fWriter.write(string);
            }
            this.fWriter.write(END_COMMENT);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeDTD(String string) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fWriter.write(string);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeDefaultNamespace(String string) throws XMLStreamException {
        String string2 = null;
        string2 = string == null ? "" : string;
        try {
            String string3;
            if (!this.fStartTagOpened) {
                throw new IllegalStateException("Namespace Attribute not associated with any element");
            }
            if (this.fIsRepairingNamespace) {
                QName qName = new QName();
                qName.setValues("", "xmlns", null, string2);
                this.fNamespaceDecls.add(qName);
                return;
            }
            string2 = this.fSymbolTable.addSymbol(string2);
            if (this.fInternalNamespaceContext.containsPrefixInCurrentContext("") && (string3 = this.fInternalNamespaceContext.getURI("")) != null && string3 != string2) {
                throw new XMLStreamException("xmlns has been already bound to " + string3 + ". Rebinding it to " + string2 + " is an error");
            }
            this.fInternalNamespaceContext.declarePrefix("", string2);
            this.writenamespace(null, string2);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeEmptyElement(String string) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            this.fElementStack.push(null, string, null, null, true);
            this.fInternalNamespaceContext.pushContext();
            if (!this.fIsRepairingNamespace) {
                this.fWriter.write(string);
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        if (string == null) {
            throw new XMLStreamException("NamespaceURI cannot be null");
        }
        string = this.fSymbolTable.addSymbol(string);
        String string3 = this.fNamespaceContext.getPrefix(string);
        this.writeEmptyElement(string3, string2, string);
    }

    @Override
    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        try {
            if (string2 == null) {
                throw new XMLStreamException("Local Name cannot be null");
            }
            if (string3 == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (string != null) {
                string = this.fSymbolTable.addSymbol(string);
            }
            string3 = this.fSymbolTable.addSymbol(string3);
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            this.fElementStack.push(string, string2, null, string3, true);
            this.fInternalNamespaceContext.pushContext();
            if (!this.fIsRepairingNamespace) {
                if (string == null) {
                    throw new XMLStreamException("NamespaceURI " + string3 + " has not been bound to any prefix");
                }
            } else {
                return;
            }
            if (string != null && string != "") {
                this.fWriter.write(string);
                this.fWriter.write(":");
            }
            this.fWriter.write(string2);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            ElementState elementState = null;
            while (!this.fElementStack.empty()) {
                elementState = this.fElementStack.pop();
                this.fInternalNamespaceContext.popContext();
                if (elementState.isEmpty) continue;
                this.fWriter.write(OPEN_END_TAG);
                if (elementState.prefix != null && !elementState.prefix.equals("")) {
                    this.fWriter.write(elementState.prefix);
                    this.fWriter.write(":");
                }
                this.fWriter.write(elementState.localpart);
                this.fWriter.write(62);
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new XMLStreamException("No more elements to write");
        }
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        try {
            ElementState elementState;
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            if ((elementState = this.fElementStack.pop()) == null) {
                throw new XMLStreamException("No element was found to write");
            }
            if (elementState.isEmpty) {
                return;
            }
            this.fWriter.write(OPEN_END_TAG);
            if (elementState.prefix != null && !elementState.prefix.equals("")) {
                this.fWriter.write(elementState.prefix);
                this.fWriter.write(":");
            }
            this.fWriter.write(elementState.localpart);
            this.fWriter.write(62);
            this.fInternalNamespaceContext.popContext();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new XMLStreamException("No element was found to write: " + arrayIndexOutOfBoundsException.toString(), arrayIndexOutOfBoundsException);
        }
    }

    @Override
    public void writeEntityRef(String string) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fWriter.write(38);
            this.fWriter.write(string);
            this.fWriter.write(59);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeNamespace(String string, String string2) throws XMLStreamException {
        String string3 = null;
        string3 = string2 == null ? "" : string2;
        try {
            String string4;
            QName qName = null;
            if (!this.fStartTagOpened) {
                throw new IllegalStateException("Invalid state: start tag is not opened at writeNamespace(" + string + ", " + string3 + ")");
            }
            if (string == null || string.equals("") || string.equals("xmlns")) {
                this.writeDefaultNamespace(string3);
                return;
            }
            if (string.equals("xml") && string3.equals("http://www.w3.org/XML/1998/namespace")) {
                return;
            }
            string = this.fSymbolTable.addSymbol(string);
            string3 = this.fSymbolTable.addSymbol(string3);
            if (this.fIsRepairingNamespace) {
                String string5 = this.fInternalNamespaceContext.getURI(string);
                if (string5 != null && string5 == string3) {
                    return;
                }
                qName = new QName();
                qName.setValues(string, "xmlns", null, string3);
                this.fNamespaceDecls.add(qName);
                return;
            }
            if (this.fInternalNamespaceContext.containsPrefixInCurrentContext(string) && (string4 = this.fInternalNamespaceContext.getURI(string)) != null && string4 != string3) {
                throw new XMLStreamException("prefix " + string + " has been already bound to " + string4 + ". Rebinding it to " + string3 + " is an error");
            }
            this.fInternalNamespaceContext.declarePrefix(string, string3);
            this.writenamespace(string, string3);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    private void writenamespace(String string, String string2) throws IOException {
        this.fWriter.write(" xmlns");
        if (string != null && string != "") {
            this.fWriter.write(":");
            this.fWriter.write(string);
        }
        this.fWriter.write("=\"");
        this.writeXMLContent(string2, true, true);
        this.fWriter.write("\"");
    }

    @Override
    public void writeProcessingInstruction(String string) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            if (string != null) {
                this.fWriter.write("<?");
                this.fWriter.write(string);
                this.fWriter.write("?>");
                return;
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        throw new XMLStreamException("PI target cannot be null");
    }

    @Override
    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            if (string == null || string2 == null) {
                throw new XMLStreamException("PI target cannot be null");
            }
            this.fWriter.write("<?");
            this.fWriter.write(string);
            this.fWriter.write(SPACE);
            this.fWriter.write(string2);
            this.fWriter.write("?>");
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        try {
            this.fWriter.write(DEFAULT_XMLDECL);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeStartDocument(String string) throws XMLStreamException {
        try {
            if (string == null || string.equals("")) {
                this.writeStartDocument();
                return;
            }
            this.fWriter.write("<?xml version=\"");
            this.fWriter.write(string);
            this.fWriter.write("\"");
            this.fWriter.write("?>");
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        try {
            if (string == null && string2 == null) {
                this.writeStartDocument();
                return;
            }
            if (string == null) {
                this.writeStartDocument(string2);
                return;
            }
            String string3 = null;
            if (this.fWriter instanceof OutputStreamWriter) {
                string3 = ((OutputStreamWriter)this.fWriter).getEncoding();
            } else if (this.fWriter instanceof UTF8OutputStreamWriter) {
                string3 = ((UTF8OutputStreamWriter)this.fWriter).getEncoding();
            } else if (this.fWriter instanceof XMLWriter) {
                string3 = ((OutputStreamWriter)((XMLWriter)this.fWriter).getWriter()).getEncoding();
            }
            if (string3 != null && !string3.equalsIgnoreCase(string)) {
                boolean bl = false;
                Set<String> set = Charset.forName(string).aliases();
                Iterator<String> iterator = set.iterator();
                while (!bl && iterator.hasNext()) {
                    if (!string3.equalsIgnoreCase(iterator.next())) continue;
                    bl = true;
                }
                if (!bl) {
                    throw new XMLStreamException("Underlying stream encoding '" + string3 + "' and input paramter for writeStartDocument() method '" + string + "' do not match.");
                }
            }
            this.fWriter.write("<?xml version=\"");
            if (string2 == null || string2.equals("")) {
                this.fWriter.write(DEFAULT_XML_VERSION);
            } else {
                this.fWriter.write(string2);
            }
            if (!string.equals("")) {
                this.fWriter.write("\" encoding=\"");
                this.fWriter.write(string);
            }
            this.fWriter.write("\"?>");
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeStartElement(String string) throws XMLStreamException {
        try {
            if (string == null) {
                throw new XMLStreamException("Local Name cannot be null");
            }
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            this.fElementStack.push(null, string, null, null, false);
            this.fInternalNamespaceContext.pushContext();
            if (this.fIsRepairingNamespace) {
                return;
            }
            this.fWriter.write(string);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void writeStartElement(String string, String string2) throws XMLStreamException {
        if (string2 == null) {
            throw new XMLStreamException("Local Name cannot be null");
        }
        if (string == null) {
            throw new XMLStreamException("NamespaceURI cannot be null");
        }
        string = this.fSymbolTable.addSymbol(string);
        String string3 = null;
        if (!this.fIsRepairingNamespace && (string3 = this.fNamespaceContext.getPrefix(string)) != null) {
            string3 = this.fSymbolTable.addSymbol(string3);
        }
        this.writeStartElement(string3, string2, string);
    }

    @Override
    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        try {
            if (string2 == null) {
                throw new XMLStreamException("Local Name cannot be null");
            }
            if (string3 == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (!this.fIsRepairingNamespace && string == null) {
                throw new XMLStreamException("Prefix cannot be null");
            }
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            string3 = this.fSymbolTable.addSymbol(string3);
            if (string != null) {
                string = this.fSymbolTable.addSymbol(string);
            }
            this.fElementStack.push(string, string2, null, string3, false);
            this.fInternalNamespaceContext.pushContext();
            String string4 = this.fNamespaceContext.getPrefix(string3);
            if (!(string == null || string4 != null && string.equals(string4))) {
                this.fInternalNamespaceContext.declarePrefix(string, string3);
            }
            if (this.fIsRepairingNamespace) {
                if (string == null || string4 != null && string.equals(string4)) {
                    return;
                }
                QName qName = new QName();
                qName.setValues(string, "xmlns", null, string3);
                this.fNamespaceDecls.add(qName);
                return;
            }
            if (string != null && string != "") {
                this.fWriter.write(string);
                this.fWriter.write(":");
            }
            this.fWriter.write(string2);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    private void writeXMLContent(char[] cArray, int n, int n2, boolean bl) throws IOException {
        if (!bl) {
            this.fWriter.write(cArray, n, n2);
            return;
        }
        int n3 = n;
        int n4 = n + n2;
        block5: for (int i = n; i < n4; ++i) {
            char c = cArray[i];
            if (this.fEncoder != null && !this.fEncoder.canEncode(c)) {
                this.fWriter.write(cArray, n3, i - n3);
                this.fWriter.write("&#x");
                this.fWriter.write(Integer.toHexString(c));
                this.fWriter.write(59);
                n3 = i + 1;
                continue;
            }
            switch (c) {
                case '<': {
                    this.fWriter.write(cArray, n3, i - n3);
                    this.fWriter.write("&lt;");
                    n3 = i + 1;
                    continue block5;
                }
                case '&': {
                    this.fWriter.write(cArray, n3, i - n3);
                    this.fWriter.write("&amp;");
                    n3 = i + 1;
                    continue block5;
                }
                case '>': {
                    this.fWriter.write(cArray, n3, i - n3);
                    this.fWriter.write("&gt;");
                    n3 = i + 1;
                }
            }
        }
        this.fWriter.write(cArray, n3, n4 - n3);
    }

    private void writeXMLContent(String string) throws IOException {
        if (string != null && string.length() > 0) {
            this.writeXMLContent(string, this.fEscapeCharacters, false);
        }
    }

    private void writeXMLContent(String string, boolean bl, boolean bl2) throws IOException {
        if (!bl) {
            this.fWriter.write(string);
            return;
        }
        int n = 0;
        int n2 = string.length();
        block6: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (this.fEncoder != null && !this.fEncoder.canEncode(c)) {
                this.fWriter.write(string, n, i - n);
                this.fWriter.write("&#x");
                this.fWriter.write(Integer.toHexString(c));
                this.fWriter.write(59);
                n = i + 1;
                continue;
            }
            switch (c) {
                case '<': {
                    this.fWriter.write(string, n, i - n);
                    this.fWriter.write("&lt;");
                    n = i + 1;
                    continue block6;
                }
                case '&': {
                    this.fWriter.write(string, n, i - n);
                    this.fWriter.write("&amp;");
                    n = i + 1;
                    continue block6;
                }
                case '>': {
                    this.fWriter.write(string, n, i - n);
                    this.fWriter.write("&gt;");
                    n = i + 1;
                    continue block6;
                }
                case '\"': {
                    this.fWriter.write(string, n, i - n);
                    if (bl2) {
                        this.fWriter.write("&quot;");
                    } else {
                        this.fWriter.write(34);
                    }
                    n = i + 1;
                }
            }
        }
        this.fWriter.write(string, n, n2 - n);
    }

    private void closeStartTag() throws XMLStreamException {
        try {
            ElementState elementState = this.fElementStack.peek();
            if (this.fIsRepairingNamespace) {
                this.repair();
                this.correctPrefix((QName)elementState, 1);
                if (elementState.prefix != null && elementState.prefix != "") {
                    this.fWriter.write(elementState.prefix);
                    this.fWriter.write(":");
                }
                this.fWriter.write(elementState.localpart);
                int n = this.fNamespaceDecls.size();
                QName qName = null;
                for (int i = 0; i < n; ++i) {
                    qName = (QName)this.fNamespaceDecls.get(i);
                    if (qName == null || !this.fInternalNamespaceContext.declarePrefix(qName.prefix, qName.uri)) continue;
                    this.writenamespace(qName.prefix, qName.uri);
                }
                this.fNamespaceDecls.clear();
                Attribute attribute = null;
                for (int i = 0; i < this.fAttributeCache.size(); ++i) {
                    String string;
                    attribute = (Attribute)this.fAttributeCache.get(i);
                    if (!(attribute.prefix == null || attribute.uri == null || attribute.prefix.equals("") || attribute.uri.equals("") || (string = this.fInternalNamespaceContext.getPrefix(attribute.uri)) != null && string == attribute.prefix)) {
                        string = this.getAttrPrefix(attribute.uri);
                        if (string == null) {
                            if (this.fInternalNamespaceContext.declarePrefix(attribute.prefix, attribute.uri)) {
                                this.writenamespace(attribute.prefix, attribute.uri);
                            }
                        } else {
                            this.writenamespace(attribute.prefix, attribute.uri);
                        }
                    }
                    this.writeAttributeWithPrefix(attribute.prefix, attribute.localpart, attribute.value);
                }
                this.fAttrNamespace = null;
                this.fAttributeCache.clear();
            }
            if (elementState.isEmpty) {
                this.fElementStack.pop();
                this.fInternalNamespaceContext.popContext();
                this.fWriter.write(CLOSE_EMPTY_ELEMENT);
            } else {
                this.fWriter.write(62);
            }
            this.fStartTagOpened = false;
        }
        catch (IOException iOException) {
            this.fStartTagOpened = false;
            throw new XMLStreamException(iOException);
        }
    }

    private void openStartTag() throws IOException {
        this.fStartTagOpened = true;
        this.fWriter.write(60);
    }

    private void correctPrefix(QName qName, int n) {
        String string = null;
        String string2 = qName.prefix;
        String string3 = qName.uri;
        boolean bl = false;
        if (string2 == null || string2.equals("")) {
            if (string3 == null) {
                return;
            }
            if (string2 == "" && string3 == "") {
                return;
            }
            string3 = this.fSymbolTable.addSymbol(string3);
            QName qName2 = null;
            for (int i = 0; i < this.fNamespaceDecls.size(); ++i) {
                qName2 = (QName)this.fNamespaceDecls.get(i);
                if (qName2 == null || qName2.uri != qName.uri) continue;
                qName.prefix = qName2.prefix;
                return;
            }
            string = this.fNamespaceContext.getPrefix(string3);
            if (string == "") {
                if (n == 1) {
                    return;
                }
                if (n == 10) {
                    string = this.getAttrPrefix(string3);
                    bl = true;
                }
            }
            if (string == null) {
                StringBuffer stringBuffer = new StringBuffer("zdef");
                for (int i = 0; i < 1; ++i) {
                    stringBuffer.append(this.fPrefixGen.nextInt());
                }
                string2 = stringBuffer.toString();
                string2 = this.fSymbolTable.addSymbol(string2);
            } else {
                string2 = this.fSymbolTable.addSymbol(string);
            }
            if (string == null) {
                if (bl) {
                    this.addAttrNamespace(string2, string3);
                } else {
                    QName qName3 = new QName();
                    qName3.setValues(string2, "xmlns", null, string3);
                    this.fNamespaceDecls.add(qName3);
                    this.fInternalNamespaceContext.declarePrefix(this.fSymbolTable.addSymbol(string2), string3);
                }
            }
        }
        qName.prefix = string2;
    }

    private String getAttrPrefix(String string) {
        if (this.fAttrNamespace != null) {
            return (String)this.fAttrNamespace.get(string);
        }
        return null;
    }

    private void addAttrNamespace(String string, String string2) {
        if (this.fAttrNamespace == null) {
            this.fAttrNamespace = new HashMap();
        }
        this.fAttrNamespace.put(string, string2);
    }

    private boolean isDefaultNamespace(String string) {
        String string2 = this.fInternalNamespaceContext.getURI(this.DEFAULT_PREFIX);
        return string == string2;
    }

    private boolean checkUserNamespaceContext(String string, String string2) {
        String string3;
        return this.fNamespaceContext.userContext != null && (string3 = this.fNamespaceContext.userContext.getNamespaceURI(string)) != null && string3.equals(string2);
    }

    protected void repair() {
        int n;
        Attribute attribute = null;
        Attribute attribute2 = null;
        ElementState elementState = this.fElementStack.peek();
        this.removeDuplicateDecls();
        for (n = 0; n < this.fAttributeCache.size(); ++n) {
            attribute = (Attribute)this.fAttributeCache.get(n);
            if ((attribute.prefix == null || attribute.prefix.equals("")) && (attribute.uri == null || attribute.uri.equals(""))) continue;
            this.correctPrefix((QName)elementState, attribute);
        }
        if (!(this.isDeclared(elementState) || elementState.prefix == null || elementState.uri == null || elementState.prefix.equals("") || elementState.uri.equals(""))) {
            this.fNamespaceDecls.add(elementState);
        }
        for (n = 0; n < this.fAttributeCache.size(); ++n) {
            attribute = (Attribute)this.fAttributeCache.get(n);
            for (int i = n + 1; i < this.fAttributeCache.size(); ++i) {
                attribute2 = (Attribute)this.fAttributeCache.get(i);
                if ("".equals(attribute.prefix) || "".equals(attribute2.prefix)) continue;
                this.correctPrefix((QName)attribute, attribute2);
            }
        }
        this.repairNamespaceDecl(elementState);
        n = 0;
        for (n = 0; n < this.fAttributeCache.size(); ++n) {
            attribute = (Attribute)this.fAttributeCache.get(n);
            if (attribute.prefix == null || !attribute.prefix.equals("") || attribute.uri == null || !attribute.uri.equals("")) continue;
            this.repairNamespaceDecl(attribute);
        }
        QName qName = null;
        for (n = 0; n < this.fNamespaceDecls.size(); ++n) {
            qName = (QName)this.fNamespaceDecls.get(n);
            if (qName == null) continue;
            this.fInternalNamespaceContext.declarePrefix(qName.prefix, qName.uri);
        }
        for (n = 0; n < this.fAttributeCache.size(); ++n) {
            attribute = (Attribute)this.fAttributeCache.get(n);
            this.correctPrefix((QName)attribute, 10);
        }
    }

    void correctPrefix(QName qName, QName qName2) {
        String string = null;
        QName qName3 = null;
        boolean bl = false;
        this.checkForNull(qName);
        this.checkForNull(qName2);
        if (qName.prefix.equals(qName2.prefix) && !qName.uri.equals(qName2.uri)) {
            string = this.fNamespaceContext.getPrefix(qName2.uri);
            if (string != null) {
                qName2.prefix = this.fSymbolTable.addSymbol(string);
            } else {
                qName3 = null;
                for (int i = 0; i < this.fNamespaceDecls.size(); ++i) {
                    qName3 = (QName)this.fNamespaceDecls.get(i);
                    if (qName3 == null || qName3.uri != qName2.uri) continue;
                    qName2.prefix = qName3.prefix;
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer("zdef");
                for (int i = 0; i < 1; ++i) {
                    stringBuffer.append(this.fPrefixGen.nextInt());
                }
                string = stringBuffer.toString();
                qName2.prefix = string = this.fSymbolTable.addSymbol(string);
                QName qName4 = new QName();
                qName4.setValues(string, "xmlns", null, qName2.uri);
                this.fNamespaceDecls.add(qName4);
            }
        }
    }

    void checkForNull(QName qName) {
        if (qName.prefix == null) {
            qName.prefix = "";
        }
        if (qName.uri == null) {
            qName.uri = "";
        }
    }

    void removeDuplicateDecls() {
        for (int i = 0; i < this.fNamespaceDecls.size(); ++i) {
            QName qName = (QName)this.fNamespaceDecls.get(i);
            if (qName == null) continue;
            for (int j = i + 1; j < this.fNamespaceDecls.size(); ++j) {
                QName qName2 = (QName)this.fNamespaceDecls.get(j);
                if (qName2 == null || !qName.prefix.equals(qName2.prefix) || !qName.uri.equals(qName2.uri)) continue;
                this.fNamespaceDecls.remove(j);
            }
        }
    }

    void repairNamespaceDecl(QName qName) {
        QName qName2 = null;
        for (int i = 0; i < this.fNamespaceDecls.size(); ++i) {
            String string;
            qName2 = (QName)this.fNamespaceDecls.get(i);
            if (qName2 == null || qName.prefix == null || !qName.prefix.equals(qName2.prefix) || qName.uri.equals(qName2.uri) || (string = this.fNamespaceContext.getNamespaceURI(qName.prefix)) == null) continue;
            if (string.equals(qName.uri)) {
                this.fNamespaceDecls.set(i, null);
                continue;
            }
            qName2.uri = qName.uri;
        }
    }

    boolean isDeclared(QName qName) {
        QName qName2 = null;
        for (int i = 0; i < this.fNamespaceDecls.size(); ++i) {
            qName2 = (QName)this.fNamespaceDecls.get(i);
            if (qName.prefix == null || qName.prefix != qName2.prefix || qName2.uri != qName.uri) continue;
            return true;
        }
        return qName.uri != null && this.fNamespaceContext.getPrefix(qName.uri) != null;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object object) {
        return object.equals(OUTPUTSTREAM_PROPERTY);
    }

    @Override
    public Object get(Object object) {
        if (object.equals(OUTPUTSTREAM_PROPERTY)) {
            return this.fOutputStream;
        }
        return null;
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    @Override
    public int hashCode() {
        return this.fElementStack.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    class Attribute
    extends QName {
        String value;

        Attribute(String string) {
            this.value = string;
        }
    }

    protected class ElementStack {
        protected ElementState[] fElements = new ElementState[10];
        protected short fDepth;

        public ElementStack() {
            for (int i = 0; i < this.fElements.length; ++i) {
                this.fElements[i] = new ElementState();
            }
        }

        public ElementState push(ElementState elementState) {
            if (this.fDepth == this.fElements.length) {
                ElementState[] elementStateArray = new ElementState[this.fElements.length * 2];
                System.arraycopy(this.fElements, 0, elementStateArray, 0, this.fDepth);
                this.fElements = elementStateArray;
                for (int i = this.fDepth; i < this.fElements.length; ++i) {
                    this.fElements[i] = new ElementState();
                }
            }
            this.fElements[this.fDepth].setValues(elementState);
            short s = this.fDepth;
            this.fDepth = (short)(s + 1);
            return this.fElements[s];
        }

        public ElementState push(String string, String string2, String string3, String string4, boolean bl) {
            if (this.fDepth == this.fElements.length) {
                ElementState[] elementStateArray = new ElementState[this.fElements.length * 2];
                System.arraycopy(this.fElements, 0, elementStateArray, 0, this.fDepth);
                this.fElements = elementStateArray;
                for (int i = this.fDepth; i < this.fElements.length; ++i) {
                    this.fElements[i] = new ElementState();
                }
            }
            this.fElements[this.fDepth].setValues(string, string2, string3, string4, bl);
            short s = this.fDepth;
            this.fDepth = (short)(s + 1);
            return this.fElements[s];
        }

        public ElementState pop() {
            this.fDepth = (short)(this.fDepth - 1);
            return this.fElements[this.fDepth];
        }

        public void clear() {
            this.fDepth = 0;
        }

        public ElementState peek() {
            return this.fElements[this.fDepth - 1];
        }

        public boolean empty() {
            return this.fDepth <= 0;
        }
    }

    class ElementState
    extends QName {
        public boolean isEmpty;

        public ElementState() {
            this.isEmpty = false;
        }

        public ElementState(String string, String string2, String string3, String string4) {
            super(string, string2, string3, string4);
            this.isEmpty = false;
        }

        public void setValues(String string, String string2, String string3, String string4, boolean bl) {
            super.setValues(string, string2, string3, string4);
            this.isEmpty = bl;
        }
    }

    class NamespaceContextImpl
    implements NamespaceContext {
        NamespaceContext userContext = null;
        NamespaceSupport internalContext = null;

        NamespaceContextImpl() {
        }

        @Override
        public String getNamespaceURI(String string) {
            String string2 = null;
            if (string != null) {
                string = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(string);
            }
            if (this.internalContext != null && (string2 = this.internalContext.getURI(string)) != null) {
                return string2;
            }
            if (this.userContext != null) {
                string2 = this.userContext.getNamespaceURI(string);
                return string2;
            }
            return null;
        }

        @Override
        public String getPrefix(String string) {
            String string2 = null;
            if (string != null) {
                string = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(string);
            }
            if (this.internalContext != null && (string2 = this.internalContext.getPrefix(string)) != null) {
                return string2;
            }
            if (this.userContext != null) {
                return this.userContext.getPrefix(string);
            }
            return null;
        }

        public Iterator getPrefixes(String string) {
            Vector vector = null;
            Iterator<String> iterator = null;
            if (string != null) {
                string = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(string);
            }
            if (this.userContext != null) {
                iterator = this.userContext.getPrefixes(string);
            }
            if (this.internalContext != null) {
                vector = this.internalContext.getPrefixes(string);
            }
            if (vector == null && iterator != null) {
                return iterator;
            }
            if (vector != null && iterator == null) {
                return new ReadOnlyIterator(vector.iterator());
            }
            if (vector != null && iterator != null) {
                String string2 = null;
                while (iterator.hasNext()) {
                    string2 = iterator.next();
                    if (string2 != null) {
                        string2 = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(string2);
                    }
                    if (vector.contains(string2)) continue;
                    vector.add(string2);
                }
                return new ReadOnlyIterator(vector.iterator());
            }
            return XMLStreamWriterImpl.this.fReadOnlyIterator;
        }
    }
}

