/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.streaming;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.streaming.ContextClassloaderLocal;
import com.sun.xml.internal.ws.streaming.XMLReaderException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.InputSource;

public abstract class XMLStreamReaderFactory {
    private static final Logger LOGGER = Logger.getLogger(XMLStreamReaderFactory.class.getName());
    private static volatile ContextClassloaderLocal<XMLStreamReaderFactory> streamReader = new ContextClassloaderLocal<XMLStreamReaderFactory>(){

        @Override
        protected XMLStreamReaderFactory initialValue() {
            XMLInputFactory xMLInputFactory = XMLStreamReaderFactory.getXMLInputFactory();
            XMLStreamReaderFactory xMLStreamReaderFactory = null;
            if (!XMLStreamReaderFactory.getProperty(XMLStreamReaderFactory.class.getName() + ".noPool").booleanValue()) {
                xMLStreamReaderFactory = Zephyr.newInstance(xMLInputFactory);
            }
            if (xMLStreamReaderFactory == null && xMLInputFactory.getClass().getName().equals("com.ctc.wstx.stax.WstxInputFactory")) {
                xMLStreamReaderFactory = new Woodstox(xMLInputFactory);
            }
            if (xMLStreamReaderFactory == null) {
                xMLStreamReaderFactory = new Default();
            }
            LOGGER.fine("XMLStreamReaderFactory instance is = " + xMLStreamReaderFactory);
            return xMLStreamReaderFactory;
        }
    };

    private static XMLInputFactory getXMLInputFactory() {
        XMLInputFactory xMLInputFactory = null;
        if (XMLStreamReaderFactory.getProperty(XMLStreamReaderFactory.class.getName() + ".woodstox").booleanValue()) {
            try {
                xMLInputFactory = (XMLInputFactory)Class.forName("com.ctc.wstx.stax.WstxInputFactory").newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (xMLInputFactory == null) {
            xMLInputFactory = XMLInputFactory.newInstance();
        }
        xMLInputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
        xMLInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        return xMLInputFactory;
    }

    public static void set(XMLStreamReaderFactory xMLStreamReaderFactory) {
        if (xMLStreamReaderFactory == null) {
            throw new IllegalArgumentException();
        }
        streamReader.set(xMLStreamReaderFactory);
    }

    public static XMLStreamReaderFactory get() {
        return streamReader.get();
    }

    public static XMLStreamReader create(InputSource inputSource, boolean bl) {
        try {
            if (inputSource.getCharacterStream() != null) {
                return XMLStreamReaderFactory.get().doCreate(inputSource.getSystemId(), inputSource.getCharacterStream(), bl);
            }
            if (inputSource.getByteStream() != null) {
                return XMLStreamReaderFactory.get().doCreate(inputSource.getSystemId(), inputSource.getByteStream(), bl);
            }
            return XMLStreamReaderFactory.get().doCreate(inputSource.getSystemId(), new URL(inputSource.getSystemId()).openStream(), bl);
        }
        catch (IOException iOException) {
            throw new XMLReaderException("stax.cantCreate", new Object[]{iOException});
        }
    }

    public static XMLStreamReader create(@Nullable String string, InputStream inputStream, boolean bl) {
        return XMLStreamReaderFactory.get().doCreate(string, inputStream, bl);
    }

    public static XMLStreamReader create(@Nullable String string, InputStream inputStream, @Nullable String string2, boolean bl) {
        return string2 == null ? XMLStreamReaderFactory.create(string, inputStream, bl) : XMLStreamReaderFactory.get().doCreate(string, inputStream, string2, bl);
    }

    public static XMLStreamReader create(@Nullable String string, Reader reader, boolean bl) {
        return XMLStreamReaderFactory.get().doCreate(string, reader, bl);
    }

    public static void recycle(XMLStreamReader xMLStreamReader) {
        XMLStreamReaderFactory.get().doRecycle(xMLStreamReader);
        if (xMLStreamReader instanceof RecycleAware) {
            ((RecycleAware)((Object)xMLStreamReader)).onRecycled();
        }
    }

    public abstract XMLStreamReader doCreate(String var1, InputStream var2, boolean var3);

    private XMLStreamReader doCreate(String string, InputStream inputStream, @NotNull String string2, boolean bl) {
        InputStreamReader inputStreamReader;
        try {
            inputStreamReader = new InputStreamReader(inputStream, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XMLReaderException("stax.cantCreate", new Object[]{unsupportedEncodingException});
        }
        return this.doCreate(string, inputStreamReader, bl);
    }

    public abstract XMLStreamReader doCreate(String var1, Reader var2, boolean var3);

    public abstract void doRecycle(XMLStreamReader var1);

    private static Boolean getProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String string2 = System.getProperty(string);
                return string2 != null ? Boolean.valueOf(string2) : Boolean.FALSE;
            }
        });
    }

    public static final class Default
    extends XMLStreamReaderFactory {
        private final ThreadLocal<XMLInputFactory> xif = new ThreadLocal<XMLInputFactory>(){

            @Override
            public XMLInputFactory initialValue() {
                return XMLStreamReaderFactory.getXMLInputFactory();
            }
        };

        @Override
        public XMLStreamReader doCreate(String string, InputStream inputStream, boolean bl) {
            try {
                return this.xif.get().createXMLStreamReader(string, inputStream);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        @Override
        public XMLStreamReader doCreate(String string, Reader reader, boolean bl) {
            try {
                return this.xif.get().createXMLStreamReader(string, reader);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        @Override
        public void doRecycle(XMLStreamReader xMLStreamReader) {
        }
    }

    public static class NoLock
    extends XMLStreamReaderFactory {
        private final XMLInputFactory xif;

        public NoLock(XMLInputFactory xMLInputFactory) {
            this.xif = xMLInputFactory;
        }

        @Override
        public XMLStreamReader doCreate(String string, InputStream inputStream, boolean bl) {
            try {
                return this.xif.createXMLStreamReader(string, inputStream);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        @Override
        public XMLStreamReader doCreate(String string, Reader reader, boolean bl) {
            try {
                return this.xif.createXMLStreamReader(string, reader);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        @Override
        public void doRecycle(XMLStreamReader xMLStreamReader) {
        }
    }

    public static interface RecycleAware {
        public void onRecycled();
    }

    public static final class Woodstox
    extends NoLock {
        public Woodstox(XMLInputFactory xMLInputFactory) {
            super(xMLInputFactory);
            xMLInputFactory.setProperty("org.codehaus.stax2.internNsUris", true);
        }

        @Override
        public XMLStreamReader doCreate(String string, InputStream inputStream, boolean bl) {
            return super.doCreate(string, inputStream, bl);
        }

        @Override
        public XMLStreamReader doCreate(String string, Reader reader, boolean bl) {
            return super.doCreate(string, reader, bl);
        }
    }

    public static final class Zephyr
    extends XMLStreamReaderFactory {
        private final XMLInputFactory xif;
        private final ThreadLocal<XMLStreamReader> pool = new ThreadLocal();
        private final Method setInputSourceMethod;
        private final Method resetMethod;
        private final Class zephyrClass;

        @Nullable
        public static XMLStreamReaderFactory newInstance(XMLInputFactory xMLInputFactory) {
            try {
                Class<?> clazz = xMLInputFactory.createXMLStreamReader(new StringReader("<foo/>")).getClass();
                if (!clazz.getName().startsWith("com.sun.xml.internal.stream.")) {
                    return null;
                }
                return new Zephyr(xMLInputFactory, clazz);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
            catch (XMLStreamException xMLStreamException) {
                return null;
            }
        }

        public Zephyr(XMLInputFactory xMLInputFactory, Class clazz) throws NoSuchMethodException {
            this.zephyrClass = clazz;
            this.setInputSourceMethod = clazz.getMethod("setInputSource", InputSource.class);
            this.resetMethod = clazz.getMethod("reset", new Class[0]);
            try {
                xMLInputFactory.setProperty("reuse-instance", false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.xif = xMLInputFactory;
        }

        @Nullable
        private XMLStreamReader fetch() {
            XMLStreamReader xMLStreamReader = this.pool.get();
            if (xMLStreamReader == null) {
                return null;
            }
            this.pool.set(null);
            return xMLStreamReader;
        }

        @Override
        public void doRecycle(XMLStreamReader xMLStreamReader) {
            if (this.zephyrClass.isInstance(xMLStreamReader)) {
                this.pool.set(xMLStreamReader);
            }
        }

        @Override
        public XMLStreamReader doCreate(String string, InputStream inputStream, boolean bl) {
            try {
                XMLStreamReader xMLStreamReader = this.fetch();
                if (xMLStreamReader == null) {
                    return this.xif.createXMLStreamReader(string, inputStream);
                }
                InputSource inputSource = new InputSource(string);
                inputSource.setByteStream(inputStream);
                this.reuse(xMLStreamReader, inputSource);
                return xMLStreamReader;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{illegalAccessException});
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{invocationTargetException});
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        @Override
        public XMLStreamReader doCreate(String string, Reader reader, boolean bl) {
            try {
                XMLStreamReader xMLStreamReader = this.fetch();
                if (xMLStreamReader == null) {
                    return this.xif.createXMLStreamReader(string, reader);
                }
                InputSource inputSource = new InputSource(string);
                inputSource.setCharacterStream(reader);
                this.reuse(xMLStreamReader, inputSource);
                return xMLStreamReader;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{illegalAccessException});
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable == null) {
                    throwable = invocationTargetException;
                }
                throw new XMLReaderException("stax.cantCreate", new Object[]{throwable});
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        private void reuse(XMLStreamReader xMLStreamReader, InputSource inputSource) throws IllegalAccessException, InvocationTargetException {
            this.resetMethod.invoke((Object)xMLStreamReader, new Object[0]);
            this.setInputSourceMethod.invoke((Object)xMLStreamReader, inputSource);
        }
    }
}

