/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.bind.api.JAXBRIContext;
import com.sun.xml.internal.bind.v2.model.annotation.AnnotationReader;
import com.sun.xml.internal.bind.v2.model.nav.Navigator;
import com.sun.xml.internal.ws.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.ws.WebServiceException;

public abstract class AbstractWrapperBeanGenerator<T, C, M, A extends Comparable> {
    private static final Logger LOGGER = Logger.getLogger(AbstractWrapperBeanGenerator.class.getName());
    private static final String RETURN = "return";
    private static final String EMTPY_NAMESPACE_ID = "";
    private static final Class[] jaxbAnns = new Class[]{XmlAttachmentRef.class, XmlMimeType.class, XmlJavaTypeAdapter.class, XmlList.class, XmlElement.class};
    private static final Set<String> skipProperties = new HashSet<String>();
    private final AnnotationReader<T, C, ?, M> annReader;
    private final Navigator<T, C, ?, M> nav;
    private final BeanMemberFactory<T, A> factory;
    private static final Map<String, String> reservedWords;

    protected AbstractWrapperBeanGenerator(AnnotationReader<T, C, ?, M> annotationReader, Navigator<T, C, ?, M> navigator, BeanMemberFactory<T, A> beanMemberFactory) {
        this.annReader = annotationReader;
        this.nav = navigator;
        this.factory = beanMemberFactory;
    }

    private List<Annotation> collectJAXBAnnotations(M m) {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (Class clazz : jaxbAnns) {
            Object a = this.annReader.getMethodAnnotation(clazz, m, null);
            if (a == null) continue;
            arrayList.add((Annotation)a);
        }
        return arrayList;
    }

    private List<Annotation> collectJAXBAnnotations(M m, int n) {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (Class clazz : jaxbAnns) {
            Object a = this.annReader.getMethodParameterAnnotation(clazz, m, n, null);
            if (a == null) continue;
            arrayList.add((Annotation)a);
        }
        return arrayList;
    }

    protected abstract T getSafeType(T var1);

    protected abstract T getHolderValueType(T var1);

    protected abstract boolean isVoidType(T var1);

    public List<A> collectRequestBeanMembers(M m) {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        int n = -1;
        for (T t : this.nav.getMethodParameters(m)) {
            T t2;
            WebParam webParam;
            if ((webParam = this.annReader.getMethodParameterAnnotation(WebParam.class, m, ++n, null)) != null && (webParam.header() || webParam.mode().equals((Object)WebParam.Mode.OUT)) || (t2 = this.getHolderValueType(t)) != null && webParam != null && webParam.mode().equals((Object)WebParam.Mode.IN)) continue;
            T t3 = t2 != null ? t2 : this.getSafeType(t);
            String string = webParam != null && webParam.name().length() > 0 ? webParam.name() : "arg" + n;
            String string2 = webParam != null && webParam.targetNamespace().length() > 0 ? webParam.targetNamespace() : EMTPY_NAMESPACE_ID;
            List<Annotation> list = this.collectJAXBAnnotations(m, n);
            this.processXmlElement(list, string, string2, t3);
            Comparable comparable = (Comparable)this.factory.createWrapperBeanMember(t3, AbstractWrapperBeanGenerator.getPropertyName(string), list);
            arrayList.add(comparable);
        }
        return arrayList;
    }

    public List<A> collectResponseBeanMembers(M m) {
        T t;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = RETURN;
        String string2 = EMTPY_NAMESPACE_ID;
        boolean bl = false;
        WebResult webResult = this.annReader.getMethodAnnotation(WebResult.class, m, null);
        if (webResult != null) {
            if (webResult.name().length() > 0) {
                string = webResult.name();
            }
            if (webResult.targetNamespace().length() > 0) {
                string2 = webResult.targetNamespace();
            }
            bl = webResult.header();
        }
        if (!this.isVoidType(t = this.getSafeType(this.nav.getReturnType(m))) && !bl) {
            List<Annotation> list = this.collectJAXBAnnotations(m);
            this.processXmlElement(list, string, string2, t);
            arrayList.add(this.factory.createWrapperBeanMember(t, AbstractWrapperBeanGenerator.getPropertyName(string), list));
        }
        int n = -1;
        for (T t2 : this.nav.getMethodParameters(m)) {
            T t3 = this.getHolderValueType(t2);
            WebParam webParam = this.annReader.getMethodParameterAnnotation(WebParam.class, m, ++n, null);
            if (t3 == null || webParam != null && webParam.header()) continue;
            String string3 = webParam != null && webParam.name().length() > 0 ? webParam.name() : "arg" + n;
            String string4 = webParam != null && webParam.targetNamespace().length() > 0 ? webParam.targetNamespace() : EMTPY_NAMESPACE_ID;
            List<Annotation> list = this.collectJAXBAnnotations(m, n);
            this.processXmlElement(list, string3, string4, t3);
            Comparable comparable = (Comparable)this.factory.createWrapperBeanMember(t3, AbstractWrapperBeanGenerator.getPropertyName(string3), list);
            arrayList.add(comparable);
        }
        return arrayList;
    }

    private void processXmlElement(List<Annotation> list, String string, String string2, T t) {
        XmlElement xmlElement = null;
        for (Annotation object2 : list) {
            if (object2.annotationType() != XmlElement.class) continue;
            xmlElement = (XmlElement)object2;
            list.remove(object2);
            break;
        }
        String string3 = xmlElement != null && !xmlElement.name().equals("##default") ? xmlElement.name() : string;
        String string4 = xmlElement != null && !xmlElement.namespace().equals("##default") ? xmlElement.namespace() : string2;
        boolean bl = this.nav.isArray(t) || xmlElement != null && xmlElement.nillable();
        boolean bl2 = xmlElement != null && xmlElement.required();
        XmlElementHandler xmlElementHandler = new XmlElementHandler(string3, string4, bl, bl2);
        XmlElement xmlElement2 = (XmlElement)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{XmlElement.class}, (InvocationHandler)xmlElementHandler);
        list.add(xmlElement2);
    }

    public Collection<A> collectExceptionBeanMembers(C c) {
        String[] stringArray;
        TreeMap treeMap = new TreeMap();
        this.getExceptionProperties(c, treeMap);
        XmlType xmlType = this.annReader.getClassAnnotation(XmlType.class, c, null);
        if (xmlType != null && (stringArray = xmlType.propOrder()).length > 0 && stringArray[0].length() != 0) {
            ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
            for (String string : stringArray) {
                Comparable comparable = (Comparable)treeMap.get(string);
                if (comparable == null) {
                    throw new WebServiceException("Exception " + c + " has @XmlType and its propOrder contains unknown property " + string);
                }
                arrayList.add(comparable);
            }
            return arrayList;
        }
        return treeMap.values();
    }

    private void getExceptionProperties(C c, TreeMap<String, A> treeMap) {
        C c2 = this.nav.getSuperClass(c);
        if (c2 != null) {
            this.getExceptionProperties(c2, treeMap);
        }
        Collection<M> collection = this.nav.getDeclaredMethods(c);
        for (M m : collection) {
            String string;
            if (!this.nav.isPublicMethod(m) || this.nav.isStaticMethod(m) && this.nav.isFinalMethod(m) || !this.nav.isPublicMethod(m) || !(string = this.nav.getMethodName(m)).startsWith("get") && !string.startsWith("is") || skipProperties.contains(string) || string.equals("get") || string.equals("is")) continue;
            T t = this.getSafeType(this.nav.getReturnType(m));
            if (this.nav.getMethodParameters(m).length != 0) continue;
            String string2 = string.startsWith("get") ? StringUtils.decapitalize(string.substring(3)) : StringUtils.decapitalize(string.substring(2));
            treeMap.put(string2, this.factory.createWrapperBeanMember(t, string2, Collections.emptyList()));
        }
    }

    private static String getPropertyName(String string) {
        String string2 = JAXBRIContext.mangleNameToVariableName(string);
        return AbstractWrapperBeanGenerator.getJavaReservedVarialbeName(string2);
    }

    @NotNull
    private static String getJavaReservedVarialbeName(@NotNull String string) {
        String string2 = reservedWords.get(string);
        return string2 == null ? string : string2;
    }

    static {
        skipProperties.add("getCause");
        skipProperties.add("getLocalizedMessage");
        skipProperties.add("getClass");
        skipProperties.add("getStackTrace");
        skipProperties.add("getSuppressed");
        reservedWords = new HashMap<String, String>();
        reservedWords.put("abstract", "_abstract");
        reservedWords.put("assert", "_assert");
        reservedWords.put("boolean", "_boolean");
        reservedWords.put("break", "_break");
        reservedWords.put("byte", "_byte");
        reservedWords.put("case", "_case");
        reservedWords.put("catch", "_catch");
        reservedWords.put("char", "_char");
        reservedWords.put("class", "_class");
        reservedWords.put("const", "_const");
        reservedWords.put("continue", "_continue");
        reservedWords.put("default", "_default");
        reservedWords.put("do", "_do");
        reservedWords.put("double", "_double");
        reservedWords.put("else", "_else");
        reservedWords.put("extends", "_extends");
        reservedWords.put("false", "_false");
        reservedWords.put("final", "_final");
        reservedWords.put("finally", "_finally");
        reservedWords.put("float", "_float");
        reservedWords.put("for", "_for");
        reservedWords.put("goto", "_goto");
        reservedWords.put("if", "_if");
        reservedWords.put("implements", "_implements");
        reservedWords.put("import", "_import");
        reservedWords.put("instanceof", "_instanceof");
        reservedWords.put("int", "_int");
        reservedWords.put("interface", "_interface");
        reservedWords.put("long", "_long");
        reservedWords.put("native", "_native");
        reservedWords.put("new", "_new");
        reservedWords.put("null", "_null");
        reservedWords.put("package", "_package");
        reservedWords.put("private", "_private");
        reservedWords.put("protected", "_protected");
        reservedWords.put("public", "_public");
        reservedWords.put(RETURN, "_return");
        reservedWords.put("short", "_short");
        reservedWords.put("static", "_static");
        reservedWords.put("strictfp", "_strictfp");
        reservedWords.put("super", "_super");
        reservedWords.put("switch", "_switch");
        reservedWords.put("synchronized", "_synchronized");
        reservedWords.put("this", "_this");
        reservedWords.put("throw", "_throw");
        reservedWords.put("throws", "_throws");
        reservedWords.put("transient", "_transient");
        reservedWords.put("true", "_true");
        reservedWords.put("try", "_try");
        reservedWords.put("void", "_void");
        reservedWords.put("volatile", "_volatile");
        reservedWords.put("while", "_while");
        reservedWords.put("enum", "_enum");
    }

    public static interface BeanMemberFactory<T, A> {
        public A createWrapperBeanMember(T var1, String var2, List<Annotation> var3);
    }

    private static class XmlElementHandler
    implements InvocationHandler {
        private String name;
        private String namespace;
        private boolean nillable;
        private boolean required;

        XmlElementHandler(String string, String string2, boolean bl, boolean bl2) {
            this.name = string;
            this.namespace = string2;
            this.nillable = bl;
            this.required = bl2;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if (string.equals("name")) {
                return this.name;
            }
            if (string.equals("namespace")) {
                return this.namespace;
            }
            if (string.equals("nillable")) {
                return this.nillable;
            }
            if (string.equals("required")) {
                return this.required;
            }
            throw new WebServiceException("Not handling " + string);
        }
    }
}

