/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.sourcemodel;

import com.sun.xml.internal.ws.policy.PolicyConstants;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.internal.ws.policy.sourcemodel.ModelNode;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicyModelUnmarshaller;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicyReferenceData;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.internal.ws.policy.sourcemodel.wspolicy.NamespaceVersion;
import com.sun.xml.internal.ws.policy.sourcemodel.wspolicy.XmlToken;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XmlPolicyModelUnmarshaller
extends PolicyModelUnmarshaller {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(XmlPolicyModelUnmarshaller.class);

    protected XmlPolicyModelUnmarshaller() {
    }

    @Override
    public PolicySourceModel unmarshalModel(Object object) throws PolicyException {
        XMLEventReader xMLEventReader = this.createXMLEventReader(object);
        PolicySourceModel policySourceModel = null;
        block7: while (xMLEventReader.hasNext()) {
            try {
                XMLEvent xMLEvent = xMLEventReader.peek();
                switch (xMLEvent.getEventType()) {
                    case 5: 
                    case 7: {
                        xMLEventReader.nextEvent();
                        break;
                    }
                    case 4: {
                        this.processCharacters(ModelNode.Type.POLICY, xMLEvent.asCharacters(), null);
                        xMLEventReader.nextEvent();
                        break;
                    }
                    case 1: {
                        if (NamespaceVersion.resolveAsToken(xMLEvent.asStartElement().getName()) == XmlToken.Policy) {
                            StartElement startElement = xMLEventReader.nextEvent().asStartElement();
                            policySourceModel = this.initializeNewModel(startElement);
                            this.unmarshalNodeContent(policySourceModel.getNamespaceVersion(), policySourceModel.getRootNode(), startElement.getName(), xMLEventReader);
                            break block7;
                        }
                        throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0048_POLICY_ELEMENT_EXPECTED_FIRST()));
                    }
                    default: {
                        throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0048_POLICY_ELEMENT_EXPECTED_FIRST()));
                    }
                }
            }
            catch (XMLStreamException xMLStreamException) {
                throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0068_FAILED_TO_UNMARSHALL_POLICY_EXPRESSION(), xMLStreamException));
            }
        }
        return policySourceModel;
    }

    protected PolicySourceModel createSourceModel(NamespaceVersion namespaceVersion, String string, String string2) {
        return PolicySourceModel.createPolicySourceModel(namespaceVersion, string, string2);
    }

    private PolicySourceModel initializeNewModel(StartElement startElement) throws PolicyException, XMLStreamException {
        NamespaceVersion namespaceVersion = NamespaceVersion.resolveVersion(startElement.getName().getNamespaceURI());
        Attribute attribute = this.getAttributeByName(startElement, namespaceVersion.asQName(XmlToken.Name));
        Attribute attribute2 = this.getAttributeByName(startElement, PolicyConstants.XML_ID);
        Attribute attribute3 = this.getAttributeByName(startElement, PolicyConstants.WSU_ID);
        if (attribute3 == null) {
            attribute3 = attribute2;
        } else if (attribute2 != null) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0058_MULTIPLE_POLICY_IDS_NOT_ALLOWED()));
        }
        PolicySourceModel policySourceModel = this.createSourceModel(namespaceVersion, attribute3 == null ? null : attribute3.getValue(), attribute == null ? null : attribute.getValue());
        return policySourceModel;
    }

    private ModelNode addNewChildNode(NamespaceVersion namespaceVersion, ModelNode modelNode, StartElement startElement) throws PolicyException {
        ModelNode modelNode2;
        QName qName = startElement.getName();
        if (modelNode.getType() == ModelNode.Type.ASSERTION_PARAMETER_NODE) {
            modelNode2 = modelNode.createChildAssertionParameterNode();
        } else {
            XmlToken xmlToken = NamespaceVersion.resolveAsToken(qName);
            switch (xmlToken) {
                case Policy: {
                    modelNode2 = modelNode.createChildPolicyNode();
                    break;
                }
                case All: {
                    modelNode2 = modelNode.createChildAllNode();
                    break;
                }
                case ExactlyOne: {
                    modelNode2 = modelNode.createChildExactlyOneNode();
                    break;
                }
                case PolicyReference: {
                    Attribute attribute = this.getAttributeByName(startElement, namespaceVersion.asQName(XmlToken.Uri));
                    if (attribute == null) {
                        throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0040_POLICY_REFERENCE_URI_ATTR_NOT_FOUND()));
                    }
                    try {
                        PolicyReferenceData policyReferenceData;
                        URI uRI = new URI(attribute.getValue());
                        Attribute attribute2 = this.getAttributeByName(startElement, namespaceVersion.asQName(XmlToken.Digest));
                        if (attribute2 == null) {
                            policyReferenceData = new PolicyReferenceData(uRI);
                        } else {
                            Attribute attribute3 = this.getAttributeByName(startElement, namespaceVersion.asQName(XmlToken.DigestAlgorithm));
                            URI uRI2 = null;
                            if (attribute3 != null) {
                                uRI2 = new URI(attribute3.getValue());
                            }
                            policyReferenceData = new PolicyReferenceData(uRI, attribute2.getValue(), uRI2);
                        }
                        modelNode2 = modelNode.createChildPolicyReferenceNode(policyReferenceData);
                        break;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0012_UNABLE_TO_UNMARSHALL_POLICY_MALFORMED_URI(), uRISyntaxException));
                    }
                }
                default: {
                    modelNode2 = modelNode.isDomainSpecific() ? modelNode.createChildAssertionParameterNode() : modelNode.createChildAssertionNode();
                }
            }
        }
        return modelNode2;
    }

    private void parseAssertionData(NamespaceVersion namespaceVersion, String string, ModelNode modelNode, StartElement startElement) throws IllegalArgumentException, PolicyException {
        Object object;
        Object object2;
        HashMap<QName, String> hashMap = new HashMap<QName, String>();
        boolean bl = false;
        boolean bl2 = false;
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = object2.getName();
            if (hashMap.containsKey(object)) {
                throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0059_MULTIPLE_ATTRS_WITH_SAME_NAME_DETECTED_FOR_ASSERTION(object2.getName(), startElement.getName())));
            }
            if (namespaceVersion.asQName(XmlToken.Optional).equals(object)) {
                bl = this.parseBooleanValue(object2.getValue());
                continue;
            }
            if (namespaceVersion.asQName(XmlToken.Ignorable).equals(object)) {
                bl2 = this.parseBooleanValue(object2.getValue());
                continue;
            }
            hashMap.put((QName)object, object2.getValue());
        }
        object2 = new AssertionData(startElement.getName(), string, hashMap, modelNode.getType(), bl, bl2);
        if (((AssertionData)object2).containsAttribute(PolicyConstants.VISIBILITY_ATTRIBUTE) && !"private".equals(object = ((AssertionData)object2).getAttributeValue(PolicyConstants.VISIBILITY_ATTRIBUTE))) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0004_UNEXPECTED_VISIBILITY_ATTR_VALUE(object)));
        }
        modelNode.setOrReplaceNodeData((AssertionData)object2);
    }

    private Attribute getAttributeByName(StartElement startElement, QName qName) {
        Attribute attribute = startElement.getAttributeByName(qName);
        if (attribute == null) {
            String string = qName.getLocalPart();
            Iterator<Attribute> iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute2 = iterator.next();
                QName qName2 = attribute2.getName();
                boolean bl = qName2.equals(qName) || qName2.getLocalPart().equals(string) && (qName2.getPrefix() == null || "".equals(qName2.getPrefix()));
                if (!bl) continue;
                attribute = attribute2;
                break;
            }
        }
        return attribute;
    }

    private String unmarshalNodeContent(NamespaceVersion namespaceVersion, ModelNode modelNode, QName qName, XMLEventReader xMLEventReader) throws PolicyException {
        StringBuilder stringBuilder = null;
        block8: while (xMLEventReader.hasNext()) {
            try {
                XMLEvent xMLEvent = xMLEventReader.nextEvent();
                switch (xMLEvent.getEventType()) {
                    case 5: {
                        break;
                    }
                    case 4: {
                        stringBuilder = this.processCharacters(modelNode.getType(), xMLEvent.asCharacters(), stringBuilder);
                        break;
                    }
                    case 2: {
                        this.checkEndTagName(qName, xMLEvent.asEndElement());
                        break block8;
                    }
                    case 1: {
                        StartElement startElement = xMLEvent.asStartElement();
                        ModelNode modelNode2 = this.addNewChildNode(namespaceVersion, modelNode, startElement);
                        String string = this.unmarshalNodeContent(namespaceVersion, modelNode2, startElement.getName(), xMLEventReader);
                        if (!modelNode2.isDomainSpecific()) continue block8;
                        this.parseAssertionData(namespaceVersion, string, modelNode2, startElement);
                        break;
                    }
                    default: {
                        throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0011_UNABLE_TO_UNMARSHALL_POLICY_XML_ELEM_EXPECTED()));
                    }
                }
            }
            catch (XMLStreamException xMLStreamException) {
                throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0068_FAILED_TO_UNMARSHALL_POLICY_EXPRESSION(), xMLStreamException));
            }
        }
        return stringBuilder == null ? null : stringBuilder.toString().trim();
    }

    private XMLEventReader createXMLEventReader(Object object) throws PolicyException {
        if (object instanceof XMLEventReader) {
            return (XMLEventReader)object;
        }
        if (!(object instanceof Reader)) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0022_STORAGE_TYPE_NOT_SUPPORTED(object.getClass().getName())));
        }
        try {
            return XMLInputFactory.newInstance().createXMLEventReader((Reader)object);
        }
        catch (XMLStreamException xMLStreamException) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0014_UNABLE_TO_INSTANTIATE_READER_FOR_STORAGE(), xMLStreamException));
        }
    }

    private void checkEndTagName(QName qName, EndElement endElement) throws PolicyException {
        QName qName2 = endElement.getName();
        if (!qName.equals(qName2)) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0003_UNMARSHALLING_FAILED_END_TAG_DOES_NOT_MATCH(qName, qName2)));
        }
    }

    private StringBuilder processCharacters(ModelNode.Type type, Characters characters, StringBuilder stringBuilder) throws PolicyException {
        if (characters.isWhiteSpace()) {
            return stringBuilder;
        }
        StringBuilder stringBuilder2 = stringBuilder == null ? new StringBuilder() : stringBuilder;
        String string = characters.getData();
        if (type == ModelNode.Type.ASSERTION || type == ModelNode.Type.ASSERTION_PARAMETER_NODE) {
            return stringBuilder2.append(string);
        }
        throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0009_UNEXPECTED_CDATA_ON_SOURCE_MODEL_NODE((Object)type, string)));
    }

    private boolean parseBooleanValue(String string) throws PolicyException {
        if ("true".equals(string) || "1".equals(string)) {
            return true;
        }
        if ("false".equals(string) || "0".equals(string)) {
            return false;
        }
        throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0095_INVALID_BOOLEAN_VALUE(string)));
    }
}

