/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.istack.internal.NotNull;
import com.sun.org.glassfish.external.amx.AMXGlassfish;
import com.sun.org.glassfish.gmbal.Description;
import com.sun.org.glassfish.gmbal.GmbalMBean;
import com.sun.org.glassfish.gmbal.InheritedAttributes;
import com.sun.org.glassfish.gmbal.ManagedData;
import com.sun.org.glassfish.gmbal.ManagedObjectManager;
import com.sun.org.glassfish.gmbal.ManagedObjectManagerFactory;
import com.sun.xml.internal.ws.api.config.management.policy.ManagedClientAssertion;
import com.sun.xml.internal.ws.api.config.management.policy.ManagedServiceAssertion;
import com.sun.xml.internal.ws.api.config.management.policy.ManagementAssertion;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.client.Stub;
import com.sun.xml.internal.ws.server.DummyWebServiceFeature;
import com.sun.xml.internal.ws.server.RewritingMOM;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.xml.ws.WebServiceFeature;

public abstract class MonitorBase {
    private static final Logger logger = Logger.getLogger("com.sun.xml.internal.ws.monitoring");
    private static ManagementAssertion.Setting clientMonitoring = ManagementAssertion.Setting.NOT_SET;
    private static ManagementAssertion.Setting endpointMonitoring = ManagementAssertion.Setting.NOT_SET;
    private static int typelibDebug = -1;
    private static String registrationDebug = "NONE";
    private static boolean runtimeDebug = false;
    private static int maxUniqueEndpointRootNameRetries = 100;
    private static final String monitorProperty = "com.sun.xml.internal.ws.monitoring.";

    @NotNull
    public ManagedObjectManager createManagedObjectManager(WSEndpoint wSEndpoint) {
        ManagedServiceAssertion managedServiceAssertion;
        String string;
        String string2 = wSEndpoint.getServiceName().getLocalPart() + "-" + wSEndpoint.getPortName().getLocalPart();
        if (string2.equals("-")) {
            string2 = "provider";
        }
        if ((string = this.getContextPath(wSEndpoint)) != null) {
            string2 = string + "-" + string2;
        }
        if ((managedServiceAssertion = ManagedServiceAssertion.getAssertion(wSEndpoint)) != null) {
            String string3 = managedServiceAssertion.getId();
            if (string3 != null) {
                string2 = string3;
            }
            if (managedServiceAssertion.monitoringAttribute() == ManagementAssertion.Setting.OFF) {
                return this.disabled("This endpoint", string2);
            }
        }
        if (endpointMonitoring.equals((Object)ManagementAssertion.Setting.OFF)) {
            return this.disabled("Global endpoint", string2);
        }
        return this.createMOMLoop(string2, 0);
    }

    private String getContextPath(WSEndpoint wSEndpoint) {
        try {
            Container container = wSEndpoint.getContainer();
            Method method = container.getClass().getDeclaredMethod("getSPI", Class.class);
            method.setAccessible(true);
            Class<?> clazz = Class.forName("javax.servlet.ServletContext");
            Object object = method.invoke((Object)container, clazz);
            if (object != null) {
                Method method2 = clazz.getDeclaredMethod("getContextPath", new Class[0]);
                method2.setAccessible(true);
                return (String)method2.invoke(object, new Object[0]);
            }
            return null;
        }
        catch (Throwable throwable) {
            logger.log(Level.FINEST, "getContextPath", throwable);
            return null;
        }
    }

    @NotNull
    public ManagedObjectManager createManagedObjectManager(Stub stub) {
        String string = stub.requestContext.getEndpointAddress().toString();
        ManagedClientAssertion managedClientAssertion = ManagedClientAssertion.getAssertion(stub.getPortInfo());
        if (managedClientAssertion != null) {
            String string2 = managedClientAssertion.getId();
            if (string2 != null) {
                string = string2;
            }
            if (managedClientAssertion.monitoringAttribute() == ManagementAssertion.Setting.OFF) {
                return this.disabled("This client", string);
            }
            if (managedClientAssertion.monitoringAttribute() == ManagementAssertion.Setting.ON && clientMonitoring != ManagementAssertion.Setting.OFF) {
                return this.createMOMLoop(string, 0);
            }
        }
        if (clientMonitoring == ManagementAssertion.Setting.NOT_SET || clientMonitoring == ManagementAssertion.Setting.OFF) {
            return this.disabled("Global client", string);
        }
        return this.createMOMLoop(string, 0);
    }

    @NotNull
    private ManagedObjectManager disabled(String string, String string2) {
        String string3 = string + " monitoring disabled. " + string2 + " will not be monitored";
        logger.log(Level.CONFIG, string3);
        return ManagedObjectManagerFactory.createNOOP();
    }

    @NotNull
    private ManagedObjectManager createMOMLoop(String string, int n) {
        boolean bl = AMXGlassfish.getGlassfishVersion() != null;
        ManagedObjectManager managedObjectManager = this.createMOM(bl);
        managedObjectManager = this.initMOM(managedObjectManager);
        managedObjectManager = this.createRoot(managedObjectManager, string, n);
        return managedObjectManager;
    }

    @NotNull
    private ManagedObjectManager createMOM(boolean bl) {
        try {
            return new RewritingMOM(bl ? ManagedObjectManagerFactory.createFederated(AMXGlassfish.DEFAULT.serverMon(AMXGlassfish.DEFAULT.dasName())) : ManagedObjectManagerFactory.createStandalone("com.sun.metro"));
        }
        catch (Throwable throwable) {
            if (bl) {
                logger.log(Level.CONFIG, "Problem while attempting to federate with GlassFish AMX monitoring.  Trying standalone.", throwable);
                return this.createMOM(false);
            }
            logger.log(Level.WARNING, "Ignoring exception - starting up without monitoring", throwable);
            return ManagedObjectManagerFactory.createNOOP();
        }
    }

    @NotNull
    private ManagedObjectManager initMOM(ManagedObjectManager managedObjectManager) {
        try {
            if (typelibDebug != -1) {
                managedObjectManager.setTypelibDebug(typelibDebug);
            }
            if (registrationDebug.equals("FINE")) {
                managedObjectManager.setRegistrationDebug(ManagedObjectManager.RegistrationDebugLevel.FINE);
            } else if (registrationDebug.equals("NORMAL")) {
                managedObjectManager.setRegistrationDebug(ManagedObjectManager.RegistrationDebugLevel.NORMAL);
            } else {
                managedObjectManager.setRegistrationDebug(ManagedObjectManager.RegistrationDebugLevel.NONE);
            }
            managedObjectManager.setRuntimeDebug(runtimeDebug);
            managedObjectManager.suppressDuplicateRootReport(true);
            managedObjectManager.stripPrefix("com.sun.xml.internal.ws.server", "com.sun.xml.internal.ws.rx.rm.runtime.sequence");
            managedObjectManager.addAnnotation((AnnotatedElement)((Object)WebServiceFeature.class), DummyWebServiceFeature.class.getAnnotation(ManagedData.class));
            managedObjectManager.addAnnotation((AnnotatedElement)((Object)WebServiceFeature.class), DummyWebServiceFeature.class.getAnnotation(Description.class));
            managedObjectManager.addAnnotation((AnnotatedElement)((Object)WebServiceFeature.class), DummyWebServiceFeature.class.getAnnotation(InheritedAttributes.class));
            managedObjectManager.suspendJMXRegistration();
        }
        catch (Throwable throwable) {
            try {
                managedObjectManager.close();
            }
            catch (IOException iOException) {
                logger.log(Level.CONFIG, "Ignoring exception caught when closing unused ManagedObjectManager", iOException);
            }
            logger.log(Level.WARNING, "Ignoring exception - starting up without monitoring", throwable);
            return ManagedObjectManagerFactory.createNOOP();
        }
        return managedObjectManager;
    }

    private ManagedObjectManager createRoot(ManagedObjectManager managedObjectManager, String string, int n) {
        String string2 = string + (n == 0 ? "" : "-" + String.valueOf(n));
        try {
            GmbalMBean gmbalMBean = managedObjectManager.createRoot(this, string2);
            if (gmbalMBean != null) {
                ObjectName objectName = managedObjectManager.getObjectName(managedObjectManager.getRoot());
                if (objectName != null) {
                    logger.log(Level.INFO, "Metro monitoring rootname successfully set to: " + objectName);
                }
                return managedObjectManager;
            }
            try {
                managedObjectManager.close();
            }
            catch (IOException iOException) {
                logger.log(Level.CONFIG, "Ignoring exception caught when closing unused ManagedObjectManager", iOException);
            }
            String string3 = "Duplicate Metro monitoring rootname: " + string2 + " : ";
            if (n > maxUniqueEndpointRootNameRetries) {
                String string4 = string3 + "Giving up.";
                logger.log(Level.INFO, string4);
                return ManagedObjectManagerFactory.createNOOP();
            }
            String string5 = string3 + "Will try to make unique";
            logger.log(Level.CONFIG, string5);
            return this.createMOMLoop(string, ++n);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Error while creating monitoring root with name: " + string, throwable);
            return ManagedObjectManagerFactory.createNOOP();
        }
    }

    public static void closeMOM(ManagedObjectManager managedObjectManager) {
        try {
            ObjectName objectName = managedObjectManager.getObjectName(managedObjectManager.getRoot());
            if (objectName != null) {
                logger.log(Level.INFO, "Closing Metro monitoring root: " + objectName);
            }
            managedObjectManager.close();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Ignoring error when closing Managed Object Manager", iOException);
        }
    }

    private static ManagementAssertion.Setting propertyToSetting(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return ManagementAssertion.Setting.NOT_SET;
        }
        if ((string2 = string2.toLowerCase()).equals("false") || string2.equals("off")) {
            return ManagementAssertion.Setting.OFF;
        }
        if (string2.equals("true") || string2.equals("on")) {
            return ManagementAssertion.Setting.ON;
        }
        return ManagementAssertion.Setting.NOT_SET;
    }

    static {
        try {
            String string;
            endpointMonitoring = MonitorBase.propertyToSetting("com.sun.xml.internal.ws.monitoring.endpoint");
            clientMonitoring = MonitorBase.propertyToSetting("com.sun.xml.internal.ws.monitoring.client");
            Integer n = Integer.getInteger("com.sun.xml.internal.ws.monitoring.typelibDebug");
            if (n != null) {
                typelibDebug = n;
            }
            if ((string = System.getProperty("com.sun.xml.internal.ws.monitoring.registrationDebug")) != null) {
                registrationDebug = string.toUpperCase();
            }
            if ((string = System.getProperty("com.sun.xml.internal.ws.monitoring.runtimeDebug")) != null && string.toLowerCase().equals("true")) {
                runtimeDebug = true;
            }
            if ((n = Integer.getInteger("com.sun.xml.internal.ws.monitoring.maxUniqueEndpointRootNameRetries")) != null) {
                maxUniqueEndpointRootNameRetries = n;
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Error while reading monitoring properties", exception);
        }
    }
}

