/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.org.glassfish.gmbal.ManagedObjectManager;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.ws.addressing.EPRSDDocumentFilter;
import com.sun.xml.internal.ws.addressing.WSEPRExtension;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.Engine;
import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.internal.ws.api.pipe.ServerPipeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.TubelineAssembler;
import com.sun.xml.internal.ws.api.pipe.TubelineAssemblerFactory;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.EndpointAwareCodec;
import com.sun.xml.internal.ws.api.server.EndpointComponent;
import com.sun.xml.internal.ws.api.server.EndpointReferenceExtensionContributor;
import com.sun.xml.internal.ws.api.server.TransportBackChannel;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLProperties;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.resources.HandlerMessages;
import com.sun.xml.internal.ws.server.InvokerTube;
import com.sun.xml.internal.ws.server.MonitorBase;
import com.sun.xml.internal.ws.server.MonitorRootService;
import com.sun.xml.internal.ws.server.ServiceDefinitionImpl;
import com.sun.xml.internal.ws.util.Pool;
import com.sun.xml.internal.ws.util.ServiceFinder;
import com.sun.xml.internal.ws.wsdl.OperationDispatcher;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import org.w3c.dom.Element;

public final class WSEndpointImpl<T>
extends WSEndpoint<T> {
    @NotNull
    private final QName serviceName;
    @NotNull
    private final QName portName;
    private final WSBinding binding;
    private final SEIModel seiModel;
    @NotNull
    private final Container container;
    private final WSDLPort port;
    private final Tube masterTubeline;
    private final ServiceDefinitionImpl serviceDef;
    private final SOAPVersion soapVersion;
    private final Engine engine;
    @NotNull
    private final Codec masterCodec;
    @NotNull
    private final PolicyMap endpointPolicy;
    private final Pool<Tube> tubePool;
    private final OperationDispatcher operationDispatcher;
    @NotNull
    private final ManagedObjectManager managedObjectManager;
    private boolean managedObjectManagerClosed = false;
    @NotNull
    private final ServerTubeAssemblerContext context;
    private Map<QName, WSEndpointReference.EPRExtension> endpointReferenceExtensions = new HashMap<QName, WSEndpointReference.EPRExtension>();
    private boolean disposed;
    private final Class<T> implementationClass;
    @Nullable
    private final WSDLProperties wsdlProperties;
    private final Set<EndpointComponent> componentRegistry = new LinkedHashSet<EndpointComponent>();
    private static final Logger logger = Logger.getLogger("com.sun.xml.internal.ws.server.endpoint");

    WSEndpointImpl(@NotNull QName qName, @NotNull QName qName2, WSBinding wSBinding, Container container, SEIModel sEIModel, WSDLPort wSDLPort, Class<T> clazz, @Nullable ServiceDefinitionImpl serviceDefinitionImpl, InvokerTube invokerTube, boolean bl, PolicyMap policyMap) {
        this.serviceName = qName;
        this.portName = qName2;
        this.binding = wSBinding;
        this.soapVersion = wSBinding.getSOAPVersion();
        this.container = container;
        this.port = wSDLPort;
        this.implementationClass = clazz;
        this.serviceDef = serviceDefinitionImpl;
        this.seiModel = sEIModel;
        this.endpointPolicy = policyMap;
        this.managedObjectManager = new MonitorRootService(this).createManagedObjectManager(this);
        if (serviceDefinitionImpl != null) {
            serviceDefinitionImpl.setOwner(this);
        }
        TubelineAssembler tubelineAssembler = TubelineAssemblerFactory.create(Thread.currentThread().getContextClassLoader(), wSBinding.getBindingId(), container);
        assert (tubelineAssembler != null);
        this.operationDispatcher = wSDLPort == null ? null : new OperationDispatcher(wSDLPort, wSBinding, sEIModel);
        this.context = new ServerPipeAssemblerContext(sEIModel, wSDLPort, this, invokerTube, bl);
        this.masterTubeline = tubelineAssembler.createServer(this.context);
        Codec codec = this.context.getCodec();
        if (codec instanceof EndpointAwareCodec) {
            codec = codec.copy();
            ((EndpointAwareCodec)codec).setEndpoint(this);
        }
        this.masterCodec = codec;
        this.tubePool = new Pool.TubePool(this.masterTubeline);
        invokerTube.setEndpoint(this);
        this.engine = new Engine(this.toString());
        this.wsdlProperties = wSDLPort == null ? null : new WSDLProperties(wSDLPort);
        HashMap<QName, WSEndpointReference.EPRExtension> hashMap = new HashMap<QName, WSEndpointReference.EPRExtension>();
        try {
            EndpointReferenceExtensionContributor[] endpointReferenceExtensionContributorArray;
            if (wSDLPort != null && (endpointReferenceExtensionContributorArray = ((WSDLPortImpl)wSDLPort).getEPR()) != null) {
                for (WSEndpointReference.EPRExtension ePRExtension : endpointReferenceExtensionContributorArray.getEPRExtensions()) {
                    hashMap.put(ePRExtension.getQName(), ePRExtension);
                }
            }
            endpointReferenceExtensionContributorArray = ServiceFinder.find(EndpointReferenceExtensionContributor.class).toArray();
            for (EndpointReferenceExtensionContributor endpointReferenceExtensionContributor : endpointReferenceExtensionContributorArray) {
                WSEndpointReference.EPRExtension ePRExtension = (WSEndpointReference.EPRExtension)hashMap.remove(endpointReferenceExtensionContributor.getQName());
                WSEndpointReference.EPRExtension ePRExtension2 = endpointReferenceExtensionContributor.getEPRExtension(this, ePRExtension);
                if (ePRExtension2 == null) continue;
                hashMap.put(ePRExtension2.getQName(), ePRExtension2);
            }
            for (WSEndpointReference.EPRExtension ePRExtension : hashMap.values()) {
                this.endpointReferenceExtensions.put(ePRExtension.getQName(), new WSEPRExtension(XMLStreamBuffer.createNewBufferFromXMLStreamReader(ePRExtension.readAsXMLStreamReader()), ePRExtension.getQName()));
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
        if (!hashMap.isEmpty()) {
            serviceDefinitionImpl.addFilter(new EPRSDDocumentFilter(this));
        }
    }

    public Collection<WSEndpointReference.EPRExtension> getEndpointReferenceExtensions() {
        return this.endpointReferenceExtensions.values();
    }

    @Nullable
    public OperationDispatcher getOperationDispatcher() {
        return this.operationDispatcher;
    }

    @Override
    public PolicyMap getPolicyMap() {
        return this.endpointPolicy;
    }

    @Override
    @NotNull
    public Class<T> getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    @NotNull
    public WSBinding getBinding() {
        return this.binding;
    }

    @Override
    @NotNull
    public Container getContainer() {
        return this.container;
    }

    @Override
    public WSDLPort getPort() {
        return this.port;
    }

    @Override
    @Nullable
    public SEIModel getSEIModel() {
        return this.seiModel;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.engine.setExecutor(executor);
    }

    @Override
    public void schedule(Packet packet, WSEndpoint.CompletionCallback completionCallback, FiberContextSwitchInterceptor fiberContextSwitchInterceptor) {
        this.processAsync(packet, completionCallback, fiberContextSwitchInterceptor, true);
    }

    private void processAsync(final Packet packet, final WSEndpoint.CompletionCallback completionCallback, FiberContextSwitchInterceptor fiberContextSwitchInterceptor, boolean bl) {
        packet.endpoint = this;
        if (this.wsdlProperties != null) {
            packet.addSatellite(this.wsdlProperties);
        }
        Fiber fiber = this.engine.createFiber();
        if (fiberContextSwitchInterceptor != null) {
            fiber.addInterceptor(fiberContextSwitchInterceptor);
        }
        final Tube tube = this.tubePool.take();
        Fiber.CompletionCallback completionCallback2 = new Fiber.CompletionCallback(){

            @Override
            public void onCompletion(@NotNull Packet packet2) {
                WSEndpointImpl.this.tubePool.recycle(tube);
                if (completionCallback != null) {
                    completionCallback.onCompletion(packet2);
                }
            }

            @Override
            public void onCompletion(@NotNull Throwable throwable) {
                throwable.printStackTrace();
                Message message = SOAPFaultBuilder.createSOAPFaultMessage(WSEndpointImpl.this.soapVersion, null, throwable);
                Packet packet2 = packet.createServerResponse(message, packet.endpoint.getPort(), null, packet.endpoint.getBinding());
                if (completionCallback != null) {
                    completionCallback.onCompletion(packet2);
                }
            }
        };
        if (bl) {
            fiber.start(tube, packet, completionCallback2);
        } else {
            fiber.runAsync(tube, packet, completionCallback2);
        }
    }

    @Override
    public void process(Packet packet, WSEndpoint.CompletionCallback completionCallback, FiberContextSwitchInterceptor fiberContextSwitchInterceptor) {
        this.processAsync(packet, completionCallback, fiberContextSwitchInterceptor, false);
    }

    @Override
    @NotNull
    public WSEndpoint.PipeHead createPipeHead() {
        return new WSEndpoint.PipeHead(){
            private final Tube tube;
            {
                this.tube = TubeCloner.clone(WSEndpointImpl.this.masterTubeline);
            }

            @Override
            @NotNull
            public Packet process(Packet packet, WebServiceContextDelegate webServiceContextDelegate, TransportBackChannel transportBackChannel) {
                Packet packet2;
                packet.webServiceContextDelegate = webServiceContextDelegate;
                packet.transportBackChannel = transportBackChannel;
                packet.endpoint = WSEndpointImpl.this;
                if (WSEndpointImpl.this.wsdlProperties != null) {
                    packet.addSatellite(WSEndpointImpl.this.wsdlProperties);
                }
                Fiber fiber = WSEndpointImpl.this.engine.createFiber();
                try {
                    packet2 = fiber.runSync(this.tube, packet);
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                    Message message = SOAPFaultBuilder.createSOAPFaultMessage(WSEndpointImpl.this.soapVersion, null, runtimeException);
                    packet2 = packet.createServerResponse(message, packet.endpoint.getPort(), null, packet.endpoint.getBinding());
                }
                return packet2;
            }
        };
    }

    @Override
    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.masterTubeline.preDestroy();
        block2: for (Handler handler : this.binding.getHandlerChain()) {
            for (Method method : handler.getClass().getMethods()) {
                if (method.getAnnotation(PreDestroy.class) == null) continue;
                try {
                    method.invoke((Object)handler, new Object[0]);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, HandlerMessages.HANDLER_PREDESTROY_IGNORE(exception.getMessage()), exception);
                }
                continue block2;
            }
        }
        this.closeManagedObjectManager();
    }

    @Override
    public ServiceDefinitionImpl getServiceDefinition() {
        return this.serviceDef;
    }

    @Override
    public Set<EndpointComponent> getComponentRegistry() {
        return this.componentRegistry;
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, String string, String string2, Element ... elementArray) {
        List<Element> list = null;
        if (elementArray != null) {
            list = Arrays.asList(elementArray);
        }
        return this.getEndpointReference(clazz, string, string2, null, list);
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, String string, String string2, List<Element> list, List<Element> list2) {
        QName qName = null;
        if (this.port != null) {
            qName = this.port.getBinding().getPortTypeName();
        }
        AddressingVersion addressingVersion = AddressingVersion.fromSpecClass(clazz);
        return new WSEndpointReference(addressingVersion, string, this.serviceName, this.portName, qName, list, string2, list2, this.endpointReferenceExtensions.values(), null).toSpec(clazz);
    }

    @Override
    @NotNull
    public QName getPortName() {
        return this.portName;
    }

    @Override
    @NotNull
    public Codec createCodec() {
        return this.masterCodec.copy();
    }

    @Override
    @NotNull
    public QName getServiceName() {
        return this.serviceName;
    }

    @Override
    @NotNull
    public ManagedObjectManager getManagedObjectManager() {
        return this.managedObjectManager;
    }

    @Override
    public void closeManagedObjectManager() {
        if (this.managedObjectManagerClosed) {
            return;
        }
        MonitorBase.closeMOM(this.managedObjectManager);
        this.managedObjectManagerClosed = true;
    }

    @Override
    @NotNull
    public ServerTubeAssemblerContext getAssemblerContext() {
        return this.context;
    }
}

