/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMUtil {
    private static DocumentBuilder db;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document createDom() {
        Class<DOMUtil> clazz = DOMUtil.class;
        synchronized (DOMUtil.class) {
            if (db == null) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setNamespaceAware(true);
                    db = documentBuilderFactory.newDocumentBuilder();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new FactoryConfigurationError(parserConfigurationException);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return db.newDocument();
        }
    }

    public static Node createDOMNode(InputStream inputStream) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try {
                return documentBuilder.parse(inputStream);
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(parserConfigurationException.getMessage());
            illegalArgumentException.initCause(parserConfigurationException);
            throw illegalArgumentException;
        }
        return null;
    }

    public static void serializeNode(Element element, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        DOMUtil.writeTagWithAttributes(element, xMLStreamWriter);
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            block8: for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                switch (node.getNodeType()) {
                    case 7: {
                        xMLStreamWriter.writeProcessingInstruction(node.getNodeValue());
                    }
                    case 10: {
                        continue block8;
                    }
                    case 4: {
                        xMLStreamWriter.writeCData(node.getNodeValue());
                        continue block8;
                    }
                    case 8: {
                        xMLStreamWriter.writeComment(node.getNodeValue());
                        continue block8;
                    }
                    case 3: {
                        xMLStreamWriter.writeCharacters(node.getNodeValue());
                        continue block8;
                    }
                    case 1: {
                        DOMUtil.serializeNode((Element)node, xMLStreamWriter);
                    }
                }
            }
        }
        xMLStreamWriter.writeEndElement();
    }

    public static void writeTagWithAttributes(Element element, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        String string;
        String string2;
        Node node;
        int n;
        int n2;
        NamedNodeMap namedNodeMap;
        String string3 = DOMUtil.fixNull(element.getPrefix());
        String string4 = DOMUtil.fixNull(element.getNamespaceURI());
        String string5 = element.getLocalName() == null ? element.getNodeName() : element.getLocalName();
        boolean bl = DOMUtil.isPrefixDeclared(xMLStreamWriter, string4, string3);
        xMLStreamWriter.writeStartElement(string3, string5, string4);
        if (element.hasAttributes()) {
            namedNodeMap = element.getAttributes();
            n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                node = namedNodeMap.item(n);
                string2 = DOMUtil.fixNull(node.getNamespaceURI());
                if (!string2.equals("http://www.w3.org/2000/xmlns/")) continue;
                String string6 = string = node.getLocalName().equals("xmlns") ? "" : node.getLocalName();
                if (string.equals(string3) && node.getNodeValue().equals(string4)) {
                    bl = true;
                }
                if (string.equals("")) {
                    xMLStreamWriter.writeDefaultNamespace(node.getNodeValue());
                    continue;
                }
                xMLStreamWriter.setPrefix(node.getLocalName(), node.getNodeValue());
                xMLStreamWriter.writeNamespace(node.getLocalName(), node.getNodeValue());
            }
        }
        if (!bl) {
            xMLStreamWriter.writeNamespace(string3, string4);
        }
        if (element.hasAttributes()) {
            namedNodeMap = element.getAttributes();
            n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                node = namedNodeMap.item(n);
                string2 = DOMUtil.fixNull(node.getPrefix());
                string = DOMUtil.fixNull(node.getNamespaceURI());
                if (string.equals("http://www.w3.org/2000/xmlns/")) continue;
                String string7 = node.getLocalName();
                if (string7 == null) {
                    string7 = node.getNodeName();
                }
                boolean bl2 = DOMUtil.isPrefixDeclared(xMLStreamWriter, string, string2);
                if (!string2.equals("") && !bl2) {
                    xMLStreamWriter.setPrefix(node.getLocalName(), node.getNodeValue());
                    xMLStreamWriter.writeNamespace(string2, string);
                }
                xMLStreamWriter.writeAttribute(string2, string, string7, node.getNodeValue());
            }
        }
    }

    private static boolean isPrefixDeclared(XMLStreamWriter xMLStreamWriter, String string, String string2) {
        boolean bl = false;
        NamespaceContext namespaceContext = xMLStreamWriter.getNamespaceContext();
        Iterator<String> iterator = namespaceContext.getPrefixes(string);
        while (iterator.hasNext()) {
            if (!string2.equals(iterator.next())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static Element getFirstChild(Element element, String string, String string2) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getLocalName().equals(string2) || !element2.getNamespaceURI().equals(string)) continue;
            return element2;
        }
        return null;
    }

    @NotNull
    private static String fixNull(@Nullable String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    @Nullable
    public static Element getFirstElementChild(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            return (Element)node2;
        }
        return null;
    }

    @NotNull
    public static List<Element> getChildElements(Node node) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            arrayList.add((Element)node2);
        }
        return arrayList;
    }
}

