/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.ForceInline;
import java.lang.invoke.InvokeGeneric;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeForm;
import java.lang.invoke.SimpleMethodHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.util.Arrays;
import sun.invoke.empty.Empty;

class Invokers {
    private final MethodType targetType;
    private MethodHandle exactInvoker;
    private MethodHandle erasedInvoker;
    MethodHandle erasedInvokerWithDrops;
    private MethodHandle generalInvoker;
    private MethodHandle varargsInvoker;
    private final MethodHandle[] spreadInvokers;
    private MethodHandle uninitializedCallSite;
    private static MethodHandle THROW_UCS = null;
    private static final int GENERIC_INVOKER_SLOP = 2;
    private static final LambdaForm.NamedFunction NF_checkExactType;
    private static final LambdaForm.NamedFunction NF_checkGenericType;
    private static final LambdaForm.NamedFunction NF_asType;
    private static final LambdaForm.NamedFunction NF_getCallSiteTarget;

    Invokers(MethodType methodType) {
        this.targetType = methodType;
        this.spreadInvokers = new MethodHandle[methodType.parameterCount() + 1];
    }

    MethodHandle exactInvoker() {
        MethodHandle methodHandle = this.exactInvoker;
        if (methodHandle != null) {
            return methodHandle;
        }
        MethodType methodType = this.targetType;
        MethodType methodType2 = methodType.invokerType();
        if (methodType.parameterSlotCount() <= 252) {
            LambdaForm lambdaForm = Invokers.invokeForm(methodType, false, 10);
            methodHandle = BoundMethodHandle.bindSingle(methodType2, lambdaForm, methodType);
        } else {
            LambdaForm lambdaForm = Invokers.invokeForm(methodType, true, 10);
            methodHandle = SimpleMethodHandle.make(methodType2, lambdaForm);
        }
        assert (this.checkInvoker(methodHandle));
        this.exactInvoker = methodHandle;
        return methodHandle;
    }

    MethodHandle generalInvoker() {
        MethodHandle methodHandle = this.generalInvoker;
        if (methodHandle != null) {
            return methodHandle;
        }
        MethodType methodType = this.targetType;
        MethodType methodType2 = methodType.invokerType();
        if (methodType.parameterSlotCount() <= 251) {
            Invokers.prepareForGenericCall(methodType);
            LambdaForm lambdaForm = Invokers.invokeForm(methodType, false, 12);
            methodHandle = BoundMethodHandle.bindSingle(methodType2, lambdaForm, methodType);
        } else {
            LambdaForm lambdaForm = Invokers.invokeForm(methodType, true, 12);
            methodHandle = SimpleMethodHandle.make(methodType2, lambdaForm);
        }
        assert (this.checkInvoker(methodHandle));
        this.generalInvoker = methodHandle;
        return methodHandle;
    }

    MethodHandle makeBasicInvoker() {
        DirectMethodHandle directMethodHandle = DirectMethodHandle.make(Invokers.invokeBasicMethod(this.targetType));
        assert (this.targetType == this.targetType.basicType());
        assert (this.checkInvoker(directMethodHandle));
        return directMethodHandle;
    }

    static MemberName invokeBasicMethod(MethodType methodType) {
        methodType = methodType.basicType();
        String string = "invokeBasic";
        try {
            return MethodHandles.Lookup.IMPL_LOOKUP.resolveOrFail((byte)5, MethodHandle.class, string, methodType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw MethodHandleStatics.newInternalError((String)("JVM cannot find invoker for " + methodType), (Throwable)reflectiveOperationException);
        }
    }

    private boolean checkInvoker(MethodHandle methodHandle) {
        assert (this.targetType.invokerType().equals((Object)methodHandle.type())) : Arrays.asList(this.targetType, this.targetType.invokerType(), methodHandle);
        assert (methodHandle.internalMemberName() == null || methodHandle.internalMemberName().getMethodType().equals((Object)this.targetType));
        assert (!methodHandle.isVarargsCollector());
        return true;
    }

    MethodHandle erasedInvoker() {
        MethodHandle methodHandle = this.exactInvoker();
        MethodHandle methodHandle2 = this.erasedInvoker;
        if (methodHandle2 != null) {
            return methodHandle2;
        }
        MethodType methodType = this.targetType.erase();
        this.erasedInvoker = methodHandle2 = methodHandle.asType(methodType.invokerType());
        return methodHandle2;
    }

    MethodHandle spreadInvoker(int n) {
        MethodHandle methodHandle = this.spreadInvokers[n];
        if (methodHandle != null) {
            return methodHandle;
        }
        int n2 = this.targetType.parameterCount() - n;
        MethodType methodType = this.targetType.replaceParameterTypes(n, this.targetType.parameterCount(), Object[].class);
        if (this.targetType.parameterSlotCount() <= 253) {
            MethodHandle methodHandle2 = this.generalInvoker();
            methodHandle = methodHandle2.asSpreader(Object[].class, n2);
        } else {
            MethodHandle methodHandle3;
            MethodHandle methodHandle4 = MethodHandles.exactInvoker(methodType);
            try {
                methodHandle3 = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(MethodHandle.class, "asSpreader", MethodType.methodType(MethodHandle.class, Class.class, Integer.TYPE));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw MethodHandleStatics.newInternalError((Throwable)reflectiveOperationException);
            }
            methodHandle3 = MethodHandles.insertArguments(methodHandle3, 1, Object[].class, n2);
            methodHandle = MethodHandles.filterArgument(methodHandle4, 0, methodHandle3);
        }
        assert (methodHandle.type().equals((Object)methodType.invokerType()));
        this.spreadInvokers[n] = methodHandle;
        return methodHandle;
    }

    MethodHandle varargsInvoker() {
        MethodHandle methodHandle = this.varargsInvoker;
        if (methodHandle != null) {
            return methodHandle;
        }
        this.varargsInvoker = methodHandle = this.spreadInvoker(0).asType(MethodType.genericMethodType(0, true).invokerType());
        return methodHandle;
    }

    MethodHandle uninitializedCallSite() {
        MethodHandle methodHandle = this.uninitializedCallSite;
        if (methodHandle != null) {
            return methodHandle;
        }
        if (this.targetType.parameterCount() > 0) {
            MethodType methodType = this.targetType.dropParameterTypes(0, this.targetType.parameterCount());
            Invokers invokers = methodType.invokers();
            methodHandle = MethodHandles.dropArguments(invokers.uninitializedCallSite(), 0, this.targetType.parameterList());
            assert (methodHandle.type().equals((Object)this.targetType));
            this.uninitializedCallSite = methodHandle;
            return methodHandle;
        }
        methodHandle = THROW_UCS;
        if (methodHandle == null) {
            try {
                THROW_UCS = methodHandle = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(CallSite.class, "uninitializedCallSite", MethodType.methodType(Empty.class));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw MethodHandleStatics.newInternalError((Throwable)reflectiveOperationException);
            }
        }
        methodHandle = MethodHandles.explicitCastArguments(methodHandle, MethodType.methodType(this.targetType.returnType()));
        methodHandle = methodHandle.dropArguments(this.targetType, 0, this.targetType.parameterCount());
        assert (methodHandle.type().equals((Object)this.targetType));
        this.uninitializedCallSite = methodHandle;
        return methodHandle;
    }

    public String toString() {
        return "Invokers" + this.targetType;
    }

    static MemberName exactInvokerMethod(MethodType methodType, Object[] objectArray) {
        LambdaForm lambdaForm;
        if (methodType.parameterSlotCount() <= 253) {
            lambdaForm = Invokers.invokeForm(methodType, false, 9);
            objectArray[0] = methodType;
        } else {
            lambdaForm = Invokers.invokeForm(methodType, true, 9);
        }
        return lambdaForm.vmentry;
    }

    static MemberName genericInvokerMethod(MethodType methodType, Object[] objectArray) {
        LambdaForm lambdaForm;
        if (methodType.parameterSlotCount() <= 251) {
            lambdaForm = Invokers.invokeForm(methodType, false, 11);
            objectArray[0] = methodType;
            Invokers.prepareForGenericCall(methodType);
        } else {
            lambdaForm = Invokers.invokeForm(methodType, true, 11);
        }
        return lambdaForm.vmentry;
    }

    private static LambdaForm invokeForm(MethodType methodType, boolean bl, int n) {
        MethodType methodType2;
        Object[] objectArray;
        MethodType methodType3;
        LambdaForm lambdaForm;
        String string;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        if (!bl) {
            methodType = methodType.basicType();
            bl4 = true;
        } else {
            bl4 = false;
        }
        switch (n) {
            case 9: {
                bl3 = true;
                bl2 = false;
                string = "invokeExact_MT";
                break;
            }
            case 10: {
                bl3 = false;
                bl2 = false;
                string = "exactInvoker";
                break;
            }
            case 11: {
                bl3 = true;
                bl2 = true;
                string = "invoke_MT";
                break;
            }
            case 12: {
                bl3 = false;
                bl2 = true;
                string = "invoker";
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        if (bl4 && (lambdaForm = methodType.form().cachedLambdaForm(n)) != null) {
            return lambdaForm;
        }
        int n2 = 0 + (bl3 ? 0 : 1);
        int n3 = n2 + 1;
        int n4 = n3 + methodType.parameterCount();
        int n5 = n4 + (bl3 && !bl ? 1 : 0);
        int n6 = n4;
        int n7 = bl ? -1 : n6++;
        int n8 = n6++;
        int n9 = n6++;
        MethodType methodType4 = methodType.invokerType();
        if (bl3) {
            if (!bl) {
                methodType4 = methodType4.appendParameterTypes(MemberName.class);
            }
        } else {
            methodType4 = methodType4.invokerType();
        }
        LambdaForm.Name[] nameArray = LambdaForm.arguments(n6 - n5, methodType4);
        assert (nameArray.length == n6) : Arrays.asList(methodType, bl, n, n6, nameArray.length);
        if (n7 >= n5) {
            assert (nameArray[n7] == null);
            nameArray[n7] = BoundMethodHandle.getSpeciesData("L").getterName(nameArray[0], 0);
        }
        MethodType methodType5 = methodType3 = bl ? methodType : nameArray[n7];
        if (!bl2) {
            nameArray[n8] = new LambdaForm.Name(NF_checkExactType, nameArray[n2], methodType3);
            objectArray = Arrays.copyOfRange(nameArray, n2, n4, Object[].class);
            methodType2 = methodType;
        } else if (bl) {
            nameArray[n8] = new LambdaForm.Name(NF_asType, nameArray[n2], methodType3);
            objectArray = Arrays.copyOfRange(nameArray, n2, n4, Object[].class);
            objectArray[0] = nameArray[n8];
            methodType2 = methodType;
        } else {
            nameArray[n8] = new LambdaForm.Name(NF_checkGenericType, nameArray[n2], methodType3);
            objectArray = Arrays.copyOfRange(nameArray, n2, n4 + 2, Object[].class);
            System.arraycopy(objectArray, 0, objectArray, 2, objectArray.length - 2);
            objectArray[0] = nameArray[n8];
            objectArray[1] = methodType3;
            methodType2 = methodType.insertParameterTypes(0, MethodType.class, MethodHandle.class);
        }
        nameArray[n9] = new LambdaForm.Name(Invokers.invokeBasicMethod(methodType2), objectArray);
        lambdaForm = new LambdaForm(string, n5, nameArray);
        if (bl3) {
            lambdaForm.compileToBytecode();
        }
        if (bl4) {
            lambdaForm = methodType.form().setCachedLambdaForm(n, lambdaForm);
        }
        return lambdaForm;
    }

    static WrongMethodTypeException newWrongMethodTypeException(MethodType methodType, MethodType methodType2) {
        return new WrongMethodTypeException("expected " + methodType2 + " but found " + methodType);
    }

    @ForceInline
    static void checkExactType(Object object, Object object2) {
        MethodHandle methodHandle = (MethodHandle)object;
        MethodType methodType = (MethodType)object2;
        MethodType methodType2 = methodHandle.type();
        if (methodType2 != methodType) {
            throw Invokers.newWrongMethodTypeException(methodType, methodType2);
        }
    }

    @ForceInline
    static Object checkGenericType(Object object, Object object2) {
        MethodHandle methodHandle = (MethodHandle)object;
        MethodType methodType = (MethodType)object2;
        MethodHandle methodHandle2 = methodType.form().genericInvoker;
        if (methodHandle2 != null) {
            return methodHandle2;
        }
        return Invokers.prepareForGenericCall(methodType);
    }

    static MethodHandle prepareForGenericCall(MethodType methodType) {
        MethodTypeForm methodTypeForm = methodType.form();
        MethodHandle methodHandle = methodTypeForm.genericInvoker;
        if (methodHandle != null) {
            return methodHandle;
        }
        try {
            methodTypeForm.genericInvoker = methodHandle = InvokeGeneric.generalInvokerOf(methodTypeForm.erasedType);
            return methodHandle;
        }
        catch (Exception exception) {
            throw MethodHandleStatics.newInternalError((String)"Exception while resolving inexact invoke", (Throwable)exception);
        }
    }

    static MemberName linkToCallSiteMethod(MethodType methodType) {
        LambdaForm lambdaForm = Invokers.callSiteForm(methodType);
        return lambdaForm.vmentry;
    }

    private static LambdaForm callSiteForm(MethodType methodType) {
        LambdaForm lambdaForm = (methodType = methodType.basicType()).form().cachedLambdaForm(13);
        if (lambdaForm != null) {
            return lambdaForm;
        }
        int n = 0 + methodType.parameterCount();
        int n2 = n + 1;
        int n3 = n;
        int n4 = n3++;
        int n5 = n3++;
        int n6 = n3++;
        MethodType methodType2 = methodType.appendParameterTypes(CallSite.class);
        LambdaForm.Name[] nameArray = LambdaForm.arguments(n3 - n2, methodType2);
        assert (nameArray.length == n3);
        assert (nameArray[n4] != null);
        nameArray[n5] = new LambdaForm.Name(NF_getCallSiteTarget, nameArray[n4]);
        Object[] objectArray = Arrays.copyOfRange(nameArray, 0, n + 1, Object[].class);
        System.arraycopy(objectArray, 0, objectArray, 1, objectArray.length - 1);
        objectArray[0] = nameArray[n5];
        nameArray[n6] = new LambdaForm.Name(Invokers.invokeBasicMethod(methodType), objectArray);
        lambdaForm = new LambdaForm("linkToCallSite", n2, nameArray);
        lambdaForm.compileToBytecode();
        lambdaForm = methodType.form().setCachedLambdaForm(13, lambdaForm);
        return lambdaForm;
    }

    @ForceInline
    static Object getCallSiteTarget(Object object) {
        return ((CallSite)object).getTarget();
    }

    static {
        try {
            NF_checkExactType = new LambdaForm.NamedFunction(Invokers.class.getDeclaredMethod("checkExactType", Object.class, Object.class));
            NF_checkGenericType = new LambdaForm.NamedFunction(Invokers.class.getDeclaredMethod("checkGenericType", Object.class, Object.class));
            NF_asType = new LambdaForm.NamedFunction(MethodHandle.class.getDeclaredMethod("asType", MethodType.class));
            NF_getCallSiteTarget = new LambdaForm.NamedFunction(Invokers.class.getDeclaredMethod("getCallSiteTarget", Object.class));
            NF_checkExactType.resolve();
            NF_checkGenericType.resolve();
            NF_getCallSiteTarget.resolve();
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw MethodHandleStatics.newInternalError((Throwable)reflectiveOperationException);
        }
    }
}

