/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;
import java.text.NumberFormat;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ProgressBarUI;

public class JProgressBar
extends JComponent
implements SwingConstants,
Accessible {
    private static final String uiClassID = "ProgressBarUI";
    protected int orientation;
    protected boolean paintBorder;
    protected BoundedRangeModel model;
    protected String progressString;
    protected boolean paintString;
    private static final int defaultMinimum = 0;
    private static final int defaultMaximum = 100;
    private static final int defaultOrientation = 0;
    protected transient ChangeEvent changeEvent = null;
    protected ChangeListener changeListener = null;
    private transient Format format;
    private boolean indeterminate;

    public JProgressBar() {
        this(0);
    }

    public JProgressBar(int n) {
        this(n, 0, 100);
    }

    public JProgressBar(int n, int n2) {
        this(0, n, n2);
    }

    public JProgressBar(int n, int n2, int n3) {
        this.setModel(new DefaultBoundedRangeModel(n2, 0, n2, n3));
        this.updateUI();
        this.setOrientation(n);
        this.setBorderPainted(true);
        this.setStringPainted(false);
        this.setString(null);
        this.setIndeterminate(false);
    }

    public JProgressBar(BoundedRangeModel boundedRangeModel) {
        this.setModel(boundedRangeModel);
        this.updateUI();
        this.setOrientation(0);
        this.setBorderPainted(true);
        this.setStringPainted(false);
        this.setString(null);
        this.setIndeterminate(false);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (this.orientation != n) {
            switch (n) {
                case 0: 
                case 1: {
                    int n2 = this.orientation;
                    this.orientation = n;
                    this.firePropertyChange("orientation", n2, n);
                    if (this.accessibleContext == null) break;
                    this.accessibleContext.firePropertyChange("AccessibleState", n2 == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, this.orientation == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(n + " is not a legal orientation");
                }
            }
            this.revalidate();
        }
    }

    public boolean isStringPainted() {
        return this.paintString;
    }

    public void setStringPainted(boolean bl) {
        boolean bl2 = this.paintString;
        this.paintString = bl;
        this.firePropertyChange("stringPainted", bl2, this.paintString);
        if (this.paintString != bl2) {
            this.revalidate();
            this.repaint();
        }
    }

    public String getString() {
        if (this.progressString != null) {
            return this.progressString;
        }
        if (this.format == null) {
            this.format = NumberFormat.getPercentInstance();
        }
        return this.format.format(new Double(this.getPercentComplete()));
    }

    public void setString(String string) {
        String string2 = this.progressString;
        this.progressString = string;
        this.firePropertyChange("string", string2, this.progressString);
        if (this.progressString == null || string2 == null || !this.progressString.equals(string2)) {
            this.repaint();
        }
    }

    public double getPercentComplete() {
        long l = this.model.getMaximum() - this.model.getMinimum();
        double d = this.model.getValue();
        double d2 = (d - (double)this.model.getMinimum()) / (double)l;
        return d2;
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        boolean bl2 = this.paintBorder;
        this.paintBorder = bl;
        this.firePropertyChange("borderPainted", bl2, this.paintBorder);
        if (this.paintBorder != bl2) {
            this.repaint();
        }
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    @Override
    public ProgressBarUI getUI() {
        return (ProgressBarUI)this.ui;
    }

    public void setUI(ProgressBarUI progressBarUI) {
        super.setUI(progressBarUI);
    }

    @Override
    public void updateUI() {
        this.setUI((ProgressBarUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        BoundedRangeModel boundedRangeModel2 = this.getModel();
        if (boundedRangeModel != boundedRangeModel2) {
            if (boundedRangeModel2 != null) {
                boundedRangeModel2.removeChangeListener(this.changeListener);
                this.changeListener = null;
            }
            this.model = boundedRangeModel;
            if (boundedRangeModel != null) {
                this.changeListener = this.createChangeListener();
                boundedRangeModel.addChangeListener(this.changeListener);
            }
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleValue", boundedRangeModel2 == null ? null : Integer.valueOf(boundedRangeModel2.getValue()), boundedRangeModel == null ? null : Integer.valueOf(boundedRangeModel.getValue()));
            }
            if (this.model != null) {
                this.model.setExtent(0);
            }
            this.repaint();
        }
    }

    public int getValue() {
        return this.getModel().getValue();
    }

    public int getMinimum() {
        return this.getModel().getMinimum();
    }

    public int getMaximum() {
        return this.getModel().getMaximum();
    }

    public void setValue(int n) {
        BoundedRangeModel boundedRangeModel = this.getModel();
        int n2 = boundedRangeModel.getValue();
        boundedRangeModel.setValue(n);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", n2, boundedRangeModel.getValue());
        }
    }

    public void setMinimum(int n) {
        this.getModel().setMinimum(n);
    }

    public void setMaximum(int n) {
        this.getModel().setMaximum(n);
    }

    public void setIndeterminate(boolean bl) {
        boolean bl2 = this.indeterminate;
        this.indeterminate = bl;
        this.firePropertyChange("indeterminate", bl2, this.indeterminate);
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    protected String paramString() {
        String string = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        String string2 = this.paintBorder ? "true" : "false";
        String string3 = this.progressString != null ? this.progressString : "";
        String string4 = this.paintString ? "true" : "false";
        String string5 = this.indeterminate ? "true" : "false";
        return super.paramString() + ",orientation=" + string + ",paintBorder=" + string2 + ",paintString=" + string4 + ",progressString=" + string3 + ",indeterminateString=" + string5;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJProgressBar();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJProgressBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        protected AccessibleJProgressBar() {
            super(JProgressBar.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JProgressBar.this.getModel().getValueIsAdjusting()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            if (JProgressBar.this.getOrientation() == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            return JProgressBar.this.getValue();
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            if (number == null) {
                return false;
            }
            JProgressBar.this.setValue(number.intValue());
            return true;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return JProgressBar.this.getMinimum();
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return JProgressBar.this.model.getMaximum() - JProgressBar.this.model.getExtent();
        }
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        private ModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JProgressBar.this.fireStateChanged();
        }
    }
}

