/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.GetPropertyAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Messages;

class ContextFinder {
    private static final Logger logger = Logger.getLogger("javax.xml.bind");
    private static final String PLATFORM_DEFAULT_FACTORY_CLASS = "com.sun.xml.internal.bind.v2.ContextFactory";

    ContextFinder() {
    }

    private static void handleInvocationTargetException(InvocationTargetException invocationTargetException) throws JAXBException {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable != null) {
            if (throwable instanceof JAXBException) {
                throw (JAXBException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
        }
    }

    private static JAXBException handleClassCastException(Class clazz, Class clazz2) {
        URL uRL = ContextFinder.which(clazz2);
        return new JAXBException(Messages.format("JAXBContext.IllegalCast", clazz.getClassLoader().getResource("javax/xml/bind/JAXBContext.class"), uRL));
    }

    static JAXBContext newInstance(String string, String string2, ClassLoader classLoader, Map map) throws JAXBException {
        try {
            Class clazz = ContextFinder.safeLoadClass(string2, classLoader);
            return ContextFinder.newInstance(string, clazz, classLoader, map);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXBException(Messages.format("ContextFinder.ProviderNotFound", string2), classNotFoundException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", string2, exception), exception);
        }
    }

    static JAXBContext newInstance(String string, Class clazz, ClassLoader classLoader, Map map) throws JAXBException {
        try {
            Method method;
            Object object = null;
            try {
                method = clazz.getMethod("createContext", String.class, ClassLoader.class, Map.class);
                object = method.invoke(null, string, classLoader, map);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (object == null) {
                method = clazz.getMethod("createContext", String.class, ClassLoader.class);
                object = method.invoke(null, string, classLoader);
            }
            if (!(object instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(object.getClass(), JAXBContext.class);
            }
            return (JAXBContext)object;
        }
        catch (InvocationTargetException invocationTargetException) {
            ContextFinder.handleInvocationTargetException(invocationTargetException);
            Throwable throwable = invocationTargetException;
            if (invocationTargetException.getTargetException() != null) {
                throwable = invocationTargetException.getTargetException();
            }
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", clazz, throwable), throwable);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", clazz, exception), exception);
        }
    }

    static JAXBContext newInstance(Class[] classArray, Map map, String string) throws JAXBException {
        Class clazz;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            clazz = ContextFinder.safeLoadClass(string, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXBException(classNotFoundException);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "loaded {0} from {1}", new Object[]{string, ContextFinder.which(clazz)});
        }
        return ContextFinder.newInstance(classArray, map, clazz);
    }

    static JAXBContext newInstance(Class[] classArray, Map map, Class clazz) throws JAXBException {
        Method method;
        try {
            method = clazz.getMethod("createContext", Class[].class, Map.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JAXBException(noSuchMethodException);
        }
        try {
            Object object = method.invoke(null, classArray, map);
            if (!(object instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(object.getClass(), JAXBContext.class);
            }
            return (JAXBContext)object;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JAXBException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ContextFinder.handleInvocationTargetException(invocationTargetException);
            Throwable throwable = invocationTargetException;
            if (invocationTargetException.getTargetException() != null) {
                throwable = invocationTargetException.getTargetException();
            }
            throw new JAXBException(throwable);
        }
    }

    static JAXBContext find(String string, String string2, ClassLoader classLoader, Map map) throws JAXBException {
        Serializable serializable;
        Object object;
        String string3 = JAXBContext.class.getName();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new JAXBException(Messages.format("ContextFinder.NoPackageInContextPath"));
        }
        logger.fine("Searching jaxb.properties");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken(":").replace('.', '/');
            StringBuilder stringBuilder = new StringBuilder().append((String)object).append("/jaxb.properties");
            serializable = ContextFinder.loadJAXBProperties(classLoader, stringBuilder.toString());
            if (serializable == null) continue;
            if (((Properties)serializable).containsKey(string)) {
                String string4 = ((Properties)serializable).getProperty(string);
                return ContextFinder.newInstance(string2, string4, classLoader, map);
            }
            throw new JAXBException(Messages.format("ContextFinder.MissingProperty", object, string));
        }
        logger.fine("Searching the system property");
        String string5 = AccessController.doPrivileged(new GetPropertyAction("javax.xml.bind.context.factory"));
        if (string5 != null) {
            return ContextFinder.newInstance(string2, string5, classLoader, map);
        }
        string5 = AccessController.doPrivileged(new GetPropertyAction(string3));
        if (string5 != null) {
            return ContextFinder.newInstance(string2, string5, classLoader, map);
        }
        if (Thread.currentThread().getContextClassLoader() == classLoader && (object = ContextFinder.lookupUsingOSGiServiceLoader("javax.xml.bind.JAXBContext")) != null) {
            logger.fine("OSGi environment detected");
            return ContextFinder.newInstance(string2, (Class)object, classLoader, map);
        }
        logger.fine("Searching META-INF/services");
        try {
            serializable = new StringBuilder().append("META-INF/services/").append(string3);
            InputStream inputStream = classLoader.getResourceAsStream(((StringBuilder)serializable).toString());
            if (inputStream != null) {
                object = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                string5 = ((BufferedReader)object).readLine().trim();
                ((BufferedReader)object).close();
                return ContextFinder.newInstance(string2, string5, classLoader, map);
            }
            logger.log(Level.FINE, "Unable to load:{0}", ((StringBuilder)serializable).toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JAXBException(unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new JAXBException(iOException);
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance(string2, PLATFORM_DEFAULT_FACTORY_CLASS, classLoader, map);
    }

    static JAXBContext find(Class[] classArray, Map map) throws JAXBException {
        Object object;
        String string = JAXBContext.class.getName();
        for (final Class clazz : classArray) {
            object = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return clazz.getClassLoader();
                }
            });
            Package package_ = clazz.getPackage();
            if (package_ == null) continue;
            String string2 = package_.getName().replace('.', '/');
            String string3 = string2 + "/jaxb.properties";
            logger.log(Level.FINE, "Trying to locate {0}", string3);
            Properties properties = ContextFinder.loadJAXBProperties((ClassLoader)object, string3);
            if (properties == null) {
                logger.fine("  not found");
                continue;
            }
            logger.fine("  found");
            if (properties.containsKey("javax.xml.bind.context.factory")) {
                String string4 = properties.getProperty("javax.xml.bind.context.factory").trim();
                return ContextFinder.newInstance(classArray, map, string4);
            }
            throw new JAXBException(Messages.format("ContextFinder.MissingProperty", string2, "javax.xml.bind.context.factory"));
        }
        logger.log(Level.FINE, "Checking system property {0}", "javax.xml.bind.context.factory");
        String string5 = AccessController.doPrivileged(new GetPropertyAction("javax.xml.bind.context.factory"));
        if (string5 != null) {
            logger.log(Level.FINE, "  found {0}", string5);
            return ContextFinder.newInstance(classArray, map, string5);
        }
        logger.fine("  not found");
        logger.log(Level.FINE, "Checking system property {0}", string);
        string5 = AccessController.doPrivileged(new GetPropertyAction(string));
        if (string5 != null) {
            logger.log(Level.FINE, "  found {0}", string5);
            return ContextFinder.newInstance(classArray, map, string5);
        }
        logger.fine("  not found");
        Class clazz = ContextFinder.lookupUsingOSGiServiceLoader("javax.xml.bind.JAXBContext");
        if (clazz != null) {
            logger.fine("OSGi environment detected");
            return ContextFinder.newInstance(classArray, map, clazz);
        }
        logger.fine("Checking META-INF/services");
        try {
            String unsupportedEncodingException = "META-INF/services/" + string;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            object = classLoader == null ? ClassLoader.getSystemResource(unsupportedEncodingException) : classLoader.getResource(unsupportedEncodingException);
            if (object != null) {
                logger.log(Level.FINE, "Reading {0}", object);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((URL)object).openStream(), "UTF-8"));
                string5 = bufferedReader.readLine().trim();
                return ContextFinder.newInstance(classArray, map, string5);
            }
            logger.log(Level.FINE, "Unable to find: {0}", unsupportedEncodingException);
        }
        catch (UnsupportedEncodingException iOException) {
            throw new JAXBException(iOException);
        }
        catch (IOException iOException) {
            throw new JAXBException(iOException);
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance(classArray, map, PLATFORM_DEFAULT_FACTORY_CLASS);
    }

    private static Class lookupUsingOSGiServiceLoader(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Class<?> clazz2 = Class.forName("com.sun.org.glassfish.hk2.osgiresourcelocator.ServiceLoader");
            Method method = clazz2.getMethod("lookupProviderClasses", Class.class);
            Iterator iterator = ((Iterable)method.invoke(null, clazz)).iterator();
            return iterator.hasNext() ? (Class)iterator.next() : null;
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Unable to find from OSGi: {0}", string);
            return null;
        }
    }

    private static Properties loadJAXBProperties(ClassLoader classLoader, String string) throws JAXBException {
        Properties properties = null;
        try {
            URL uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
            if (uRL != null) {
                logger.log(Level.FINE, "loading props from {0}", uRL);
                properties = new Properties();
                InputStream inputStream = uRL.openStream();
                properties.load(inputStream);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Unable to load " + string, iOException);
            throw new JAXBException(iOException.toString(), iOException);
        }
        return properties;
    }

    static URL which(Class clazz, ClassLoader classLoader) {
        String string = clazz.getName().replace('.', '/') + ".class";
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader.getResource(string);
    }

    static URL which(Class clazz) {
        return ContextFinder.which(clazz, clazz.getClassLoader());
    }

    private static Class safeLoadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        logger.log(Level.FINE, "Trying to load {0}", string);
        try {
            int n;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (n = string.lastIndexOf(46)) != -1) {
                securityManager.checkPackageAccess(string.substring(0, n));
            }
            if (classLoader == null) {
                return Class.forName(string);
            }
            return classLoader.loadClass(string);
        }
        catch (SecurityException securityException) {
            if (PLATFORM_DEFAULT_FACTORY_CLASS.equals(string)) {
                return Class.forName(string);
            }
            throw securityException;
        }
    }

    static {
        try {
            if (AccessController.doPrivileged(new GetPropertyAction("jaxb.debug")) != null) {
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.ALL);
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setLevel(Level.ALL);
                logger.addHandler(consoleHandler);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

