/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm.kcms;

import java.awt.color.CMMException;
import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;
import java.security.AccessController;
import sun.java2d.cmm.ColorTransform;
import sun.java2d.cmm.PCMM;
import sun.java2d.cmm.kcms.CMMImageLayout;
import sun.java2d.cmm.kcms.ICC_Transform;
import sun.security.action.LoadLibraryAction;

public class CMM
implements PCMM {
    private static long ID = 0L;
    static final int cmmStatSuccess = 0;
    static final int cmmStatBadProfile = 503;
    static final int cmmStatBadTagData = 504;
    static final int cmmStatBadTagType = 505;
    static final int cmmStatBadTagId = 506;
    static final int cmmStatBadXform = 507;
    static final int cmmStatXformNotActive = 508;
    static final int cmmStatOutOfRange = 518;
    static final int cmmStatTagNotFound = 519;

    static native int cmmLoadProfile(byte[] var0, long[] var1);

    static native int cmmFreeProfile(long var0);

    static native int cmmGetProfileSize(long var0, int[] var2);

    static native int cmmGetProfileData(long var0, byte[] var2);

    static native int cmmGetTagSize(long var0, int var2, int[] var3);

    static native int cmmGetTagData(long var0, int var2, byte[] var3);

    static native int cmmSetTagData(long var0, int var2, byte[] var3);

    static native int cmmGetTransform(ICC_Profile var0, int var1, int var2, ICC_Transform var3);

    static native int cmmCombineTransforms(ICC_Transform[] var0, ICC_Transform var1);

    static native int cmmFreeTransform(long var0);

    static native int cmmGetNumComponents(long var0, int[] var2);

    static native int cmmColorConvert(long var0, CMMImageLayout var2, CMMImageLayout var3);

    public long loadProfile(byte[] byArray) {
        long[] lArray = new long[1];
        CMM.checkStatus(CMM.cmmLoadProfile(byArray, lArray));
        return lArray[0];
    }

    public void freeProfile(long l) {
        CMM.checkStatus(CMM.cmmFreeProfile(l));
    }

    public int getProfileSize(long l) {
        int[] nArray = new int[1];
        CMM.checkStatus(CMM.cmmGetProfileSize(l, nArray));
        return nArray[0];
    }

    public void getProfileData(long l, byte[] byArray) {
        CMM.checkStatus(CMM.cmmGetProfileData(l, byArray));
    }

    public int getTagSize(long l, int n) {
        int[] nArray = new int[1];
        CMM.checkStatus(CMM.cmmGetTagSize(l, n, nArray));
        return nArray[0];
    }

    public void getTagData(long l, int n, byte[] byArray) {
        CMM.checkStatus(CMM.cmmGetTagData(l, n, byArray));
    }

    public void setTagData(long l, int n, byte[] byArray) {
        int n2 = CMM.cmmSetTagData(l, n, byArray);
        switch (n2) {
            case 504: 
            case 505: 
            case 519: {
                throw new IllegalArgumentException("Can not write tag data.");
            }
        }
        CMM.checkStatus(n2);
    }

    public ColorTransform createTransform(ICC_Profile iCC_Profile, int n, int n2) {
        ICC_Transform iCC_Transform = new ICC_Transform();
        CMM.checkStatus(CMM.cmmGetTransform(iCC_Profile, n, n2, iCC_Transform));
        return iCC_Transform;
    }

    public ColorTransform createTransform(ColorTransform[] colorTransformArray) {
        int n;
        ICC_Transform iCC_Transform = new ICC_Transform();
        ICC_Transform[] iCC_TransformArray = new ICC_Transform[colorTransformArray.length];
        for (n = 0; n < colorTransformArray.length; ++n) {
            iCC_TransformArray[n] = (ICC_Transform)colorTransformArray[n];
        }
        n = CMM.cmmCombineTransforms(iCC_TransformArray, iCC_Transform);
        if (n != 0 || iCC_Transform.getID() == 0L) {
            throw new ProfileDataException("Invalid profile sequence");
        }
        return iCC_Transform;
    }

    static native int cmmInit();

    static native int cmmTerminate();

    protected void finalize() {
        CMM.checkStatus(CMM.cmmTerminate());
    }

    public static void checkStatus(int n) {
        if (n != 0) {
            throw new CMMException(CMM.errorString(n));
        }
    }

    static String errorString(int n) {
        switch (n) {
            case 0: {
                return "Success";
            }
            case 519: {
                return "No such tag";
            }
            case 503: {
                return "Invalid profile data";
            }
            case 504: {
                return "Invalid tag data";
            }
            case 505: {
                return "Invalid tag type";
            }
            case 506: {
                return "Invalid tag signature";
            }
            case 507: {
                return "Invlaid transform";
            }
            case 508: {
                return "Transform is not active";
            }
            case 518: {
                return "Invalid image format";
            }
        }
        return "General CMM error" + n;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("kcms"));
        int n = CMM.cmmInit();
    }
}

