/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.ExtendedCopyOption;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.LinkPermission;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import sun.nio.fs.Cancellable;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class UnixCopyFile {
    private UnixCopyFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyDirectory(UnixPath unixPath, UnixFileAttributes unixFileAttributes, UnixPath unixPath2, Flags flags) throws IOException {
        int n;
        block30: {
            try {
                UnixNativeDispatcher.mkdir(unixPath2, unixFileAttributes.mode());
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(unixPath2);
            }
            if (!(flags.copyBasicAttributes || flags.copyPosixAttributes || flags.copyNonPosixAttributes)) {
                return;
            }
            n = -1;
            try {
                n = UnixNativeDispatcher.open(unixPath2, 0, 0);
            }
            catch (UnixException unixException) {
                if (!flags.copyNonPosixAttributes || !flags.failIfUnableToCopyNonPosix) break block30;
                try {
                    UnixNativeDispatcher.rmdir(unixPath2);
                }
                catch (UnixException unixException2) {
                    // empty catch block
                }
                unixException.rethrowAsIOException(unixPath2);
            }
        }
        boolean bl = false;
        try {
            block33: {
                block31: {
                    if (flags.copyPosixAttributes) {
                        try {
                            if (n >= 0) {
                                UnixNativeDispatcher.fchown(n, unixFileAttributes.uid(), unixFileAttributes.gid());
                                UnixNativeDispatcher.fchmod(n, unixFileAttributes.mode());
                            } else {
                                UnixNativeDispatcher.chown(unixPath2, unixFileAttributes.uid(), unixFileAttributes.gid());
                                UnixNativeDispatcher.chmod(unixPath2, unixFileAttributes.mode());
                            }
                        }
                        catch (UnixException unixException) {
                            if (!flags.failIfUnableToCopyPosix) break block31;
                            unixException.rethrowAsIOException(unixPath2);
                        }
                    }
                }
                if (flags.copyNonPosixAttributes && n >= 0) {
                    int n2;
                    block32: {
                        n2 = -1;
                        try {
                            n2 = UnixNativeDispatcher.open(unixPath, 0, 0);
                        }
                        catch (UnixException unixException) {
                            if (!flags.failIfUnableToCopyNonPosix) break block32;
                            unixException.rethrowAsIOException(unixPath);
                        }
                    }
                    if (n2 >= 0) {
                        unixPath.getFileSystem().copyNonPosixAttributes(n2, n);
                        UnixNativeDispatcher.close(n2);
                    }
                }
                if (flags.copyBasicAttributes) {
                    try {
                        if (n >= 0) {
                            UnixNativeDispatcher.futimes(n, unixFileAttributes.lastAccessTime().to(TimeUnit.MICROSECONDS), unixFileAttributes.lastModifiedTime().to(TimeUnit.MICROSECONDS));
                        } else {
                            UnixNativeDispatcher.utimes(unixPath2, unixFileAttributes.lastAccessTime().to(TimeUnit.MICROSECONDS), unixFileAttributes.lastModifiedTime().to(TimeUnit.MICROSECONDS));
                        }
                    }
                    catch (UnixException unixException) {
                        if (!flags.failIfUnableToCopyBasic) break block33;
                        unixException.rethrowAsIOException(unixPath2);
                    }
                }
            }
            bl = true;
        }
        finally {
            if (n >= 0) {
                UnixNativeDispatcher.close(n);
            }
            if (!bl) {
                try {
                    UnixNativeDispatcher.rmdir(unixPath2);
                }
                catch (UnixException unixException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(UnixPath unixPath, UnixFileAttributes unixFileAttributes, UnixPath unixPath2, Flags flags, long l) throws IOException {
        int n = -1;
        try {
            n = UnixNativeDispatcher.open(unixPath, 0, 0);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath);
        }
        try {
            int n2 = -1;
            try {
                n2 = UnixNativeDispatcher.open(unixPath2, 193, unixFileAttributes.mode());
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(unixPath2);
            }
            boolean bl = false;
            try {
                block25: {
                    block24: {
                        try {
                            UnixCopyFile.transfer(n2, n, l);
                        }
                        catch (UnixException unixException) {
                            unixException.rethrowAsIOException(unixPath, unixPath2);
                        }
                        if (flags.copyPosixAttributes) {
                            try {
                                UnixNativeDispatcher.fchown(n2, unixFileAttributes.uid(), unixFileAttributes.gid());
                                UnixNativeDispatcher.fchmod(n2, unixFileAttributes.mode());
                            }
                            catch (UnixException unixException) {
                                if (!flags.failIfUnableToCopyPosix) break block24;
                                unixException.rethrowAsIOException(unixPath2);
                            }
                        }
                    }
                    if (flags.copyNonPosixAttributes) {
                        unixPath.getFileSystem().copyNonPosixAttributes(n, n2);
                    }
                    if (flags.copyBasicAttributes) {
                        try {
                            UnixNativeDispatcher.futimes(n2, unixFileAttributes.lastAccessTime().to(TimeUnit.MICROSECONDS), unixFileAttributes.lastModifiedTime().to(TimeUnit.MICROSECONDS));
                        }
                        catch (UnixException unixException) {
                            if (!flags.failIfUnableToCopyBasic) break block25;
                            unixException.rethrowAsIOException(unixPath2);
                        }
                    }
                }
                bl = true;
            }
            finally {
                UnixNativeDispatcher.close(n2);
                if (!bl) {
                    try {
                        UnixNativeDispatcher.unlink(unixPath2);
                    }
                    catch (UnixException unixException) {}
                }
            }
        }
        finally {
            UnixNativeDispatcher.close(n);
        }
    }

    private static void copyLink(UnixPath unixPath, UnixFileAttributes unixFileAttributes, UnixPath unixPath2, Flags flags) throws IOException {
        byte[] byArray = null;
        try {
            byArray = UnixNativeDispatcher.readlink(unixPath);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath);
        }
        try {
            UnixNativeDispatcher.symlink(byArray, unixPath2);
            if (flags.copyPosixAttributes) {
                try {
                    UnixNativeDispatcher.lchown(unixPath2, unixFileAttributes.uid(), unixFileAttributes.gid());
                }
                catch (UnixException unixException) {}
            }
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copySpecial(UnixPath unixPath, UnixFileAttributes unixFileAttributes, UnixPath unixPath2, Flags flags) throws IOException {
        try {
            UnixNativeDispatcher.mknod(unixPath2, unixFileAttributes.mode(), unixFileAttributes.rdev());
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath2);
        }
        boolean bl = false;
        try {
            block17: {
                block16: {
                    if (flags.copyPosixAttributes) {
                        try {
                            UnixNativeDispatcher.chown(unixPath2, unixFileAttributes.uid(), unixFileAttributes.gid());
                            UnixNativeDispatcher.chmod(unixPath2, unixFileAttributes.mode());
                        }
                        catch (UnixException unixException) {
                            if (!flags.failIfUnableToCopyPosix) break block16;
                            unixException.rethrowAsIOException(unixPath2);
                        }
                    }
                }
                if (flags.copyBasicAttributes) {
                    try {
                        UnixNativeDispatcher.utimes(unixPath2, unixFileAttributes.lastAccessTime().to(TimeUnit.MICROSECONDS), unixFileAttributes.lastModifiedTime().to(TimeUnit.MICROSECONDS));
                    }
                    catch (UnixException unixException) {
                        if (!flags.failIfUnableToCopyBasic) break block17;
                        unixException.rethrowAsIOException(unixPath2);
                    }
                }
            }
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    UnixNativeDispatcher.unlink(unixPath2);
                }
                catch (UnixException unixException) {}
            }
        }
    }

    static void move(UnixPath unixPath, UnixPath unixPath2, CopyOption ... copyOptionArray) throws IOException {
        boolean bl;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            unixPath.checkWrite();
            unixPath2.checkWrite();
        }
        Flags flags = Flags.fromMoveOptions(copyOptionArray);
        if (flags.atomicMove) {
            try {
                UnixNativeDispatcher.rename(unixPath, unixPath2);
            }
            catch (UnixException unixException) {
                if (unixException.errno() == 18) {
                    throw new AtomicMoveNotSupportedException(unixPath.getPathForExceptionMessage(), unixPath2.getPathForExceptionMessage(), unixException.errorString());
                }
                unixException.rethrowAsIOException(unixPath, unixPath2);
            }
            return;
        }
        UnixFileAttributes unixFileAttributes = null;
        UnixFileAttributes unixFileAttributes2 = null;
        try {
            unixFileAttributes = UnixFileAttributes.get(unixPath, false);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath);
        }
        try {
            unixFileAttributes2 = UnixFileAttributes.get(unixPath2, false);
        }
        catch (UnixException unixException) {
            // empty catch block
        }
        boolean bl2 = bl = unixFileAttributes2 != null;
        if (bl) {
            if (unixFileAttributes.isSameFile(unixFileAttributes2)) {
                return;
            }
            if (!flags.replaceExisting) {
                throw new FileAlreadyExistsException(unixPath2.getPathForExceptionMessage());
            }
            try {
                if (unixFileAttributes2.isDirectory()) {
                    UnixNativeDispatcher.rmdir(unixPath2);
                } else {
                    UnixNativeDispatcher.unlink(unixPath2);
                }
            }
            catch (UnixException unixException) {
                if (unixFileAttributes2.isDirectory() && (unixException.errno() == 17 || unixException.errno() == 39)) {
                    throw new DirectoryNotEmptyException(unixPath2.getPathForExceptionMessage());
                }
                unixException.rethrowAsIOException(unixPath2);
            }
        }
        try {
            UnixNativeDispatcher.rename(unixPath, unixPath2);
            return;
        }
        catch (UnixException unixException) {
            if (unixException.errno() != 18 && unixException.errno() != 21) {
                unixException.rethrowAsIOException(unixPath, unixPath2);
            }
            if (unixFileAttributes.isDirectory()) {
                UnixCopyFile.copyDirectory(unixPath, unixFileAttributes, unixPath2, flags);
            } else if (unixFileAttributes.isSymbolicLink()) {
                UnixCopyFile.copyLink(unixPath, unixFileAttributes, unixPath2, flags);
            } else if (unixFileAttributes.isDevice()) {
                UnixCopyFile.copySpecial(unixPath, unixFileAttributes, unixPath2, flags);
            } else {
                UnixCopyFile.copyFile(unixPath, unixFileAttributes, unixPath2, flags, 0L);
            }
            try {
                if (unixFileAttributes.isDirectory()) {
                    UnixNativeDispatcher.rmdir(unixPath);
                } else {
                    UnixNativeDispatcher.unlink(unixPath);
                }
            }
            catch (UnixException unixException2) {
                try {
                    if (unixFileAttributes.isDirectory()) {
                        UnixNativeDispatcher.rmdir(unixPath2);
                    } else {
                        UnixNativeDispatcher.unlink(unixPath2);
                    }
                }
                catch (UnixException unixException3) {
                    // empty catch block
                }
                if (unixFileAttributes.isDirectory() && (unixException2.errno() == 17 || unixException2.errno() == 39)) {
                    throw new DirectoryNotEmptyException(unixPath.getPathForExceptionMessage());
                }
                unixException2.rethrowAsIOException(unixPath);
            }
            return;
        }
    }

    static void copy(final UnixPath unixPath, final UnixPath unixPath2, CopyOption ... copyOptionArray) throws IOException {
        boolean bl;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            unixPath.checkRead();
            unixPath2.checkWrite();
        }
        final Flags flags = Flags.fromCopyOptions(copyOptionArray);
        UnixFileAttributes unixFileAttributes = null;
        UnixFileAttributes unixFileAttributes2 = null;
        try {
            unixFileAttributes = UnixFileAttributes.get(unixPath, flags.followLinks);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath);
        }
        if (securityManager != null && unixFileAttributes.isSymbolicLink()) {
            securityManager.checkPermission(new LinkPermission("symbolic"));
        }
        try {
            unixFileAttributes2 = UnixFileAttributes.get(unixPath2, false);
        }
        catch (UnixException unixException) {
            // empty catch block
        }
        boolean bl2 = bl = unixFileAttributes2 != null;
        if (bl) {
            if (unixFileAttributes.isSameFile(unixFileAttributes2)) {
                return;
            }
            if (!flags.replaceExisting) {
                throw new FileAlreadyExistsException(unixPath2.getPathForExceptionMessage());
            }
            try {
                if (unixFileAttributes2.isDirectory()) {
                    UnixNativeDispatcher.rmdir(unixPath2);
                } else {
                    UnixNativeDispatcher.unlink(unixPath2);
                }
            }
            catch (UnixException unixException) {
                if (unixFileAttributes2.isDirectory() && (unixException.errno() == 17 || unixException.errno() == 39)) {
                    throw new DirectoryNotEmptyException(unixPath2.getPathForExceptionMessage());
                }
                unixException.rethrowAsIOException(unixPath2);
            }
        }
        if (unixFileAttributes.isDirectory()) {
            UnixCopyFile.copyDirectory(unixPath, unixFileAttributes, unixPath2, flags);
            return;
        }
        if (unixFileAttributes.isSymbolicLink()) {
            UnixCopyFile.copyLink(unixPath, unixFileAttributes, unixPath2, flags);
            return;
        }
        if (!flags.interruptible) {
            UnixCopyFile.copyFile(unixPath, unixFileAttributes, unixPath2, flags, 0L);
            return;
        }
        final UnixFileAttributes unixFileAttributes3 = unixFileAttributes;
        Cancellable cancellable = new Cancellable(){

            @Override
            public void implRun() throws IOException {
                UnixCopyFile.copyFile(unixPath, unixFileAttributes3, unixPath2, flags, this.addressToPollForCancel());
            }
        };
        try {
            Cancellable.runInterruptibly(cancellable);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(throwable);
        }
    }

    static native void transfer(int var0, int var1, long var2) throws UnixException;

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("nio");
                return null;
            }
        });
    }

    private static class Flags {
        boolean replaceExisting;
        boolean atomicMove;
        boolean followLinks;
        boolean interruptible;
        boolean copyBasicAttributes;
        boolean copyPosixAttributes;
        boolean copyNonPosixAttributes;
        boolean failIfUnableToCopyBasic;
        boolean failIfUnableToCopyPosix;
        boolean failIfUnableToCopyNonPosix;

        private Flags() {
        }

        static Flags fromCopyOptions(CopyOption ... copyOptionArray) {
            Flags flags = new Flags();
            flags.followLinks = true;
            for (CopyOption copyOption : copyOptionArray) {
                if (copyOption == StandardCopyOption.REPLACE_EXISTING) {
                    flags.replaceExisting = true;
                    continue;
                }
                if (copyOption == LinkOption.NOFOLLOW_LINKS) {
                    flags.followLinks = false;
                    continue;
                }
                if (copyOption == StandardCopyOption.COPY_ATTRIBUTES) {
                    flags.copyBasicAttributes = true;
                    flags.copyPosixAttributes = true;
                    flags.copyNonPosixAttributes = true;
                    flags.failIfUnableToCopyBasic = true;
                    continue;
                }
                if (copyOption == ExtendedCopyOption.INTERRUPTIBLE) {
                    flags.interruptible = true;
                    continue;
                }
                if (copyOption == null) {
                    throw new NullPointerException();
                }
                throw new UnsupportedOperationException("Unsupported copy option");
            }
            return flags;
        }

        static Flags fromMoveOptions(CopyOption ... copyOptionArray) {
            Flags flags = new Flags();
            for (CopyOption copyOption : copyOptionArray) {
                if (copyOption == StandardCopyOption.ATOMIC_MOVE) {
                    flags.atomicMove = true;
                    continue;
                }
                if (copyOption == StandardCopyOption.REPLACE_EXISTING) {
                    flags.replaceExisting = true;
                    continue;
                }
                if (copyOption == LinkOption.NOFOLLOW_LINKS) continue;
                if (copyOption == null) {
                    throw new NullPointerException();
                }
                throw new UnsupportedOperationException("Unsupported copy option");
            }
            flags.copyBasicAttributes = true;
            flags.copyPosixAttributes = true;
            flags.copyNonPosixAttributes = true;
            flags.failIfUnableToCopyBasic = true;
            return flags;
        }
    }
}

