/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.LastReq;
import sun.security.krb5.internal.TicketFlags;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class EncKDCRepPart {
    public EncryptionKey key;
    public LastReq lastReq;
    public int nonce;
    public KerberosTime keyExpiration;
    public TicketFlags flags;
    public KerberosTime authtime;
    public KerberosTime starttime;
    public KerberosTime endtime;
    public KerberosTime renewTill;
    public Realm srealm;
    public PrincipalName sname;
    public HostAddresses caddr;
    public int msgType;

    public EncKDCRepPart(EncryptionKey encryptionKey, LastReq lastReq, int n, KerberosTime kerberosTime, TicketFlags ticketFlags, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, KerberosTime kerberosTime5, Realm realm, PrincipalName principalName, HostAddresses hostAddresses, int n2) {
        this.key = encryptionKey;
        this.lastReq = lastReq;
        this.nonce = n;
        this.keyExpiration = kerberosTime;
        this.flags = ticketFlags;
        this.authtime = kerberosTime2;
        this.starttime = kerberosTime3;
        this.endtime = kerberosTime4;
        this.renewTill = kerberosTime5;
        this.srealm = realm;
        this.sname = principalName;
        this.caddr = hostAddresses;
        this.msgType = n2;
    }

    public EncKDCRepPart() {
    }

    public EncKDCRepPart(byte[] byArray, int n) throws Asn1Exception, IOException, RealmException {
        this.init(new DerValue(byArray), n);
    }

    public EncKDCRepPart(DerValue derValue, int n) throws Asn1Exception, IOException, RealmException {
        this.init(derValue, n);
    }

    protected void init(DerValue derValue, int n) throws Asn1Exception, IOException, RealmException {
        this.msgType = derValue.getTag() & 0x1F;
        if (this.msgType != 25 && this.msgType != 26) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.key = EncryptionKey.parse(derValue2.getData(), (byte)0, false);
        this.lastReq = LastReq.parse(derValue2.getData(), (byte)1, false);
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 2) {
            throw new Asn1Exception(906);
        }
        this.nonce = derValue3.getData().getBigInteger().intValue();
        this.keyExpiration = KerberosTime.parse(derValue2.getData(), (byte)3, true);
        this.flags = TicketFlags.parse(derValue2.getData(), (byte)4, false);
        this.authtime = KerberosTime.parse(derValue2.getData(), (byte)5, false);
        this.starttime = KerberosTime.parse(derValue2.getData(), (byte)6, true);
        this.endtime = KerberosTime.parse(derValue2.getData(), (byte)7, false);
        this.renewTill = KerberosTime.parse(derValue2.getData(), (byte)8, true);
        this.srealm = Realm.parse(derValue2.getData(), (byte)9, false);
        this.sname = PrincipalName.parse((DerInputStream)derValue2.getData(), (byte)10, (boolean)false);
        if (derValue2.getData().available() > 0) {
            this.caddr = HostAddresses.parse(derValue2.getData(), (byte)11, true);
        }
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode(int n) throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), this.key.asn1Encode());
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), this.lastReq.asn1Encode());
        derOutputStream.putInteger(BigInteger.valueOf(this.nonce));
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream);
        if (this.keyExpiration != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)3), this.keyExpiration.asn1Encode());
        }
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)4), this.flags.asn1Encode());
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)5), this.authtime.asn1Encode());
        if (this.starttime != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)6), this.starttime.asn1Encode());
        }
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)7), this.endtime.asn1Encode());
        if (this.renewTill != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)8), this.renewTill.asn1Encode());
        }
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)9), this.srealm.asn1Encode());
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)10), this.sname.asn1Encode());
        if (this.caddr != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)11), this.caddr.asn1Encode());
        }
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, true, (byte)this.msgType), derOutputStream);
        return derOutputStream2.toByteArray();
    }
}

