/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import sun.security.jca.JCAUtil;
import sun.security.provider.DSA;
import sun.security.provider.DSAKeyFactory;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKey;
import sun.security.provider.DSAPublicKeyImpl;
import sun.security.provider.ParameterCache;

public class DSAKeyPairGenerator
extends KeyPairGenerator
implements java.security.interfaces.DSAKeyPairGenerator {
    private int modlen;
    private boolean forceNewParameters;
    private DSAParameterSpec params;
    private SecureRandom random;

    public DSAKeyPairGenerator() {
        super("DSA");
        this.initialize(1024, null);
    }

    private static void checkStrength(int n) {
        if (n < 512 || n > 1024 || n % 64 != 0) {
            throw new InvalidParameterException("Modulus size must range from 512 to 1024 and be a multiple of 64");
        }
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        DSAKeyPairGenerator.checkStrength(n);
        this.random = secureRandom;
        this.modlen = n;
        this.params = null;
        this.forceNewParameters = false;
    }

    @Override
    public void initialize(int n, boolean bl, SecureRandom secureRandom) {
        DSAKeyPairGenerator.checkStrength(n);
        if (bl) {
            this.params = null;
        } else {
            this.params = ParameterCache.getCachedDSAParameterSpec(n);
            if (this.params == null) {
                throw new InvalidParameterException("No precomputed parameters for requested modulus size available");
            }
        }
        this.modlen = n;
        this.random = secureRandom;
        this.forceNewParameters = bl;
    }

    @Override
    public void initialize(DSAParams dSAParams, SecureRandom secureRandom) {
        if (dSAParams == null) {
            throw new InvalidParameterException("Params must not be null");
        }
        DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
        this.initialize0(dSAParameterSpec, secureRandom);
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter");
        }
        this.initialize0((DSAParameterSpec)algorithmParameterSpec, secureRandom);
    }

    private void initialize0(DSAParameterSpec dSAParameterSpec, SecureRandom secureRandom) {
        int n = dSAParameterSpec.getP().bitLength();
        DSAKeyPairGenerator.checkStrength(n);
        this.modlen = n;
        this.params = dSAParameterSpec;
        this.random = secureRandom;
        this.forceNewParameters = false;
    }

    @Override
    public KeyPair generateKeyPair() {
        DSAParameterSpec dSAParameterSpec;
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        try {
            if (this.forceNewParameters) {
                dSAParameterSpec = ParameterCache.getNewDSAParameterSpec(this.modlen, this.random);
            } else {
                if (this.params == null) {
                    this.params = ParameterCache.getDSAParameterSpec(this.modlen, this.random);
                }
                dSAParameterSpec = this.params;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException(generalSecurityException);
        }
        return this.generateKeyPair(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG(), this.random);
    }

    public KeyPair generateKeyPair(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, SecureRandom secureRandom) {
        BigInteger bigInteger4 = this.generateX(secureRandom, bigInteger2);
        BigInteger bigInteger5 = this.generateY(bigInteger4, bigInteger, bigInteger3);
        try {
            DSAPublicKey dSAPublicKey = DSAKeyFactory.SERIAL_INTEROP ? new DSAPublicKey(bigInteger5, bigInteger, bigInteger2, bigInteger3) : new DSAPublicKeyImpl(bigInteger5, bigInteger, bigInteger2, bigInteger3);
            DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyPair keyPair = new KeyPair(dSAPublicKey, dSAPrivateKey);
            return keyPair;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException);
        }
    }

    private BigInteger generateX(SecureRandom secureRandom, BigInteger bigInteger) {
        int[] nArray;
        BigInteger bigInteger2 = null;
        do {
            nArray = new int[5];
            for (int i = 0; i < 5; ++i) {
                nArray[i] = secureRandom.nextInt();
            }
        } while ((bigInteger2 = this.generateX(nArray, bigInteger)).signum() <= 0 || bigInteger2.compareTo(bigInteger) >= 0);
        return bigInteger2;
    }

    BigInteger generateX(int[] nArray, BigInteger bigInteger) {
        int[] nArray2 = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
        int[] nArray3 = DSA.SHA_7((int[])nArray, (int[])nArray2);
        byte[] byArray = new byte[nArray3.length * 4];
        for (int i = 0; i < nArray3.length; ++i) {
            int n = nArray3[i];
            for (int j = 0; j < 4; ++j) {
                byArray[i * 4 + j] = (byte)(n >>> 24 - j * 8);
            }
        }
        BigInteger bigInteger2 = new BigInteger(1, byArray).mod(bigInteger);
        return bigInteger2;
    }

    BigInteger generateY(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger, bigInteger2);
        return bigInteger4;
    }
}

