/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import sun.security.provider.ByteArrayAccess;
import sun.security.provider.DigestBase;

public final class MD4
extends DigestBase {
    private final int[] state;
    private final int[] x;
    private static final int S11 = 3;
    private static final int S12 = 7;
    private static final int S13 = 11;
    private static final int S14 = 19;
    private static final int S21 = 3;
    private static final int S22 = 5;
    private static final int S23 = 9;
    private static final int S24 = 13;
    private static final int S31 = 3;
    private static final int S32 = 9;
    private static final int S33 = 11;
    private static final int S34 = 15;
    private static final Provider md4Provider = new Provider("MD4Provider", 1.0, "MD4 MessageDigest"){};

    public static MessageDigest getInstance() {
        try {
            return MessageDigest.getInstance("MD4", md4Provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
    }

    public MD4() {
        super("MD4", 16, 64);
        this.state = new int[4];
        this.x = new int[16];
        this.implReset();
    }

    private MD4(MD4 mD4) {
        super((DigestBase)mD4);
        this.state = (int[])mD4.state.clone();
        this.x = new int[16];
    }

    @Override
    public Object clone() {
        return new MD4(this);
    }

    @Override
    void implReset() {
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
    }

    @Override
    void implDigest(byte[] byArray, int n) {
        long l = this.bytesProcessed << 3;
        int n2 = (int)this.bytesProcessed & 0x3F;
        int n3 = n2 < 56 ? 56 - n2 : 120 - n2;
        this.engineUpdate(padding, 0, n3);
        ByteArrayAccess.i2bLittle4((int)l, this.buffer, 56);
        ByteArrayAccess.i2bLittle4((int)(l >>> 32), this.buffer, 60);
        this.implCompress(this.buffer, 0);
        ByteArrayAccess.i2bLittle(this.state, 0, byArray, n, 16);
    }

    private static int FF(int n, int n2, int n3, int n4, int n5, int n6) {
        return (n += (n2 & n3 | ~n2 & n4) + n5) << n6 | n >>> 32 - n6;
    }

    private static int GG(int n, int n2, int n3, int n4, int n5, int n6) {
        return (n += (n2 & n3 | n2 & n4 | n3 & n4) + n5 + 1518500249) << n6 | n >>> 32 - n6;
    }

    private static int HH(int n, int n2, int n3, int n4, int n5, int n6) {
        return (n += (n2 ^ n3 ^ n4) + n5 + 1859775393) << n6 | n >>> 32 - n6;
    }

    @Override
    void implCompress(byte[] byArray, int n) {
        ByteArrayAccess.b2iLittle64((byte[])byArray, (int)n, (int[])this.x);
        int n2 = this.state[0];
        int n3 = this.state[1];
        int n4 = this.state[2];
        int n5 = this.state[3];
        n2 = MD4.FF(n2, n3, n4, n5, this.x[0], 3);
        n5 = MD4.FF(n5, n2, n3, n4, this.x[1], 7);
        n4 = MD4.FF(n4, n5, n2, n3, this.x[2], 11);
        n3 = MD4.FF(n3, n4, n5, n2, this.x[3], 19);
        n2 = MD4.FF(n2, n3, n4, n5, this.x[4], 3);
        n5 = MD4.FF(n5, n2, n3, n4, this.x[5], 7);
        n4 = MD4.FF(n4, n5, n2, n3, this.x[6], 11);
        n3 = MD4.FF(n3, n4, n5, n2, this.x[7], 19);
        n2 = MD4.FF(n2, n3, n4, n5, this.x[8], 3);
        n5 = MD4.FF(n5, n2, n3, n4, this.x[9], 7);
        n4 = MD4.FF(n4, n5, n2, n3, this.x[10], 11);
        n3 = MD4.FF(n3, n4, n5, n2, this.x[11], 19);
        n2 = MD4.FF(n2, n3, n4, n5, this.x[12], 3);
        n5 = MD4.FF(n5, n2, n3, n4, this.x[13], 7);
        n4 = MD4.FF(n4, n5, n2, n3, this.x[14], 11);
        n3 = MD4.FF(n3, n4, n5, n2, this.x[15], 19);
        n2 = MD4.GG(n2, n3, n4, n5, this.x[0], 3);
        n5 = MD4.GG(n5, n2, n3, n4, this.x[4], 5);
        n4 = MD4.GG(n4, n5, n2, n3, this.x[8], 9);
        n3 = MD4.GG(n3, n4, n5, n2, this.x[12], 13);
        n2 = MD4.GG(n2, n3, n4, n5, this.x[1], 3);
        n5 = MD4.GG(n5, n2, n3, n4, this.x[5], 5);
        n4 = MD4.GG(n4, n5, n2, n3, this.x[9], 9);
        n3 = MD4.GG(n3, n4, n5, n2, this.x[13], 13);
        n2 = MD4.GG(n2, n3, n4, n5, this.x[2], 3);
        n5 = MD4.GG(n5, n2, n3, n4, this.x[6], 5);
        n4 = MD4.GG(n4, n5, n2, n3, this.x[10], 9);
        n3 = MD4.GG(n3, n4, n5, n2, this.x[14], 13);
        n2 = MD4.GG(n2, n3, n4, n5, this.x[3], 3);
        n5 = MD4.GG(n5, n2, n3, n4, this.x[7], 5);
        n4 = MD4.GG(n4, n5, n2, n3, this.x[11], 9);
        n3 = MD4.GG(n3, n4, n5, n2, this.x[15], 13);
        n2 = MD4.HH(n2, n3, n4, n5, this.x[0], 3);
        n5 = MD4.HH(n5, n2, n3, n4, this.x[8], 9);
        n4 = MD4.HH(n4, n5, n2, n3, this.x[4], 11);
        n3 = MD4.HH(n3, n4, n5, n2, this.x[12], 15);
        n2 = MD4.HH(n2, n3, n4, n5, this.x[2], 3);
        n5 = MD4.HH(n5, n2, n3, n4, this.x[10], 9);
        n4 = MD4.HH(n4, n5, n2, n3, this.x[6], 11);
        n3 = MD4.HH(n3, n4, n5, n2, this.x[14], 15);
        n2 = MD4.HH(n2, n3, n4, n5, this.x[1], 3);
        n5 = MD4.HH(n5, n2, n3, n4, this.x[9], 9);
        n4 = MD4.HH(n4, n5, n2, n3, this.x[5], 11);
        n3 = MD4.HH(n3, n4, n5, n2, this.x[13], 15);
        n2 = MD4.HH(n2, n3, n4, n5, this.x[3], 3);
        n5 = MD4.HH(n5, n2, n3, n4, this.x[11], 9);
        n4 = MD4.HH(n4, n5, n2, n3, this.x[7], 11);
        n3 = MD4.HH(n3, n4, n5, n2, this.x[15], 15);
        this.state[0] = this.state[0] + n2;
        this.state[1] = this.state[1] + n3;
        this.state[2] = this.state[2] + n4;
        this.state[3] = this.state[3] + n5;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                md4Provider.put("MessageDigest.MD4", "sun.security.provider.MD4");
                return null;
            }
        });
    }
}

