/*
 * Decompiled with CFR 0.152.
 */
package sun.tracing;

import com.sun.tracing.Probe;
import com.sun.tracing.Provider;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import sun.tracing.ProbeSkeleton;

class MultiplexProbe
extends ProbeSkeleton {
    private Set<Probe> probes = new HashSet<Probe>();

    MultiplexProbe(Method method, Set<Provider> set) {
        super(method.getParameterTypes());
        for (Provider provider : set) {
            Probe probe = provider.getProbe(method);
            if (probe == null) continue;
            this.probes.add(probe);
        }
    }

    @Override
    public boolean isEnabled() {
        for (Probe probe : this.probes) {
            if (!probe.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void uncheckedTrigger(Object[] objectArray) {
        for (Probe probe : this.probes) {
            try {
                ProbeSkeleton probeSkeleton = (ProbeSkeleton)probe;
                probeSkeleton.uncheckedTrigger(objectArray);
            }
            catch (ClassCastException classCastException) {
                try {
                    Method method = Probe.class.getMethod("trigger", Class.forName("[java.lang.Object"));
                    method.invoke((Object)probe, objectArray);
                }
                catch (Exception exception) {
                    assert (false);
                }
            }
        }
    }
}

